TITLE MMC5

____________________________________________________________________________________________
; Mapper #005, Nintendo MMC5

; $5130: ????????
; $5800: ????????
____________________________________________________________________________________________

Mapper005:

    if D$Cartridge@SizeWRAM < 16, mov D$Cartridge@SizeWRAM 16

    ; Add MMC5 sound
    call MMC5Sound

    ; IRQ counter
    mov D$HSyncHook @HSync

    ; CROM reading
    PPURead 00000, 01FFF, @ReadCROM

    ; - Memory mapping -
    ; MMC settings
    CPUWrite 05100, 05100, @5100
    CPUWrite 05101, 05101, @5101
    CPUWrite 05102, 05102, @5102
    CPUWrite 05103, 05103, @5103
    CPUWrite 05104, 05104, @5104
    CPUWrite 05105, 05105, @5105
    CPUWrite 05106, 05106, @5106
    CPUWrite 05107, 05107, @5107
    ; PROM/XRAM switch
    CPUWrite 05113, 05113, @5113
    CPUWrite 05114, 05114, @5114
    CPUWrite 05115, 05115, @5115
    CPUWrite 05116, 05116, @5116
    CPUWrite 05117, 05117, @5117
    ; CROM switch
    CPUWrite 05120, 05120, @5120
    CPUWrite 05121, 05121, @5121
    CPUWrite 05122, 05122, @5122
    CPUWrite 05123, 05123, @5123
    CPUWrite 05124, 05124, @5124
    CPUWrite 05125, 05125, @5125
    CPUWrite 05126, 05126, @5126
    CPUWrite 05127, 05127, @5127
    CPUWrite 05128, 05128, @5128
    CPUWrite 05129, 05129, @5129
    CPUWrite 0512A, 0512A, @512A
    CPUWrite 0512B, 0512B, @512B
    ; Split
    CPUWrite 05200, 05200, @5200
    CPUWrite 05201, 05201, @5201
    CPUWrite 05202, 05202, @5202
    ; IRQ counter
    CPUWrite 05203, 05203, @5203
    CPUWrite 05204, 05204, @5204
    CPURead  05204, 05204, @Read5204
    ; Multiplier
    CPUWrite 05205, 05205, @5205
    CPUWrite 05206, 05206, @5206
    CPURead  05205, 05205, @Read5205
    CPURead  05206, 05206, @Read5206
    ; ExCiRAM
    CPUWrite 05C00, 05FFF, @5C00_5FFF
    CPURead  05C00, 05FFF, @Read5C00_5FFF
    ; PROM/XRAM
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPUWrite 08000, 09FFF, @8000_9FFF
    CPUWrite 0A000, 0BFFF, @A000_BFFF
    CPUWrite 0C000, 0DFFF, @C000_DFFF
    CPURead  06000, 07FFF, @ReadXRAM
    CPURead  08000, 09FFF, @Read8000_9FFF
    CPURead  0A000, 0BFFF, @ReadA000_BFFF
    CPURead  0C000, 0DFFF, @ReadC000_DFFF

    ; Set modes
    mov B$PMode PMODE_8K
    mov B$CMode CMODE_1K

    ; Set banks
    setXRAM 06000, 0
    setPROM 08000, LAST_BANK
    setPROM 0A000, LAST_BANK
    setPROM 0C000, LAST_BANK
    setPROM 0E000, LAST_BANK
    mov eax 0
L0: mov D$CROMBank+eax*4 eax
    inc eax | on eax < 8, L0<
    mov eax 4
L0: mov D$BgROMBank+eax*4-010 eax
    mov D$BgROMBank+eax*4     eax
    inc eax | on eax < 8, L0<
    call @UpdateCROM
    call @UpdateBgROM

CPUWrite 05800, 05800, DoNothing
    ret

; Graphic modes
@5101: and al 3 | mov B$CMode al | ret
@5104: and al 3 | mov B$GMode al | ret

; Mirroring/fill/ExCiRAM
@5105:

    mov edx eax | and edx 03 | shl edx 10 | mov D$IndexCiRAM+00 edx | shr eax 2
    mov edx eax | and edx 03 | shl edx 10 | mov D$IndexCiRAM+04 edx | shr eax 2
    mov edx eax | and edx 03 | shl edx 10 | mov D$IndexCiRAM+08 edx | shr eax 2
    mov edx eax | and edx 03 | shl edx 10 | mov D$IndexCiRAM+0C edx | shr eax 2
    ret

; Fill settings
@5106: mov D$FillCharacter eax | ret
@5107: and al 03 | shl eax 2 | mov D$FillAttribute eax | ret

; CROM banks
@5120: mov D$CROMbank+00  eax | jmp @UpdateCROM
@5121: mov D$CROMbank+04  eax | jmp @UpdateCROM
@5122: mov D$CROMbank+08  eax | jmp @UpdateCROM
@5123: mov D$CROMbank+0C  eax | jmp @UpdateCROM
@5124: mov D$CROMbank+010 eax | jmp @UpdateCROM
@5125: mov D$CROMbank+014 eax | jmp @UpdateCROM
@5126: mov D$CROMbank+018 eax | jmp @UpdateCROM
@5127: mov D$CROMbank+01C eax | jmp @UpdateCROM

@UpdateCROM:

    if. B$CMode = CMODE_8K
        swap CROM, 8k,  0000, D$CROMBank+01C
    else
    if. B$CMode = CMODE_4K
        swap CROM, 4k,  0000, D$CROMBank+0C
        swap CROM, 4k, 01000, D$CROMBank+01C
    else
    if. B$CMode = CMODE_2K
        swap CROM, 2k,  0000, D$CROMBank+04
        swap CROM, 2k,  0800, D$CROMBank+0C
        swap CROM, 2k, 01000, D$CROMBank+014
        swap CROM, 2k, 01800, D$CROMBank+01C
    else
    if. B$CMode = CMODE_1K
        swap CROM, 1k,  0000, D$CROMBank+00
        swap CROM, 1k,  0400, D$CROMBank+04
        swap CROM, 1k,  0800, D$CROMBank+08
        swap CROM, 1k,  0C00, D$CROMBank+0C
        swap CROM, 1k, 01000, D$CROMBank+010
        swap CROM, 1k, 01400, D$CROMBank+014
        swap CROM, 1k, 01800, D$CROMBank+018
        swap CROM, 1k, 01C00, D$CROMBank+01C
    endif
    ret

; BgROM banks
[BgROMBank CROMBank+020]
@5128: mov D$BgROMBank+00 eax | mov D$BgROMBank+010 eax | jmp @UpdateBgROM
@5129: mov D$BgROMBank+04 eax | mov D$BgROMBank+014 eax | jmp @UpdateBgROM
@512A: mov D$BgROMBank+08 eax | mov D$BgROMBank+018 eax | jmp @UpdateBgROM
@512B: mov D$BgROMBank+0C eax | mov D$BgROMBank+01C eax | jmp @UpdateBgROM

@UpdateBgROM:

    if. B$CMode = CMODE_8K
        swap BgROM, 8k,  0000, D$BgROMBank+01C
    else
    if. B$CMode = CMODE_4K
        swap BgROM, 4k,  0000, D$BgROMBank+0C
        swap BgROM, 4k, 01000, D$BgROMBank+01C
    else
    if. B$CMode = CMODE_2K
        swap BgROM, 2k,  0000, D$BgROMBank+04
        swap BgROM, 2k,  0800, D$BgROMBank+0C
        swap BgROM, 2k, 01000, D$BgROMBank+014
        swap BgROM, 2k, 01800, D$BgROMBank+01C
    else
    if. B$CMode = CMODE_1K
        swap BgROM, 1k,  0000, D$BgROMBank+00
        swap BgROM, 1k,  0400, D$BgROMBank+04
        swap BgROM, 1k,  0800, D$BgROMBank+08
        swap BgROM, 1k,  0C00, D$BgROMBank+0C
        swap BgROM, 1k, 01000, D$BgROMBank+010
        swap BgROM, 1k, 01400, D$BgROMBank+014
        swap BgROM, 1k, 01800, D$BgROMBank+018
        swap BgROM, 1k, 01C00, D$BgROMBank+01C
    endif
    ret

@ReadCROM:

    ifNotFlag B$Mask SPRITES_VISIBLE+BG_VISIBLE, jmp ReadCROM
    on D$PPUCycle < 256, @ReadBgROM
    on D$PPUCycle < 320, ReadCROM
    on D$PPUCycle < 341, @ReadBgROM
    jmp ReadCROM

@ReadBgROM:

    movzx ebx ah | and ebx 01C
    and eax 03FF | add eax D$IndexBgROM+ebx
    add eax D$pCROM
    movzx eax B$eax
    ret
____________________________________________________________________________________________
; Split settings
____________________________________________________________________________________________

@5200:

    call PPUSynchronize

    ; ESxTTTTT
    test al 080 | setnz B$SplitEnabled
    test al 040 | setnz B$SplitFromRight
    and  al 01F | mov   B$SplitTile al
    ret

@5201:

    call PPUSynchronize

    mov B$SplitScroll al
    ret

@5202:

    call PPUSynchronize
    and al 03F | shl eax 12
    mov edx D$Cartridge@SizeCROM | shl edx 10
    dec edx | and eax edx
    mov D$SplitOffset eax
    ret

____________________________________________________________________________________________
; IRQ counter
____________________________________________________________________________________________

@5203:

    ClearIRQ IRQ_CARTRIDGE
    mov D$IRQStop eax
    ret

@5204:

    ClearIRQ IRQ_CARTRIDGE
    test al 080 | setnz B$IRQEnabled
    ret

@Read5204:

    mov eax D$IRQStatus
    and B$IRQStatus 0FF-080
    ret

@HSync:

    ; GFX on?
    ifFlag. B$Mask BG_VISIBLE+SPRITES_VISIBLE
        on D$PPUCycle = 342, end
        or B$IRQStatus 040
        inc D$IRQCounter
        mov B$IRQClear 0
    endif

    inc B$IRQClear
    if. B$IRQClear > 1
        ClearIRQ IRQ_CARTRIDGE
        mov D$IRQCounter 0-1
        and B$IRQStatus 0FF-0C0
    else
        ; Scanline hit?
        mov eax D$IRQStop
        if eax = D$IRQCounter, or B$IRQStatus 080
    endif

    ; Time for IRQ?
    if B$IRQEnabled = &TRUE,
        ifFlag B$IRQStatus 080,
            ifFlag B$IRQStatus 040,
                SetIRQ PPU, IRQ_CARTRIDGE
    ret

____________________________________________________________________________________________
; Multiplier
____________________________________________________________________________________________

@5205:     mov D$Factor1 eax | ret
@5206:     mov D$Factor2 eax | ret
@Read5205: mov eax D$Factor1 | mul D$Factor2 | movzx eax al | ret
@Read5206: mov eax D$Factor1 | mul D$Factor2 | movzx eax ah | ret

____________________________________________________________________________________________
; ExCiRAM
____________________________________________________________________________________________

[ExCiRAM NameTable+0800]
@5C00_5FFF:

    and edx 03FF
    if. B$GMode = GMODE_EXRAM
        mov B$ExCiRAM+edx al
    else
    if. B$GMode != GMODE_EXRAM_WP
        ;ifFlag B$IRQStatus 040, mov al 0
        mov B$ExCiRAM+edx al
    endif
    ret

@Read5C00_5FFF:

    on B$GMode < GMODE_EXRAM, ReadVoid
    and eax 03FF
    movzx eax B$ExCiRAM+eax
    ret

____________________________________________________________________________________________
; PROM/XRAM
____________________________________________________________________________________________

@5100: and al 3 | mov B$PMode        al | ret
@5102: and al 3 | mov B$XRAMWrite+00 al | ret
@5103: and al 3 | mov B$XRAMWrite+01 al | ret

@5113:

    ; $6000-$7FFF
    setXRAM 06000, eax
    ret

@5114:

    ; $8000-$9FFF
    if. B$PMode = PMODE_8K
        ifFlag.. al MMC5_SWITCH_PROM
            setPROM 08000, eax
        else..
            setXRAM 08000, eax
        endif..
    endif
    ret

@5115:

    ; $A000-$BFFF
    if. B$PMode = PMODE_8K
        ifFlag.. al MMC5_SWITCH_PROM
            setPROM 0A000, eax
        else..
            setXRAM 0A000, eax
        endif..
    endif

    ; $8000-$BFFF
    on  B$PMode = PMODE_16K_8K, F0>
    if. B$PMode = PMODE_16K
    F0: ifFlag.. al MMC5_SWITCH_PROM
            and al 0FE
            setPROM 08000, eax | inc eax
            setPROM 0A000, eax
        else..
            and al 0FE
            setXRAM 08000, eax | inc eax
            setXRAM 0A000, eax
        endif..
    endif
    ret

@5116:

    ; $C000-$DFFF
    on  B$PMode = PMODE_16K_8K, F0>
    if. B$PMode = PMODE_8K
    F0: ifFlag.. al MMC5_SWITCH_PROM
            setPROM 0C000, eax
        else..
            setXRAM 0C000, eax
        endif..
    endif
    ret

@5117:

    ifNotFlag eax MMC5_SWITCH_PROM, ret

    ; $8000-$FFFF
    if. B$Pmode = PMODE_32K
        and al 0FC
        setPROM 08000, eax | inc eax
        setPROM 0A000, eax | inc eax
        setPROM 0C000, eax | inc eax
        setPROM 0E000, eax
    endif

    ; $C000-$FFFF
    if. B$PMode = PMODE_16K
        and al 0FE
        setPROM 0C000, eax | inc eax
        setPROM 0E000, eax
    endif

    ; $E000-$FFFF
    on  B$PMode = PMODE_16K_8K, F0>
    if. B$PMode = PMODE_8K
    F0: setPROM 0E000, eax
    endif
    ret

; PROM/XRAM read/write
@6000_7FFF: if. W$XRAMWrite = 0102 | test B$XRAMEnabled 01 | jnz @WriteXRAM | endif | ret
@8000_9FFF: if. W$XRAMWrite = 0102 | test B$XRAMEnabled 02 | jnz @WriteXRAM | endif | ret
@A000_BFFF: if. W$XRAMWrite = 0102 | test B$XRAMEnabled 04 | jnz @WriteXRAM | endif | ret
@C000_DFFF: if. W$XRAMWrite = 0102 | test B$XRAMEnabled 08 | jnz @WriteXRAM | endif | ret
@Read8000_9FFF: test B$XRAMEnabled 02 | jnz @ReadXRAM | endif | jmp ReadPROM
@ReadA000_BFFF: test B$XRAMEnabled 04 | jnz @ReadXRAM | endif | jmp ReadPROM
@ReadC000_DFFF: test B$XRAMEnabled 08 | jnz @ReadXRAM | endif | jmp ReadPROM


@ReadXRAM:

    sub eax 06000
    mov ebx eax | shr ebx 13 | and ebx 3
    and eax 01FFF
    add eax D$IndexXRAM+ebx*4
    movzx eax B$WRAM+eax
    ret

@WriteXRAM:

    sub edx 06000
    mov ebx edx | shr ebx 13 | and ebx 3
    and edx 01FFF
    add edx D$IndexXRAM+ebx*4
    mov B$WRAM+edx al
    ret

[setPROM | #=2 | and B$XRAMEnabled (not (01 shl ((#1 - 06000) shr 13))) | swap PROM, 8k, #1, #2]
[setXRAM | #=2 | or  B$XRAMEnabled (    (01 shl ((#1 - 06000) shr 13))) | swap XRAM, 8k, #1, #2]
[MMC5_SWITCH_PROM 080]

____________________________________________________________________________________________
; MMC5 graphics
____________________________________________________________________________________________

DoMMC5Graphics:

    ifNotFlag B$Mask BG_VISIBLE+SPRITES_VISIBLE, ret

    ; Time to split?
    on B$SplitEnabled = &FALSE, Q0>
    mov eax D$PPUCycle
    if. eax >= 320 | sub eax 320
    else | add eax 010 | endif
    shr eax 3
    if. B$SplitFromRight != &FALSE
        on eax <  D$SplitTile, Q0>
    else
        on eax >= D$SplitTile, Q0>
    endif

    ; Split
    mov edx D$nScanline | shr edx 3 | shl edx 5
    movzx eax B$ExCiRAM+edx+eax | shl eax 4
    mov edx D$nScanline | and edx 07
    add eax edx
    add eax D$pCROM
    add eax D$SplitOffset
    mov dl B$eax, dh B$eax+8
    mov W$Patterns dx
    ret


Q0: mov eax D$VRAMAddress
    shr eax 10 | and eax 3
    if. D$IndexCiRAM+eax*4 = 0C00
        on B$GMode = GMODE_EXGFX, @FillExGfx
        jmp @FillNormal
    else
        on B$GMode = GMODE_EXGFX, @ExGfx
        jmp @Normal
    endif
    ret
____________________________________________________________________________________________

@Normal: jmp ReadPattern

@FillNormal:

    copy D$FillCharacter D$NTByte
    copy D$FillAttribute D$Attribute
    jmp ReadPattern
____________________________________________________________________________________________

@ExGfx:

    ; Tile
    mov edx D$NTByte | shl edx 4
    mov eax D$VRAMAddress | shr eax 12
    or edx eax

    ; Attribute
    mov eax D$VRAMAddress | and eax 03FF
    movzx eax B$ExCiRAM+eax
    push eax
        and eax 0C0 | shr eax 4
        mov D$Attribute eax
    pop eax

    ; Bank offset
    and eax 03F | shl eax 12
    or edx eax

    ; Pattern
    mov ecx D$Cartridge@SizeCROM | shl ecx 10 | dec ecx
    and edx ecx
    add edx D$pCROM
    mov al B$edx
    mov ah B$edx+8
    mov W$Patterns ax
    ret

@FillExGfx:

    ; Tile
    mov edx D$FillCharacter | shl edx 4
    mov eax D$VRAMAddress | shr eax 12
    or edx eax

    ; Attribute
    copy D$FillAttribute D$Attribute

    ; Bank offset
    mov eax D$VRAMAddress | and eax 03FF
    movzx eax B$ExCiRAM+eax
    and eax 03F | shl eax 12
    or edx eax

    ; Pattern
    mov ecx D$Cartridge@SizeCROM
    shl ecx 10 | dec ecx
    and edx ecx
    add edx D$pCROM
    mov ah B$edx
    mov al B$edx+8
    mov W$Patterns ax
    ret
____________________________________________________________________________________________
; Bankswitch
____________________________________________________________________________________________

SwapXRAM:

    arguments @Length, @Address, @Bank
    on D$Cartridge@SizeWRAM = 0, Q0>>
    pushad

        ; Adjust bank number
        mov eax D@Bank

        if. eax >= 4

            mov ecx D@Address | sub ecx 06000 | shr ecx 13
            mov edx 01 | shl edx cl | not edx

            if B$Cartridge@SizeWRAM <= 16, and D$XRAMEnabled edx
            if B$Cartridge@SizeWRAM =  32, mov eax 1
            if B$Cartridge@SizeWRAM =  64, and D$XRAMEnabled edx

        else

            if B$Cartridge@SizeWRAM <= 32, mov eax 0

        endif

        mul D@Length
        mov ebx D$Cartridge@SizeWRAM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 13
        mov ebx D@Address | sub ebx 06000 | shr ebx 13
    L0: mov D$IndexXRAM+ebx*4 eax | add eax 02000 | inc ebx | dec ecx | jnz L0<
    popad
Q0: return

SwapBgROM:

    arguments @Length, @Address, @Bank
    call PPUSynchronize

    pushad

        ; Adjust bank number
        mov eax D@Bank
        mul D@Length
        mov ebx D$Cartridge@SizeCROM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 10
        mov ebx D@Address | shr ebx 10
    L0: mov D$IndexBgROM+ebx*4 eax | add eax 0400 | inc ebx | dec ecx | jnz L0<

    popad
    return
____________________________________________________________________________________________

enumerate 0,
    PMODE_32K,
    PMODE_16K,
    PMODE_16K_8K,
    PMODE_8K
enumerate 0,
    GMODE_SPLIT,
    GMODE_EXGFX,
    GMODE_EXRAM,
    GMODE_EXRAM_WP
enumerate 0,
    CMODE_8K,
    CMODE_4K,
    CMODE_2K,
    CMODE_1K
____________________________________________________________________________________________
