TITLE MMC3

[MMC3_SWAP_PROM 040
 MMC3_SWAP_CROM 080]

MMC3:

    setIRQCounter IRQHookPPU, &NULL

    ; Hooks
    mov D$fnCROMUpdate @UpdatePROM
    mov D$fnPROMUpdate @UpdateCROM
    if D$Cartridge@SizeCROM = 0, mov D$fnCROMUpdate @UpdateCRAM

    ; - Memory mapping -

    ; MMC6B games don't toggle WRAM in the same way. (???)
    on D$Cartridge@PROMCRC32 = 0BEB8_8304, S0> ; Startropics (U)
    on D$Cartridge@PROMCRC32 = 0AC74_DD5C, S0> ; Startropics (E)
    on D$Cartridge@PROMCRC32 = 080FB_117E, S0> ; Startropics 2 - Zoda's Revenge (U)

    ; WRAM toggle
    CPUWrite 06000, 07FFF, @WriteWRAM
    CPURead  06000, 07FFF, @ReadWRAM

S0: mov ecx 08000
L0: push ecx

        and ecx 0E001
        if ecx = 08000, mov eax @Command
        if ecx = 08001, mov eax @Bankswitch
        if ecx = 0A000, mov eax @Mirroring
        if ecx = 0A001, mov eax @WRAMEnable
        if ecx = 0C000, mov eax @IRQLatch
        if ecx = 0C001, mov eax @ResetIRQ
        if ecx = 0E000, mov eax @DisableIRQ
        if ecx = 0E001, mov eax @EnableIRQ

    pop ecx
    CPUWrite ecx, ecx, eax
    inc cx | jnz L0<<

    ; Swap last 16k PROM bank to $C000
    swap PROM, 16k, 0C000, LAST_BANK

    ; Reset banks
    mov D$Bank+00  0
    mov D$Bank+04  1
    mov D$Bank+08  4
    mov D$Bank+0C  5
    mov D$Bank+010 6
    mov D$Bank+014 7
    mov D$Bank+018 0
    mov D$Bank+01C 1

    mov B$WRAMEnabled &TRUE
    mov D$IRQCounter 0FF
    mov D$IRQLatch 0FF
    ret

____________________________________________________________________________________________

@Command:

    ; Save command
    mov D$Command eax
    call D$fnPROMUpdate
    call D$fnCROMUpdate
    ret

@Bankswitch:

    ; Set bank
    mov edx D$Command | and edx 7
    if edx <= 1, shr eax 1
    mov D$Bank+edx*4 eax

    ; Update banks
    call D$fnPROMUpdate
    call D$fnCROMUpdate
    ret

@Mirroring:

    ifFlag. eax 1
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif
    ret

@WRAMEnable:

    test al 080 | setnz B$WRAMEnabled
    ret
____________________________________________________________________________________________

@IRQLatch:

    call PPUSynchronize

    ; Hack for some games that lock up
    if eax = 240, inc eax

    mov D$IRQLatch eax

copy D$ResetIRQ D$Latched
xor D$Latched &TRUE
if D$ResetIRQ = &TRUE,
    mov D$IRQCounter eax
    ret

@ResetIRQ:

    call PPUSynchronize

    copy D$IRQLatch D$IRQCounter
    mov D$Divide42 33
    mov D$A13 1
    ret

@DisableIRQ:

    call PPUSynchronize
    ClearIRQ IRQ_CARTRIDGE

    mov B$IRQEnabled &FALSE
mov B$ResetIRQ &TRUE
    ret

@EnableIRQ:

    call PPUSynchronize

 mov B$IRQEnabled &TRUE

if D$Latched = &TRUE
    copy D$IRQLatch D$IRQCounter
    ret
____________________________________________________________________________________________

@UpdatePROM:

    ; $8000 <--> $C000 swap?
    ifNotFlag. D$Command MMC3_SWAP_PROM
        swap PROM, 8k, 08000, D$Bank+018
        swap PROM, 8k, 0C000, LAST_BANK-1
    else
        swap PROM, 8k, 0C000, D$Bank+018
        swap PROM, 8k, 08000, LAST_BANK-1
    endif

    ; $A000 and $E000
    swap PROM, 8k, 0A000, D$Bank+01C
    swap PROM, 8k, 0E000, LAST_BANK
    ret

@UpdateCROM:

    ; $0000 <--> $1000 swap?
    mov edx 0
    ifFlag D$Command MMC3_SWAP_CROM, mov edx 01000

    ; Set banks
    swap CROM, 2k, edx, D$Bank+00  | add edx 0800
    swap CROM, 2k, edx, D$Bank+04  | sub edx 0800
    xor edx 01000
    swap CROM, 1k, edx, D$Bank+08  | add edx 0400
    swap CROM, 1k, edx, D$Bank+0C  | add edx 0400
    swap CROM, 1k, edx, D$Bank+010 | add edx 0400
    swap CROM, 1k, edx, D$Bank+014
    ret

@UpdateCRAM:

    ; No bank switch, just acknowledge $0000 <--> $1000 swap
    mov edx 0
    ifFlag D$Command MMC3_SWAP_CROM, mov edx 01000
    swap CRAM, 4k, edx, 0 | xor edx 01000
    swap CRAM, 4k, edx, 1
    ret

____________________________________________________________________________________________

@ReadWRAM:

    on B$WRAMEnabled = &TRUE, ReadWRAM
    jmp ReadVoid

@WriteWRAM:

    on B$WRAMEnabled = &TRUE, WriteWRAM
    jmp WriteVoid
____________________________________________________________________________________________
; Mapper #115, Yuu Yuu Hakusho Final

; $6000: override PROM settings
____________________________________________________________________________________________

Mapper115:

    ; MMC3
    call MMC3

    ; Memory mapping
    CpuWrite 06000, 06000, @6000
    CPUWrite 06001, 07FFF, @6001_7FFF
    CPURead  06000, 07FFF, ReadVoid
    ret

@6000:

    mov D$Register eax

@6001_7FFF:

    ; Refresh PROM
    call MMC3@UpdatePROM
    ifFlag. B$Register 080
        mov eax D$Register | and eax 07
        swap PROM, 16k, 08000, eax
    endif
    ret
____________________________________________________________________________________________
; Mapper #249, ????????

; Encrypted MMC3
; $5000: ------S- - (S = 1) Convert bank numbers
____________________________________________________________________________________________

Mapper249:

    ; MMC3
    call MMC3

    ; Memory mapping
    CPUWrite 05000, 05000, @5000
S0: mov ecx 08000
L0: push ecx

        and ecx 0F701
        if ecx = 08000, mov eax @8000
        if ecx = 08001, mov eax @8001
        if ecx = 0A000, mov eax MMC3@Mirroring
        if ecx = 0A001, mov eax MMC3@WRAMEnable
        if ecx = 0C000, mov eax MMC3@IRQLatch
        if ecx = 0C001, mov eax MMC3@ResetIRQ
        if ecx = 0E000, mov eax MMC3@DisableIRQ
        if ecx = 0E001, mov eax MMC3@EnableIRQ

    pop ecx
    CPUWrite ecx, ecx, eax
    inc cx | jnz L0<<
    ret

@5000: test al 02 | setnz B$Register | ret
@8000: and eax 07 | jmp MMC3@Command

@8001:

    on B$Register = &FALSE, MMC3@Bankswitch

    if. B$Command >= 6
        if.. eax >= 020
            sub eax 020
            jmp S0>>
        endif..
    endif

    ; Convert #1
    mov edx 0
    ifFlag al 01,  or dl (1 shl 0)
    ifFlag al 02,  or dl (1 shl 1)
    ifFlag al 04,  or dl (1 shl 5)
    ifFlag al 08,  or dl (1 shl 2)
    ifFlag al 010, or dl (1 shl 6)
    ifFlag al 020, or dl (1 shl 7)
    ifFlag al 040, or dl (1 shl 4)
    ifFlag al 080, or dl (1 shl 3)
    mov eax edx
    jmp MMC3@BankSwitch

    ; Convert #2
S0: mov edx 0
    ifFlag eax 01,  or edx (1 shl 0)
    ifFlag eax 02,  or edx (1 shl 3)
    ifFlag eax 04,  or edx (1 shl 4)
    ifFlag eax 08,  or edx (1 shl 2)
    ifFlag eax 010, or edx (1 shl 1)
    mov eax edx
    jmp MMC3@Bankswitch
____________________________________________________________________________________________
; Mapper #198, ????????

; Has extra RAM at $4019-$7FFF
; No IRQ counter
____________________________________________________________________________________________

Mapper198:

    ; MMC3
    call MMC3

    ; Memory mapping
    CPUWrite 04019, 05FFF, @4019_5FFF
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  04019, 05FFF, @Read4019_5FFF
    CPURead  06000, 07FFF, @Read6000_7FFF
    mov ecx 08001
L0: CPUWrite ecx, ecx, @8001
    add ecx 02 | on ecx < 0A000, L0<
    CPUWrite 0C000, 0FFFF, WriteVoid
    ret

[@ExRAM WRAM+01000]

@4019_5FFF:

    sub edx 04019
    mov B@ExRAM+edx al
    ret

@Read4019_5FFF:

    sub eax 04019
    movzx eax B@ExRAM+eax
    ret

@6000_7FFF:

    and edx 0FFF
    mov B$WRAM+edx al
    ret

@Read6000_7FFF:

    and eax 0FFF
    movzx eax B$WRAM+eax
    ret

@8001:

    call MMC3@BankSwitch
    if D$Bank+018 >= 050, mov D$Bank+018 04F
    jmp D$fnPROMUpdate

____________________________________________________________________________________________
; Mapper #248, Bao Qing Tian

; $6000-$7FFF: override PROM settings
____________________________________________________________________________________________

Mapper248:

    ; MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  06000, 07FFF, ReadVoid
    mov ecx 08000
L0: CPUWrite ecx, ecx, @8000
    add ecx 2
    on ecx < 0A000, L0<
    ret

@6000_7FFF:

    mov D$Register eax
    jmp @UpdatePROM

@8000: and eax 07 | jmp MMC3@Command
____________________________________________________________________________________________

@UpdatePROM:

    ifFlag. B$Register 080
        mov eax D$Register | and eax 0F
        swap PROM, 16k, 08000, eax
    else
        and D$Bank+018 01F | swap PROM, 8k, 08000, D$Bank+018
        and D$Bank+01C 01F | swap PROM, 8k, 0A000, D$Bank+01C
    endif
    ret
____________________________________________________________________________________________
; Mapper #114, Lion King

; $6000-$7FFF: override PROM settings
; Uses a little different registers
____________________________________________________________________________________________

Mapper114:

    ; IRQ
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  06000, 07FFF, ReadVoid
    CPUWrite 08000, 09FFF, @8000_9FFF
    CPUWrite 0A000, 0BFFF, @A000_BFFF
    CPUWrite 0C000, 0DFFF, @C000_DFFF
    CPUWrite 0E000, 0FFFF, WriteVoid
    CPUwrite 0E002, 0E002, @E002
    CPUwrite 0E003, 0E003, @E003

    ; Last bank
    swap PROM, 16k, 0C000, LAST_BANK
    mov D$Bank+018 0
    mov D$Bank+01C 1
    ret

@6000_7FFF:

    mov D$Register eax
    jmp @UpdatePROM

@8000_9FFF:

    jmp MMC3@Mirroring

@A000_BFFF:

    [@Table: B$ 0 3 1 5 6 7 2 4]
    mov B$Latch &TRUE
    and eax 07
    movzx eax B@Table+eax
    jmp MMC3@Command

@C000_DFFF:

    if B$Latch = &FALSE, ret
    mov B$Latch &FALSE
    jmp MMC3@Bankswitch

@E002:

    call PPUSynchronize

    ClearIRQ IRQ_CARTRIDGE
    ret

@E003:

    call PPUSynchronize

    test al al | setnz B$IRQEnabled
    mov D$IRQCounter eax
    ret
____________________________________________________________________________________________

@UpdatePROM:

    ifFlag. B$Register 080
        mov eax D$Register
        and eax 01F
        swap PROM, 16k, 08000, eax
    else
        swap PROM, 8k,  08000, D$Bank+018
        swap PROM, 8k,  0A000, D$Bank+01C
    endif
    ret
____________________________________________________________________________________________
; Mapper #47, NES-QJ

; $6000-$7FFF: Set PROM/CROM masks
____________________________________________________________________________________________

Mapper047:

    ; MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM
    mov D$fnCROMUpdate @UpdateCROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  06000, 07FFF, ReadVoid
    call @UpdatePROM
    call @UpdateCROM
    ret

@6000_7FFF:

    if. D$Cartridge@PROMCRC32 = 07EEF_434C ; 3-in-1 (E) [!]
        shr al 1
    else
        shl al 1
    endif
    and eax 03
    mov D$Register eax
    call @UpdatePROM
    call @UpdateCROM
    ret

@UpdatePROM:

    mov ecx D$Register | shl ecx 3
    mov edx 0F
    if D$Cartridge@PROMCRC32 = 07EEF_434C, ; 3-in-1 (E) [!]
        if D$Register != 2,
            mov edx 7

    ; $8000 and $C000
    ifNotFlag. B$Command MMC3_SWAP_PROM
        mov eax D$Bank+018  |               or eax ecx | swap PROM, 8k, 08000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ecx | swap PROM, 8k, 0C000, eax
    else
        mov eax D$Bank+018  |               or eax ecx | swap PROM, 8k, 0C000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ecx | swap PROM, 8k, 08000, eax
    endif

    ; $A000 and $E000
    mov eax D$Bank+01C |             | or eax ecx | swap PROM, 8k, 0A000, eax
    mov eax LAST_BANK  | and eax edx | or eax ecx | swap PROM, 8k, 0E000, eax
    ret

@UpdateCROM:

    mov ecx D$Register | shr ecx 1 | shl ecx 7

    mov ebx 0
    ifFlag B$Command MMC3_SWAP_CROM, mov ebx 01000
    mov eax D$Bank+00  | shl eax 1 |         | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+00  | shl eax 1 | inc eax | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 |         | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 | inc eax | or eax ecx | swap CROM, 1k, ebx, eax | sub ebx 0C00 | xor ebx 01000
    mov eax D$Bank+08  |                     | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+0C  |                     | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+010 |                     | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+014 |                     | or eax ecx | swap CROM, 1k, ebx, eax
    ret

____________________________________________________________________________________________
; Mapper #187, Street Fighter Zero
____________________________________________________________________________________________

Mapper187:

    ; MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM

    ; Memory mapping
    CPUWrite 05000, 07FFF, @5000_7FFF
    CPURead  05000, 07FFF, @Read5000_7FFF

    CPUWrite 08004, 09FFF, WriteVoid
    CPUWrite 0A004, 0BFFF, WriteVoid
    CPUWrite 0C004, 0DFFF, WriteVoid
    CPUWrite 0E004, 0FFFF, WriteVoid
    CPUWrite 08000, 08000, @8000
    CPUWrite 08001, 08001, @8001
    CPUWrite 08003, 08003, @8003

    ; Last 32k PROM
    mov D@Bank8000 LAST_BANK-3
    mov D@BankA000 LAST_BANK-2
    mov D@BankC000 LAST_BANK-1
    mov D@BankE000 LAST_BANK-0
    call @UpdatePROM
    ret

[@Bank8000 Bank+018
 @BankA000 Bank+01C
 @BankC000 Bank+020
 @BankE000 Bank+024

 @ExBank   Bank+028]

@5000_7FFF:
;outwrite
    mov B$Latch+04 al
    if edx > 05000, ret
    mov B$Mode al

    ifFlag. al 080

        ifFlag.. al 020

            and eax 01E | shl eax 1
            mov D@Bank8000 eax | inc eax
            mov D@BankA000 eax | inc eax
            mov D@BankC000 eax | inc eax
            mov D@BankE000 eax

        else..

            and eax 01F | shl eax 1
            mov D@BankC000 eax | inc eax
            mov D@BankE000 eax

        endif..

    else

        copy D@ExBank+00 D@Bank8000
        copy D@ExBank+04 D@BankA000
        mov D@BankC000 LAST_BANK-1
        mov D@BankE000 LAST_BANK

    endif

    call @UpdatePROM
    ret

@Read5000_7FFF:
;outhex eax

    mov dl B$Latch+04 | and dl 03
    if dl = 0, mov eax 083
    if dl = 1, mov eax 083
    if dl = 2, mov eax 042
    if dl = 3, mov eax 000
    ret
____________________________________________________________________________________________

@8000:
;outwrite

    mov D$Latch &FALSE
    mov B$Command al
    ret

@8001:
;outwrite

    mov edx D$Command | and edx 07

    if edx = 6, mov D@ExBank+00 eax
    if edx = 7, mov D@ExBank+04 eax

    if.. B$Latch = &TRUE

        if B$Command = 02A, mov D@BankA000  0F
        if B$Command = 028, mov D@BankC000 017
        jmp @UpdatePROM

    else..

        ; CROM
        if. edx < 2
            or eax 0100
            shr eax 1
        endif
        if. edx < 6
            mov D$Bank+edx*4 eax
            jmp D$fnPROMUpdate
        endif

        ; PROM
        mov ebx D$Mode
        and ebx 0A0
        if. ebx != 0A0
            if edx = 6, mov D@Bank8000 eax
            if edx = 7, mov D@BankA000 eax
            jmp @UpdatePROM
        endif

    endif..
    ret

@8003:
;outwrite

    mov B$Latch &TRUE
    mov B$Command al
    ifNotFlag. al 0F0
        mov D@BankC000 LAST_BANK-1
        call @UpdatePROM
    endif
    ret

@UpdatePROM:

    swap PROM, 8k, 08000, D@Bank8000
    swap PROM, 8k, 0A000, D@BankA000
    swap PROM, 8k, 0C000, D@BankC000
    swap PROM, 8k, 0E000, D@BankE000
    ret
____________________________________________________________________________________________
; Mapper #052, Mario 7-in-1 (MMC3)

; $6000-$7FFF: Set PROM/CROM masks
____________________________________________________________________________________________

Mapper052:

    ; MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM
    mov D$fnCROMUpdate @UpdateCROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF

    call @UpdatePROM
    call @UpdateCROM
    ret

@6000_7FFF:

    call MMC3@WriteWRAM

    ; Not written yet?
    if. D$Register+04 = &FALSE
        mov D$Register+04 &TRUE
        mov D$Register eax
        call @UpdatePROM
        call @UpdateCROM
    endif
    ret

@UpdatePROM:

    ; Masks
    ifNotFlag. B$Register 08
        mov edx 01F
        mov ecx D$Register | and ecx 06
    else
        mov edx 0F
        mov ecx D$Register | and ecx 07
    endif
    shl ecx 4

    ; $8000 and $C000
    ifNotFlag. B$Command MMC3_SWAP_PROM
        mov eax D$Bank+018  | and eax edx | or eax ecx | swap PROM, 8k, 08000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ecx | swap PROM, 8k, 0C000, eax
    else
        mov eax D$Bank+018  | and eax edx | or eax ecx | swap PROM, 8k, 0C000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ecx | swap PROM, 8k, 08000, eax
    endif

    ; $A000 and $E000
    mov eax D$Bank+01C | and eax edx | or eax ecx | swap PROM, 8k, 0A000, eax
    mov eax LAST_BANK  | and eax edx | or eax ecx | swap PROM, 8k, 0E000, eax
    ret

@UpdateCROM:

    ; ecx = 128k bank
    mov ecx 0
    ifFlag B$Register 020, or ecx 04
    ifFlag B$Register  04, or ecx 02
    ifFlag B$Register 010,
    ifFlag B$Register 040, or ecx 01
    shl ecx 7
    mov edx 0FF
    ifFlag B$Register 040, mov edx 07F

    ; CROM swapped?
    mov ebx 0
    ifFlag B$Command MMC3_SWAP_CROM, mov ebx 01000

    ; Set banks
    mov eax D$Bank+00  | shl eax 1 |         | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+00  | shl eax 1 | inc eax | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 |         | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 | inc eax | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | sub ebx 0C00 | xor ebx 01000
    mov eax D$Bank+08  |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+0C  |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+010 |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+014 |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax
    ret

____________________________________________________________________________________________
; Mapper #045, a bunch of pirate multicarts (MMC3)

; $6000-$7FFF: Set PROM/CROM masks
____________________________________________________________________________________________

Mapper045:

    ; MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM
    mov D$fnCROMUpdate @UpdateCROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF

    ; Banks
    call @UpdatePROM
    call @UpdateCROM
    ret

@6000_7FFF:

    ifNotFlag. D$Register+0C 040
        mov ebx D$Register+010
        inc D$Register+010
        and D$Register+010 03
        mov B$Register+ebx*4 al

        call @UpdatePROM
        call @UpdateCROM
    else
        call MMC3@WriteWRAM
    endif
    ret

@UpdatePROM:

    mov edx D$Register+0C
    not edx | and edx 03F

    ; $8000 and $C000
    ifNotFlag. B$Command MMC3_SWAP_PROM
        mov eax D$Bank+018  | and eax edx | or eax D$Register+04 | swap PROM, 8k, 08000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax D$Register+04 | swap PROM, 8k, 0C000, eax
    else
        mov eax D$Bank+018  | and eax edx | or eax D$Register+04 | swap PROM, 8k, 0C000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax D$Register+04 | swap PROM, 8k, 08000, eax
    endif

    ; $A000 and $E000
    mov eax D$Bank+01C | and eax edx | or eax D$Register+04 | swap PROM, 8k, 0A000, eax
    mov eax LAST_BANK  | and eax edx | or eax D$Register+04 | swap PROM, 8k, 0E000, eax
    ret

@UpdateCROM:

    ; and with
    mov edx 0FF
    mov ecx D$Register+08
    not ecx | and ecx 0F
    shr edx cl

    ; or with
    mov ecx D$Register+08 | and ecx 0F0 | shl ecx 4
    or ecx D$Register+00

    ; CROM swapped?
    mov ebx 0
    ifFlag B$Command MMC3_SWAP_CROM, mov ebx 01000

    ; Set banks
    mov eax D$Bank+00  | shl eax 1 |         | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+00  | shl eax 1 | inc eax | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 |         | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+04  | shl eax 1 | inc eax | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | sub ebx 0C00 | xor ebx 01000
    mov eax D$Bank+08  |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+0C  |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+010 |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax | add ebx 0400
    mov eax D$Bank+014 |                     | and eax edx | or eax ecx | swap CROM, 1k, ebx, eax
    ret
____________________________________________________________________________________________
; Mapper #119, TQROM

; Use CRAM if CROM bank number is > $40
____________________________________________________________________________________________
[CRAM_ENABLED &TRUE]
Mapper119:

    ; Almost MMC3
    call MMC3
    mov D$fnCROMUpdate @UpdateCROM
    mov D$Cartridge@SizeCRAM 8

    ; Override PPU line to allow CRAM<-->CROM switch
    PPUWrite 00000, 01FFF, @WriteCRAM
    PPURead  00000, 01FFF, @ReadCRAM
    ret

@UpdateCROM:

    ; CRAM enabled?
    ifNotFlag.. B$Command MMC3_SWAP_CROM

        test B$Bank+00  020 | setnz B$Register+00 | setnz B$Register+01
        test B$Bank+04  020 | setnz B$Register+02 | setnz B$Register+03
        test B$Bank+08  040 | setnz B$Register+04
        test B$Bank+0C  040 | setnz B$Register+05
        test B$Bank+010 040 | setnz B$Register+06
        test B$Bank+014 040 | setnz B$Register+07

        if. B$Register+00 = CRAM_ENABLED | swap CRAM, 2k,  0000, D$Bank+00  | else | swap CROM, 2k,  0000, D$Bank+00  | endif
        if. B$Register+02 = CRAM_ENABLED | swap CRAM, 2k,  0800, D$Bank+04  | else | swap CROM, 2k,  0800, D$Bank+04  | endif
        if. B$Register+04 = CRAM_ENABLED | swap CRAM, 1k, 01000, D$Bank+08  | else | swap CROM, 1k, 01000, D$Bank+08  | endif
        if. B$Register+05 = CRAM_ENABLED | swap CRAM, 1k, 01400, D$Bank+0C  | else | swap CROM, 1k, 01400, D$Bank+0C  | endif
        if. B$Register+06 = CRAM_ENABLED | swap CRAM, 1k, 01800, D$Bank+010 | else | swap CROM, 1k, 01800, D$Bank+010 | endif
        if. B$Register+07 = CRAM_ENABLED | swap CRAM, 1k, 01C00, D$Bank+014 | else | swap CROM, 1k, 01C00, D$Bank+014 | endif

    else..

        test B$Bank+00  020 | setnz B$Register+04 | setnz B$Register+05
        test B$Bank+04  020 | setnz B$Register+06 | setnz B$Register+07
        test B$Bank+08  040 | setnz B$Register+00
        test B$Bank+0C  040 | setnz B$Register+01
        test B$Bank+010 040 | setnz B$Register+02
        test B$Bank+014 040 | setnz B$Register+03

        if. B$Register+00 = CRAM_ENABLED | swap CRAM, 1k,  0000, D$Bank+08  | else | swap CROM, 1k,  0000, D$Bank+08  | endif
        if. B$Register+01 = CRAM_ENABLED | swap CRAM, 1k,  0400, D$Bank+0C  | else | swap CROM, 1k,  0400, D$Bank+0C  | endif
        if. B$Register+02 = CRAM_ENABLED | swap CRAM, 1k,  0800, D$Bank+010 | else | swap CROM, 1k,  0800, D$Bank+010 | endif
        if. B$Register+03 = CRAM_ENABLED | swap CRAM, 1k,  0C00, D$Bank+014 | else | swap CROM, 1k,  0C00, D$Bank+014 | endif
        if. B$Register+04 = CRAM_ENABLED | swap CRAM, 2k, 01000, D$Bank+00  | else | swap CROM, 2k, 01000, D$Bank+00  | endif
        if. B$Register+06 = CRAM_ENABLED | swap CRAM, 2k, 01800, D$Bank+04  | else | swap CROM, 2k, 01800, D$Bank+04  | endif

    endif..
    ret

@WriteCRAM:

    mov ebx edx | shr ebx 10
    on B$Register+ebx = CRAM_ENABLED, WriteCRAM
    ret

@ReadCRAM:

    mov ebx eax | shr ebx 10
    mov D$A13 0
    on B$Register+ebx = CRAM_ENABLED, ReadCRAM
    jmp ReadCROM
____________________________________________________________________________________________
; Mapper #044, Super HIK 7-in-1

; $A001: XXXXXXXX: - Overrides bankswitching in a quite complicated way...

____________________________________________________________________________________________

Mapper044:

    ; Almost MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM
    mov D$fnCROMUpdate @UpdateCROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, WriteVoid
    CPURead  06000, 07FFF, ReadVoid
    mov ecx 0A001
L0: CPUWrite ecx, ecx, @A001
    add ecx 2
    on ecx < 0C000, L0<

    ; Reset banks
    call @UpdatePROM
    call @UpdateCROM
    ret

@A001:

    and eax 07
    if eax = 7, mov eax 6
    mov D$Register eax
    call @UpdatePROM
    call @UpdateCROM
    ret

@UpdatePROM:

    ; Set up masks
    mov ebx D$Register | shl ebx 4
    mov edx 0F | if B$Register = 6, mov edx 01F

    ; $8000 and $C000
    ifNotFlag. B$Command MMC3_SWAP_PROM
        mov eax D$Bank+018  | and eax edx | or eax ebx | swap PROM, 8k, 08000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ebx | swap PROM, 8k, 0C000, eax
    else
        mov eax D$Bank+018  | and eax edx | or eax ebx | swap PROM, 8k, 0C000, eax
        mov eax LAST_BANK-1 | and eax edx | or eax ebx | swap PROM, 8k, 08000, eax
    endif

    ; $A000 and $E000
    mov eax D$Bank+01C | and eax edx | or eax ebx | swap PROM, 8k, 0A000, eax
    mov eax LAST_BANK  | and eax edx | or eax ebx | swap PROM, 8k, 0E000, eax
    ret

@UpdateCROM:

    ; Set up mask
    mov ebx D$Register | shl ebx 7
    mov edx 07F | if B$Register = 6, mov edx 0FF

    ; $0000 <--> $1000?
    mov ecx 01000
    ifFlag B$Command MMC3_SWAP_CROM, mov ecx 0

    ; Swap banks
    mov eax D$Bank+08  | and eax edx | or eax ebx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+0C  | and eax edx | or eax ebx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+010 | and eax edx | or eax ebx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+014 | and eax edx | or eax ebx | swap CROM, 1k, ecx, eax | sub ecx 0C00
    xor ecx 01000
    shr edx 1
    shr ebx 1
    mov eax D$Bank+00  | and eax edx | or eax ebx | swap CROM, 2k, ecx, eax | add ecx 0800
    mov eax D$Bank+04  | and eax edx | or eax ebx | swap CROM, 2k, ecx, eax
    ret
____________________________________________________________________________________________
; Mapper #049, Super HIK 4-in-1

; $6000-$7FFF: BBPPxxxM - (M = 0) swap 32k PROM at $8000 (PP)
;                       - (M = 1) use BB as the two MSB when swapping PROM
;                       - use BB as the two MSB when swapping CROM
____________________________________________________________________________________________

Mapper049:

    ; Almost like MMC3
    call MMC3
    mov D$fnPROMUpdate @UpdatePROM
    mov D$fnCROMUpdate @UpdateCROM

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  06000, 07FFF, ReadVoid

    call @UpdatePROM
    call @UpdateCROM
    ret

@6000_7FFF:

    if. B$WRAMEnabled = &TRUE
        mov D$Register eax
        call @UpdatePROM
        call @UpdateCROM
    endif
    ret

@UpdatePROM:

    mov edx D$Register
    ifFlag. edx 01

        and edx 0C0 | shr edx 2

        ; $8000 <--> $C000 swap?
        ifNotFlag.. D$Command MMC3_SWAP_PROM
            mov eax D$Bank+018  | and eax 0F | or eax edx | swap PROM, 8k, 08000, eax
            mov eax LAST_BANK-1 | and eax 0F | or eax edx | swap PROM, 8k, 0C000, eax
        else..
            mov eax D$Bank+018  | and eax 0F | or eax edx | swap PROM, 8k, 0C000, eax
            mov eax LAST_BANK-1 | and eax 0F | or eax edx | swap PROM, 8k, 08000, eax
        endif..

        ; $A000 and $E000
        mov eax D$Bank+01C | and eax 0F | or eax edx | swap PROM, 8k, 0A000, eax
        mov eax LAST_BANK  | and eax 0F | or eax edx | swap PROM, 8k, 0E000, eax

    else
        shr edx 4 | and edx 03
        swap PROM, 32k, 08000, edx
    endif
    ret

@UpdateCROM:

    mov edx D$Register | and edx 0C0
    mov ecx 0
    ifFlag B$Command MMC3_SWAP_CROM, mov ecx 01000

    mov eax D$Bank+00  | and eax 03F | or eax edx | swap CROM, 2k, ecx, eax | add ecx 0800
    mov eax D$Bank+04  | and eax 03F | or eax edx | swap CROM, 2k, ecx, eax | sub ecx 0800
    xor ecx 01000
    shl edx 1
    mov eax D$Bank+08  | and eax 07F | or eax edx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+0C  | and eax 07F | or eax edx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+010 | and eax 07F | or eax edx | swap CROM, 1k, ecx, eax | add ecx 0400
    mov eax D$Bank+014 | and eax 07F | or eax edx | swap CROM, 1k, ecx, eax
    ret

____________________________________________________________________________________________
; Mapper #182, Super Donkey Kong

; $8001: xxxxxxxM - mirror VERTICAL/HORIZONTAL (0/1)
; $A000: xxxxxCCC - command number
; $C000: BBBBBBBB - bank number for command
; $E003: IIIIIIII - IRQ counter
____________________________________________________________________________________________

Mapper182:

    call MMC3

    ; Memory mapping
    mov ecx 08000
L0: push ecx

        and ecx 0F003
        mov eax WriteVoid
        if ecx = 08000, mov eax @8000
        if ecx = 08001, mov eax @8001
        if ecx = 0A000, mov eax @A000
        if ecx = 0A001, mov eax @A001
        if ecx = 0A002, mov eax @A002
        if ecx = 0C000, mov eax @C000
        if ecx = 0C001, mov eax @C001
        if ecx = 0C002, mov eax @C002
        if ecx = 0E002, mov eax @E002
        if ecx = 0E003, mov eax @E003

    pop ecx
    CPUWrite ecx, ecx, eax
    inc cx | jnz L0<<

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

; ????????
@8000:
@A001:
@A002:
@C001:
@C002:
@E002:ret

@8001:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ret

@A000:
    [@Table: B$ 0 3 1 5 6 7 2 4]
    ; xxxxxCCC
    and eax 07
    movzx eax B$@Table+eax
    call MMC3@Command
    ret

@C000:

    call MMC3@BankSwitch
    ret

@E003:

    ClearIRQ IRQ_CARTRIDGE
    mov D$IRQLatch eax
    mov D$IRQCounter eax
    test eax eax | setnz B$IRQEnabled
    ret
____________________________________________________________________________________________
; Mapper #189, Street Fighter 2 (Yoko)

; MMC3 with different PROM swapping

; $41xx: xxPPxxxx - swap 32k PROM at $8000
; $61xx: xxxxxxPP - swap 32k PROM at $8000
; $8001: Do not swap PROM
____________________________________________________________________________________________

Mapper189:

    ; Like the MMC3
    call MMC3
    mov D$fnPROMUpdate DoNothing

    ; Memory mapping
    CPUWrite 04100, 041FF, @4100_41FF
    CPUWrite 04800, 04FFF, @4800_4FFF
    CPUWrite 05000, 057FF, @5000_57FF
    CPUWrite 05800, 05FFF, @5800_5FFF
    CPURead  05800, 05FFF, @Read5800_5FFF
    CPUWrite 06100, 061FF, @6100_61FF
CPUWrite 0C001, 0C001, @C001

    ; Load first 32k
    swap PROM, 32k, 08000, 0
    ret

; Hack for SF4, where the timing is off
@C001:

    if al > 0, dec al
    jmp MMC3@IRQLatch

@4100_41FF:

    ; xxPPxxxx
    shr eax 4
    swap PROM, 32k, 08000, eax
    ret

@4800_4FFF:

    ; --M-----
    ifNotFlag. eax 020
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; ---P---P
    ifFlag. eax 010
        and eax 01
        or eax 02
    else
        and eax 01
    endif
    swap PROM, 32k, 08000, eax
    ret

@Read5800_5FFF:

    and eax 03
    movzx eax B$Register+eax
    ret

@5000_57FF:

    mov D$Register+010 eax
    ret

@5800_5FFF:

    mov ebx D$Register+010
    xor al B@Table+ebx
    and edx 03
    mov B$Register+edx al
    ret

@6100_61FF:

    ; xxxxxxPP
    swap PROM, 32k, 08000, eax
    ret
____________________________________________________________________________________________

[@Table: B$
 059, 059, 059, 059, 059, 059, 059, 059, 059, 049, 019,  09, 059, 049, 019,  09,
 059, 059, 059, 059, 059, 059, 059, 059, 051, 041, 011,  01, 051, 041, 011,  01,
 059, 059, 059, 059, 059, 059, 059, 059, 059, 049, 019,  09, 059, 049, 019,  09,
 059, 059, 059, 059, 059, 059, 059, 059, 051, 041, 011,  01, 051, 041, 011,  01,
  00, 010, 040, 050,  00, 010, 040, 050,  00,  00,  00,  00,  00,  00,  00,  00,
  08, 018, 048, 058,  08, 018, 048, 058,  00,  00,  00,  00,  00,  00,  00,  00,
  00, 010, 040, 050,  00, 010, 040, 050,  00,  00,  00,  00,  00,  00,  00,  00,
  08, 018, 048, 058,  08, 018, 048, 058,  00,  00,  00,  00,  00,  00,  00,  00,
 059, 059, 059, 059, 059, 059, 059, 059, 058, 048, 018,  08, 058, 048, 018,  08,
 059, 059, 059, 059, 059, 059, 059, 059, 050, 040, 010,  00, 050, 040, 010,  00,
 059, 059, 059, 059, 059, 059, 059, 059, 058, 048, 018,  08, 058, 048, 018,  08,
 059, 059, 059, 059, 059, 059, 059, 059, 050, 040, 010,  00, 050, 040, 010,  00,
  01, 011, 041, 051,  01, 011, 041, 051,  00,  00,  00,  00,  00,  00,  00,  00,
  09, 019, 049, 059,  09, 019, 049, 059,  00,  00,  00,  00,  00,  00,  00,  00,
  01, 011, 041, 051,  01, 011, 041, 051,  00,  00,  00,  00,  00,  00,  00,  00,
  09, 019, 049, 059,  09, 019, 049, 059,  00,  00,  00,  00,  00,  00,  00,  00]

____________________________________________________________________________________________
; Mapper #245, Yong Zhe Dou E Long
____________________________________________________________________________________________

Mapper245: call MMC3 | ret
____________________________________________________________________________________________
; Mapper #074, Taiwanese MMC3
____________________________________________________________________________________________

Mapper074: call MMC3 | ret

____________________________________________________________________________________________
; Mapper #250, Time Diver Avenger (MMC3)

; Almost identical to MMC3
____________________________________________________________________________________________

Mapper250:

    ; Almost identical to MMC3
    call MMC3

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; Data = LSB of address
    movzx eax dl

    ; Write to a MMC3 reg
    and edx 0E400
    ifFlag edx 0400, or edx 01
    and edx 0E001
    on edx = 08000, MMC3@Command
    on edx = 08001, MMC3@Bankswitch
    on edx = 0A000, MMC3@Mirroring
    on edx = 0A001, MMC3@WRAMEnable
    on edx = 0C000, MMC3@IRQLatch
    on edx = 0C001, MMC3@ResetIRQ
    on edx = 0E000, MMC3@DisableIRQ
    on edx = 0E001, MMC3@EnableIRQ
    ret

____________________________________________________________________________________________
; Mapper #118, TLSROM/TKSROM (MMC3)

; MMC3
; When swapping 1k CROM, use the MSB for mirroring: $2400/$2000 (0/1)
____________________________________________________________________________________________

Mapper118:

    ; MMC3
    call Mapper004

    ; Set ports
    mov ecx 08001
L0: CPUWrite ecx, ecx, @8001
    add ecx 2
    on ecx <= 09FFF, L0<
    ret

@8001:

    mov edx D$Command
    and edx 7

    ; Skip if not 1k CROM switch
    on edx >= 6, S0>
    on edx <= 1, S0>

    ; Mxxxxxxx
    ifNotFlag. eax 080
        mirror ONE_SCREEN_2400
    else
        mirror ONE_SCREEN_2000
    endif

S0: call MMC3@Bankswitch
    ret
____________________________________________________________________________________________
; Mapper #088, Namcot 118

; $8000: xxxxxCCC - command number
; $8001: BBBBBBBB - swap banks almost like MMC3
; $C000: xMxxxxxx - mirror $2000/$2400 (0/1)
____________________________________________________________________________________________

Mapper088:

    ; Memory mapping
    mov ecx 08000
L0: push ecx

        mov eax WriteVoid
        and ecx 08001
        if ecx = 08000, mov eax @8000
        if ecx = 08001, mov eax @8001

    pop ecx
    CPUWrite ecx, ecx, eax
    inc cx | jnz L0<<

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000:

    ; Mirroring hack
    if. D$Cartridge@PROMCRC32 = 0C1B6_B2A6 ; Devil Man (J)
        mirror ONE_SCREEN_2000
        ifFlag eax 040, mirror ONE_SCREEN_2400
    endif

    ; xxxxxCCC
    and eax 7
    call MMC3@Command
    ret

@8001:

    ; 1k CROM? --> Add $40
    if D$Command >= 2,
        if D$Command <= 5,
            or eax 040

    call MMC3@Bankswitch
    ret

@C000:

    ; xMxxxxxx
    ifNotFlag. eax 040
        mirror ONE_SCREEN_2000
    else
        mirror ONE_SCREEN_2400
    endif
    ret

____________________________________________________________________________________________
; Mapper #095, Namcot 106M (Dragon Buster)

; $8000: xxxxxCCC - Command number
; $8001: xxMCCCCC - PROM swap like MMC3
;                 - CROM swap like MMC3
;                 - mirror $2400/$2000 (0/1)
____________________________________________________________________________________________

Mapper095:

    ; Memory mapping
    mov ecx 08000
L0: CPUWrite ecx, ecx, @8000 | inc ecx
    CPUWrite ecx, ecx, @8001 | inc ecx
    on ecx < 0A000, L0<

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000:

    and eax 07
    call MMC3@Command
    ret

@8001:

    on D$Command >= 6, S0>

    ; xxMxxxxx
    ifFlag. eax 020
        mirror ONE_SCREEN_2000
    else
        mirror ONE_SCREEN_2400
    endif
    and eax 01F

S0: call MMC3@Bankswitch
    ret

____________________________________________________________________________________________
; Mapper #076, Namco 109

; Quite similar to MMC3
____________________________________________________________________________________________

Mapper076:

    ; Memory mapping
    mov ecx 08000
L0: push ecx

        and ecx 0E001
        mov eax WriteVoid
        if ecx = 08000, mov eax MMC3@Command
        if ecx = 08001, mov eax @8001
        if ecx = 0A000, mov eax @A000

    pop ecx
    CPUWrite ecx, ecx, eax
    inc cx | jnz L0<<

    ; Swap in last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8001:

    ; 0-7: Switch banks according to command in $8000
    mov edx D$Command | and edx 7

    ; Load 2k CROM
    if dl = 2, swap CROM, 2k, 00000, eax
    if dl = 3, swap CROM, 2k,  0800, eax
    if dl = 4, swap CROM, 2k, 01000, eax
    if dl = 5, swap CROM, 2k, 01800, eax

    ; Load 8k PROM
    if dl = 6, swap PROM, 8k, 08000, eax
    if dl = 7, swap PROM, 8k, 0A000, eax
    ret

@A000:

    ifFlag. eax 1
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif
    ret
____________________________________________________________________________________________
