TITLE MMC
;____________________________________________________________________________________________
;
;                                   Nintendo MMC1-MMC6
;
;____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #001, Nintendo MMC1
____________________________________________________________________________________________

Mapper001:

    ; Memory mapping
    CPURead  06000, 07FFF, @ReadWRAM
    CPUWrite 06000, 07FFF, @WriteWRAM
    CPUWrite 08000, 0FFFF, @WriteRegs
mov B$WRAMEnabled &TRUE

    ; Set up registers
    mov B$BitCount 0
    mov D$Register 0C ; Reset all regs and set #1 to $C ($8000/16k)

    ; Set up banks
    call @UpdateMirroring
    call @UpdateCROM
    call @UpdatePROM
    ret

@WriteRegs:

    ; Reg number changed since last write?
    shr edx 13 | and edx 3
    if. dl != B$LastRegister
        mov B$BitCount 0
        mov B$LastRegister dl
    endif

    ; Reset?
    ifFlag. al 080
        mov B$BitCount 0
        or  B$Register+0 0C
        call @UpdateMirroring
        call @UpdateCROM
        call @UpdatePROM
        ret
    endif

    ; Save written bit
    shr al 1 | rcr B$Latch 1

    ; Five bits yet?
    inc B$BitCount
    if. B$BitCount >= 5

        mov B$BitCount 0

        ; Save register
        mov al B$Latch | shr al 3
        mov B$Register+edx al

        ; Change MMC setup
        if dl = 0, call @UpdateMirroring
        call @UpdateCROM
        call @UpdatePROM

    endif
    ret

@UpdateMirroring:

    movzx eax B$Register+0
    and eax MMC1_MIRRORING
    if eax = 0, mirror ONE_SCREEN_2000
    if eax = 1, mirror ONE_SCREEN_2400
    if eax = 2, mirror VERTICAL
    if eax = 3, mirror HORIZONTAL
    ret

@UpdateCROM:

    movzx eax B$Register+1
    movzx edx B$Register+2

    ; Swap it!
    ifFlag. B$Register+0 MMC1_SWITCH_4K
        swap CROM, 4k, 00000, eax
        swap CROM, 4k, 01000, edx
    else
        shr eax 1
        swap CROM, 8k, 00000, eax
    endif
    ret

@UpdatePROM:

    ; $8000 --> ecx, $C000 --> edx
    ifNotFlag. B$Register+0 MMC1_SWITCH_16K

        ; Switch 32k
        movzx ecx B$Register+3 | and ecx 0E
        move  edx ecx+1

    else

        ; Switch $8000
        movzx ecx B$Register+3     ; Selected bank --> $8000
        mov   edx LAST_BANK         ; Last     bank --> $C000

        ; Switch $C000
        ifNotFlag B$Register+0 MMC1_SWITCH_8000, mov   ecx 0               ; First    bank --> $8000
        ifNotFlag B$Register+0 MMC1_SWITCH_8000, movzx edx B$Register+3    ; Selected bank --> $C000

    endif

    ; Adjust bank numbers
    and ecx 0F
    and edx 0F
    ifFlag. B$Register+1 010
        or ecx 010
        or edx 010
    endif

    ; Swap
    swap PROM, 16k, 08000, ecx
    swap PROM, 16k, 0C000, edx

    ; WRAM enable hack
    if D$Cartridge@PROMCRC32 = 081DF_3D70, ret ; Tatakae!! Rahmen Man - Sakuretsu Choujin 102 Gei (J) [b2]

    ; WRAM Enabled?
    test B$Register+3 MMC1_WRAM_DISABLE | setz B$WRAMEnabled
    ret

@ReadWRAM:

    on B$WRAMEnabled = &TRUE, ReadWRAM
    jmp ReadVoid

@WriteWRAM:

    on B$WRAMEnabled = &TRUE, WriteWRAM
    jmp WriteVoid

[MMC1_MIRRORING     3
 MMC1_SWITCH_8000   4
 MMC1_SWITCH_C000   0
 MMC1_SWITCH_16K    8
 MMC1_SWITCH_32K    0
 MMC1_SWITCH_4K     010
 MMC1_WRAM_DISABLE  010]
[BitCount      Register+04
 LastRegister  Register+08]
____________________________________________________________________________________________
; Mapper #155, MMC1 without WRAM toggle (The Money Game (J))
____________________________________________________________________________________________

Mapper155:

    call Mapper001
    CPURead  06000, 07FFF, ReadWRAM
    CPUWrite 06000, 07FFF, WriteWRAM
    ret

____________________________________________________________________________________________
; Mapper #009, Nintendo MMC2 (Punch-out!)
____________________________________________________________________________________________

Mapper009:

    ; Monitor read line
    PPURead 0FD8,  0FDF,  @0FD0
    PPURead 0FE8,  0FEF,  @0FE0
    PPURead 01FD8, 01FDF, @1FD0
    PPURead 01FE8, 01FEF, @1FE0

    ; Set ports
    CPUWrite 0A000, 0AFFF, @A000_AFFF
    CPUWrite 0B000, 0BFFF, @B000_BFFF
    CPUWrite 0C000, 0CFFF, @C000_CFFF
    CPUWrite 0D000, 0DFFF, @D000_DFFF
    CPUWrite 0E000, 0EFFF, @E000_EFFF
    CPUWrite 0F000, 0FFFF, @F000_FFFF

    ; Load PROM
    swap PROM, 8k,  08000, 0
    swap PROM, 8k,  0A000, LAST_BANK-2
    swap PROM, 8k,  0C000, LAST_BANK-1
    swap PROM, 8k,  0E000, LAST_BANK

    ; Registers
    mov D$Register+00 0
    mov D$Register+04 0
    mov D$Register+08 1
    mov D$Register+0C 1
    mov D$Latch+00 0FD
    mov D$Latch+04 0FD
    ret

@A000_AFFF:

    ; PPPPPPPP
    swap PROM, 8k, 08000, eax
    ret

; CCCCCCCC
@B000_BFFF: mov D$Register+00 eax | if D$Latch+00 = 0FD, swap CROM, 4k, 00000, D$Register+00 | ret
@C000_CFFF: mov D$Register+04 eax | if D$Latch+00 = 0FE, swap CROM, 4k, 00000, D$Register+04 | ret
@D000_DFFF: mov D$Register+08 eax | if D$Latch+04 = 0FD, swap CROM, 4k, 01000, D$Register+08 | ret
@E000_EFFF: mov D$Register+0C eax | if D$Latch+04 = 0FE, swap CROM, 4k, 01000, D$Register+0C | ret

@F000_FFFF:

    ; xxxxxxxM
    ifNotFlag. eax 1
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ret

@0FD0: call ReadCROM | if D$Latch+00 != 0FD, swap CROM, 4k, 00000, D$Register+00 | mov D$Latch+00 0FD | ret
@0FE0: call ReadCROM | if D$Latch+00 != 0FE, swap CROM, 4k, 00000, D$Register+04 | mov D$Latch+00 0FE | ret
@1FD0: call ReadCROM | if D$Latch+04 != 0FD, swap CROM, 4k, 01000, D$Register+08 | mov D$Latch+04 0FD | ret
@1FE0: call ReadCROM | if D$Latch+04 != 0FE, swap CROM, 4k, 01000, D$Register+0C | mov D$Latch+04 0FE | ret
____________________________________________________________________________________________
; Mapper #004, Nintendo MMC3
____________________________________________________________________________________________

Mapper004: call MMC3 | ret

____________________________________________________________________________________________
; Mapper #010, Nintendo MMC4 - almost identical to MMC2
____________________________________________________________________________________________

Mapper010:

    ; Almost identical to MMC2
    call Mapper009

    ; Set ports
    CPUWrite 0A000, 0AFFF, @A000_AFFF

    ; Load PROM
    swap PROM, 16k, 08000, 0
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@A000_AFFF:
    swap PROM, 16k, 08000, eax
    ret
____________________________________________________________________________________________
