TITLE InputDialog
____________________________________________________________________________________________
; Input dialog
____________________________________________________________________________________________

InputDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam
    pushad

        ; Message?
               if. D@Message = &WM_CLOSE      | call @Cancel
        else | if. D@Message = &WM_INITDIALOG | call @Init
        else | if. D@Message = &WM_COMMAND    | call @Command
        else | if. D@Message = &WM_TIMER      | call @Timer
        else | mov eax &FALSE | endif

        mov D$esp+01C eax

    popad
    return

@Init:
;;
    mov eax D$AutofireDelay
    mov ecx 60   | mul ecx
    mov ecx 1000 | div ecx
    call 'User32.SetTimer' D@hDialog, IDT_AUTOFIRE, eax, &NULL
;;
    ; Get handles
  . D@hDeviceList   = 'User32.GetDlgItem' D@hDialog, IDC_LISTBOX+0
  . D@hFunctionList = 'User32.GetDlgItem' D@hDialog, IDC_LISTBOX+1
  . D@hMappingList  = 'User32.GetDlgItem' D@hDialog, IDC_LISTBOX+2

    ; Autofire trackbar
  . D@hAutofire = 'User32.GetDlgItem' D@hDialog, IDC_TRACKBAR+0
    call 'User32.SendMessageA' D@hAutofire, &TBM_SETRANGE, &FALSE, (AUTOFIRE_MAXIMUM shl 16)+AUTOFIRE_MINIMUM
    call 'User32.SendMessageA' D@hAutofire, &TBM_SETTHUMBLENGTH, 2, 0
    mov eax AUTOFIRE_MAXIMUM+AUTOFIRE_MINIMUM | sub eax D$AutoFireDelay
    call 'User32.SendMessageA' D@hAutofire, &TBM_SETPOS, &TRUE, eax

    ; Zapper checkboxes
    mov eax 0 | cmp B$Port1 CONTROLLER_ZAPPER | sete al | call 'User32.CheckDlgButton' D@hDialog, IDC_CHECKBOX+0, eax
    mov eax 0 | cmp B$Port2 CONTROLLER_ZAPPER | sete al | call 'User32.CheckDlgButton' D@hDialog, IDC_CHECKBOX+1, eax

    ; Put some text in the list boxes
    call @ListDevices
    call @ListFunctions
    mov eax &TRUE
    ret

@Command:

    call @CancelBind

if W@wParam = IDC_TRACKBAR+0,outhex D@wParam

    ; Escape pressed
    on W@wParam = &IDCANCEL, @Cancel

    ; OK/Cancel
    on W@wParam = IDC_OK,     @SaveAndExit
    on W@wParam = IDC_CANCEL, @Cancel
    ; Set
    if W@wParam = IDC_BUTTON+0, call @DoBind D@nSelectedFunction
    ; Clear
    if. W@wParam = IDC_BUTTON+1
        call GetFunctionID D@nSelectedDevice, D@nSelectedFunction
        call UnAssignFunction eax
        call @ListFunctions
    endif
    ; Set all
    if W@wParam = IDC_BUTTON+2, call @BindAllFunctions
    ; Clear all
    if. W@wParam = IDC_BUTTON+3
        call 'User32.SendMessageA' D@hFunctionList, &LB_GETCOUNT, 0, 0
    L0: if.. eax > 0
            dec eax
            push eax
                call GetFunctionID D@nSelectedDevice, eax
                call UnAssignFunction eax
            pop eax | jmp L0<
        endif..
        call @ListFunctions
    endif

    ; Select changed
    if. W@wParam+2 = &CBN_SELCHANGE
        if W@wParam = IDC_LISTBOX+0, . D@nSelectedDevice   = 'User32.SendMessageA' D@hDeviceList,   &LB_GETCURSEL, 0, 0
        if W@wParam = IDC_LISTBOX+1, . D@nSelectedFunction = 'User32.SendMessageA' D@hFunctionList, &LB_GETCURSEL, 0, 0
        call @ListFunctions
    endif

    ; Double-click
    if W@wParam+2 = &LBN_DBLCLK,
        if W@wParam = IDC_LISTBOX+1,
            call @DoBind D@nSelectedFunction

    mov eax &TRUE
    ret

@SaveAndExit:

    call @KillDialog
    call SaveConfiguration
    mov eax &TRUE
    ret

@Cancel:

    ; Restore everything, kill dialog
    call @KillDialog
    call LoadConfiguration
    mov eax &TRUE
    ret

@KillDialog:

    call @CancelBind
    call 'User32.KillTimer' D@hDialog, IDT_AUTOFIRE

    ; Get trackbar value
    call 'User32.SendMessageA' D@hAutofire, &TBM_GETPOS, 0, 0
    mov edx AUTOFIRE_MAXIMUM+AUTOFIRE_MINIMUM | sub edx eax
    mov D$AutoFireDelay edx

    ; Zapper checkboxes
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_CHECKBOX+0 | call SetZapper Port1, eax
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_CHECKBOX+1 | call SetZapper Port2, eax

    ; Exit
    call 'User32.EndDialog' D@hDialog, 1
    ret

@Timer:

    ; Waiting for button press?
    if D@wParam = IDT_PRESSNEWBUTTON,
        if B@WaitingForPress = &TRUE,
            call @WaitForPress

    ; Toggle autofire?
    if. D@wParam = IDT_AUTOFIRE
        call 'User32.GetWindowLongA' D@hAutofire, &GWL_STYLE | xor eax &TBS_NOTHUMB
        call 'User32.SetWindowLongA' D@hAutofire, &GWL_STYLE, eax
    endif
    mov eax &TRUE
    ret
____________________________________________________________________________________________

@ListDevices:

    ; Fill list
    call 'User32.SendMessageA' D@hDeviceList, &LB_RESETCONTENT, 0, 0
    mov edi @DeviceNames, al 0, ecx 0-1
L0: if. B$edi > 0
        pushad
            call 'User32.SendMessageA' D@hDeviceList, &LB_ADDSTRING, 0, edi
        popad
        repne scasb
        jmp L0<
    endif

    ; Set current selection
    call 'User32.SendMessageA' D@hDeviceList, &LB_SETCURSEL, D@nSelectedDevice, 0
    ret

@ListFunctions:

    ; Reset
    call 'User32.SendMessageA' D@hFunctionList, &LB_RESETCONTENT, 0, 0
    if D@nSelectedFunction = &LB_ERR, mov D@nSelectedFunction 0

    ; Insert function names
    call GetFunctionNames D@nSelectedDevice
    mov edi eax, al 0, ecx 0-1
L0: if. B$edi > 0
        pushad
            call 'User32.SendMessageA' D@hFunctionList, &LB_ADDSTRING, 0, edi
        popad
        repne scasb
        jmp L0<
    endif

    ; Select function
L0: call 'User32.SendMessageA' D@hFunctionList, &LB_SETCURSEL, D@nSelectedFunction, 0
    if. eax = &LB_ERR
        call 'User32.SendMessageA' D@hFunctionList, &LB_GETCOUNT, D@nSelectedFunction, 0
        dec eax | mov D@nSelectedFunction eax
        on eax != &LB_ERR, L0<
    endif

    ; List their mappings
    call @ListMappings
    call @AdjustMappingScroll
    ret

@ListMappings:

    ; ecx = list index, eax = number of items
    call 'User32.SendMessageA' D@hMappingList, &LB_RESETCONTENT, 0, 0
    call 'User32.SendMessageA' D@hFunctionList, &LB_GETCOUNT, 0, 0
    mov ecx 0
L0: pushad

        mov D@Buttonname 0

        ; Scan through all devices
        mov ebx 0
    L1: if. ebx < D$nDevices
            mov esi D$pMappings+ebx*4

            ; Find mapping for this function
        L2: call GetFunctionID D@nSelectedDevice ecx | mov edx eax
        L3: lodsd
            on eax = 0, S0>
            on ax != dx, L3<

            ; Find button name
            push ecx
                movzx edx W$esi-2
                mov al 0, edi D$pButtonNames+ebx*4, ecx 0-1
            L3: dec edx | js C0> | repne scasb | jmp L3<
        C0: pop ecx

            ; Add it
            [@Buttonname:      B$ ? #&MAX_PATH]
            [@ButtonSeparator: B$ ', ', 0]
            call AddString @Buttonname @ButtonSeparator
            call AddString @Buttonname edi
            jmp L2<

        S0: inc ebx | jmp L1<<
        endif

        ; Add string
        call 'User32.SendMessageA' D@hMappingList, &LB_ADDSTRING, 0, @Buttonname+2

    popad
    inc ecx | on ecx < eax, L0<<
    ret

____________________________________________________________________________________________

@AdjustMappingScroll:

    [@hDC:      ?
     @hFontOld: ?
     @hFontNew: ?
     @nCount:   ?
     @nLength:  ?
     @Size:     ? ?
     @Text:     ? #&MAX_PATH]

    mov D@nLength 0
    pushad

        ; Retrieve data
      . D@hDC = 'User32.GetDC' D@hMappingList
      . D@hFontNew = 'User32.SendMessageA' D@hMappingList, &WM_GETFONT, &NULL, &NULL
      . D@hFontOld = 'GDI32.SelectObject'  D@hDC, D@hFontNew

        ; Find longest string
      . D@nCount = 'User32.SendMessageA' D@hFunctionList, &LB_GETCOUNT, 0, 0
    L0: if. D@nCount > 0
            dec D@nCount
            call 'User32.SendMessageA' D@hMappingList, &LB_GETTEXTLEN, D@nCount, &NULL | inc eax
            push eax
                call 'User32.SendMessageA' D@hMappingList, &LB_GETTEXT, D@nCount, @Text
            pop eax
            call 'GDI32.GetTextExtentPoint32A' D@hDC, @Text, eax, @Size
            mov eax D@Size
            if eax > D@nLength, mov D@nLength eax
            jmp L0<
        endif

        ; Restore data, set new width
    S0: call 'GDI32.SelectObject' D@hDC, D@hFontOld
        call 'User32.ReleaseDC' D@hMappingList, D@hDC
        call 'User32.SendMessageA' D@hMappingList, &LB_SETHORIZONTALEXTENT, D@nLength, 0

    popad
    call @ListMappings
    ret
____________________________________________________________________________________________

[@PressNewButton: B$ 'Press new button...', 0]
[@WaitingForPress:  ?
 @nFunction:        ?
 @nFunctionsToBind: ?]

@BindAllFunctions:

    ; Get number of functions, start binding first
  . D@nFunctionsToBind = 'User32.SendMessageA' D@hFunctionList, &LB_GETCOUNT, 0, 0
    if eax > 0, call @DoBind 0
    ret

@DoBind:

    pop eax, D@nFunction | push eax
    if D@nFunction = &LB_ERR, ret
    pushad

        call 'User32.SetFocus' 0

        ; Copy to old device state
        mov esi DeviceStates, edi @OldDeviceStates, ecx (NUM_DEVICES shl 10)
        rep movsb

        ; Move the list box cursor to this function - only necessary on [set all]
        call 'User32.SendMessageA' D@hFunctionList, &LB_SETCURSEL, D@nFunction, 0
        copy D@nFunction D@nSelectedFunction
        if D@nFunctionsToBind = 0, mov D@nFunctionsToBind 1

        ; 'Press new button...'
        call 'User32.SendMessageA' D@hMappingList, &LB_DELETESTRING, D@nFunction, 0
        call 'User32.SendMessageA' D@hMappingList, &LB_INSERTSTRING, D@nFunction, @PressNewButton

        ; Start waiting for button press
        call 'User32.SetTimer' D@hDialog, IDT_PRESSNEWBUTTON, 20, &NULL
        mov D@WaitingForPress &TRUE

    popad
    ret

@CancelBind:

    ; Cancel all binds
    if. D@WaitingForPress = &TRUE
        call 'User32.SetFocus' D@hDialog
        call 'User32.KillTimer' D@hDialog, IDT_PRESSNEWBUTTON
        mov D@WaitingForPress &FALSE
        mov D@nFunctionsToBind 0
        call @ListFunctions
    endif
    ret

@EndBind:

    ; End current bind
    call @ListFunctions
    dec D@nFunctionsToBind | jz @CancelBind | js @CancelBind
    inc D@nFunction
    call @DoBind D@nFunction
    ret

@WaitForPress:

    ; Get device state
    [@OldDeviceStates: ? #(NUM_DEVICES shl 8)]
    call GetDeviceStates

    ; Scan device states for changes
    mov esi DeviceStates, edi @OldDeviceStates
    mov ebx 0
L0: if. ebx < D$nDevices

        mov ecx 0
    L1: if.. ecx < D$LengthDeviceState+ebx*4
            ifFlag B$esi+ecx BUTTON_DOWN,
                ifNotFlag B$edi+ecx BUTTON_DOWN,
                    jmp Q0>
            inc ecx | jmp L1<
        endif..
        add esi ecx
        add edi ecx
        inc ebx | jmp L0<

    endif

    ; Copy to old device state
    mov esi DeviceStates, edi @OldDeviceStates, ecx (NUM_DEVICES shl 8)
    rep movsb
    ret

    ; A button was pressed!
Q0: mov D@WaitingForPress &FALSE
    call GetFunctionID D@nSelectedDevice, D@nFunction
    call AssignFunction ebx, ecx, eax
    call @EndBind
    ret
____________________________________________________________________________________________

[AUTOFIRE_MINIMUM 2
 AUTOFIRE_MAXIMUM 60]

____________________________________________________________________________________________

[@nSelectedDevice:   ?
 @nSelectedFunction: ?
 @hDeviceList:       ?
 @hFunctionList:     ?
 @hMappingList:      ?
 @hAutofire:         ?]

____________________________________________________________________________________________

[@DeviceNames: B$
    'Pad 1',  0
    'Pad 2',  0
    'Pad 3',  0
    'Pad 4',  0
    '-----',  0
    'NES',    0
    'TechNES', 0, 0]

____________________________________________________________________________________________

[PadNames: B$
    'A',         0
    'B',         0
    'Select',    0
    'Start',     0
    'Up',        0
    'Down',      0
    'Left',      0
    'Right'      0
    'Autofire A' 0
    'Autofire B' 0, 0

 NESNames:
    'Power',       0
    'Reset',       0
    'Quick save',  0
    'Quick load',  0
    'Save dialog', 0
    'Load dialog', 0, 0

 NessieNames:
    'Close',             0,
    'Pause',             0,
    'Fast forward',      0,
    'Fullscreen', 0,
    'Screenshot',        0, 0

 NoNames: 0, 0]

[pFunctionNames:
 PadNames
 PadNames
 PadNames
 PadNames
 NoNames
 NESNames
 NessieNames]

[nFunctionIDs:
 PAD1_A
 PAD2_A
 PAD3_A
 PAD4_A
 &NULL
 TOGGLE_POWER
 CLOSE]

GetFunctionNames:

    arguments @nDevice
    pushad
        mov ebx D@nDevice
        copy D$pFunctionNames+ebx*4 D@nDevice
    popad
    mov eax D@nDevice
    return

GetFunctionID:

    arguments @nDevice, @nFunction
    pushad
        mov eax D@nDevice
        mov eax D$nFunctionIDs+eax*4
        add D@nFunction eax
    popad
    mov eax D@nFunction
    return
____________________________________________________________________________________________
