TITLE Input

____________________________________________________________________________________________
; Init/shutdown
____________________________________________________________________________________________

InputInit:

    ; IDirectInput interface
    call 'DInput.DirectInputCreateA' D$hInstance, &DIRECTINPUT_VERSION, lpdi, &NULL
    dxErrorCheck 'Could not create DirectInput'
    if D$lpdi = &NULL, ret

    ; Init devices
    call Init_rgodfKeyboard
    call InitDevices
    ret

InputShutdown:

    ; Release devices
L0: if. D$nDevices > 0
        dec D$nDevices
        mov edx D$nDevices | dxCall lpdid+edx*4,UnAcquire
        mov edx D$nDevices | dxRelease lpdid+edx*4
        jmp L0<
    endif

    ; Release IDirectInput interface
    dxRelease lpdi
    ret
____________________________________________________________________________________________

InitDevices:

    ; Enumerate devices
    dxCall lpdi,EnumDevices &DIDEVTYPE_KEYBOARD, DIEnumDevices, &NULL, &DIEDFL_ATTACHEDONLY
    dxErrorCheck 'Could not enumerate keyboards'
    dxCall lpdi,EnumDevices &DIDEVTYPE_JOYSTICK, DIEnumDevices, &NULL, &DIEDFL_ATTACHEDONLY
    dxErrorCheck 'Could not enumerate joysticks'

    ; Set up all devices
    mov ebx 0
L0: if ebx = D$nDevices, ret

    ; Create device
    push ebx

        move edx lpdid+ebx*4
        shl ebx 4 | add ebx GUID
        pushad
            dxCall lpdi,CreateDevice ebx, Temp, &NULL
            dxErrorCheck 'Could not create DirectInput device'
        popad
        dxCall Temp,QueryInterface IID_IDirectInputDevice2, edx
        dxRelease Temp

    pop ebx
    on D$lpdid+ebx*4 = &NULL, L0<<

    ; Set cooperative level
    push ebx

        dxCall lpdid+ebx*4,didSetCooperativeLevel D$hMainWindow, &DISCL_BACKGROUND+&DISCL_NONEXCLUSIVE
        dxErrorCheck 'Could not set device cooperation level'

    pop ebx

    ; Set data format
    push ebx

        if. B$DeviceType+ebx*4 = &DIDEVTYPE_KEYBOARD
            copy D$c_dfDIKeyboard@dwDataSize D$LengthDeviceState+ebx*4
            mov D$pButtonNames+ebx*4 KeyboardNames
            dxCall lpdid+ebx*4,SetDataFormat c_dfDIKeyboard
        else
            copy D$c_dfDIJoystick@dwDataSize D$LengthDeviceState+ebx*4
            mov D$pButtonNames+ebx*4 JoystickNames
            dxCall lpdid+ebx*4,SetDataFormat c_dfDIJoyStick
        endif
        dxErrorCheck 'Could not set data format'

    pop ebx

    ; Joystick-specific properties
    if. B$DeviceType+ebx*4 = &DIDEVTYPE_JOYSTICK

        [DIProperty:
         @dwSize:        ?
         @dwHeaderSize:  ?
         @dwObj:         ?
         @dwHow:         ?
         @lMin: @dwData: ?
         @lMax:          ?]

        ; Set dead zone
        push ebx

            mov D$DIProperty@dwSize       014
            mov D$DIProperty@dwHeaderSize 010
            mov D$DIProperty@dwObj        &NULL
            mov D$DIProperty@dwHow        &DIPH_DEVICE
            mov D$DIProperty@dwData       5000

            dxCall lpdid+ebx*4,SetProperty &DIPROP_DEADZONE, DIProperty
            dxErrorCheck 'Could not set dead zone'

        pop ebx

        ; Set range
        push ebx

            mov D$DIProperty@dwSize       018
            mov D$DIProperty@dwHeaderSize 010
            mov D$DIProperty@dwObj        &NULL
            mov D$DIProperty@dwHow        &DIPH_DEVICE
            mov D$DIProperty@lMin         0-1
            mov D$DIProperty@lMax         0+1

            dxCall lpdid+ebx*4,SetProperty &DIPROP_RANGE, DIProperty
            dxErrorCheck 'Could not set range'

        pop ebx

    endif

    ; Set pointer to button assignments
    mov eax ebx | shl eax 8
    move eax Mappings+eax*4 | mov D$pMappings+ebx*4 eax
    inc ebx | jmp L0<<

DIEnumDevices:

    arguments @pDeviceInstance, @pvRef
    pushad

        ; Save type
        mov ebx D$nDevices | inc D$nDevices
        mov esi D@pDeviceInstance | copy D$esi+36 D$DeviceType+ebx*4

        ; Save GUID
        add esi 4
        mov edi ebx | shl edi 4 | add edi GUID
        mov ecx 010 | rep movsb

    popad
    mov eax &DIENUM_CONTINUE
    return

____________________________________________________________________________________________
; Get input
____________________________________________________________________________________________

[pDeviceState: ?]

GetDeviceStates:

    ; Get all device states
    mov edx DeviceStates
    mov ebx 0
L0: if. ebx < D$nDevices

        on D$lpdid+ebx*4 = &NULL, S0>>

        ; Acquire device
        pushad
            dxCall lpdid+ebx*4, Acquire
            dxErrorCheck 'Could not acquire device'
        popad

        ; Poll device
        pushad
            dxCall lpdid+ebx*4, Poll
            dxErrorCheck 'Could not poll device'
        popad

        ; Get device state
        pushad
            dxCall lpdid+ebx*4,GetDeviceState D$LengthDeviceState+ebx*4, edx
            dxErrorCheck 'Could not get joystick state'
        popad

        ; Next device
    S0: add edx D$LengthDeviceState+ebx*4
        inc ebx | jmp L0<<

    endif

    ; Convert data from certain joystick input objects
    call ConvertDeviceStates
    ret

ConvertDeviceStates:

    mov edx DeviceStates
    mov ebx 0
L0: if. ebx < D$nDevices

        on B$DeviceType+ebx*4 != &DIDEVTYPE_JOYSTICK, S0>>
        mov esi edx, edi esi

        ; Convert 3+3 axes (axis value --> pressed buttons)
        mov ecx 3+3
    L1: lodsd
        if.. eax = 0-1 | mov eax 080   | else..
        if.. eax = 0+1 | mov eax 08000 | endif..
        stosd
        dec ecx | jnz L1<

        ; Eliminate 2 sliders <------- todo: conversion
        lodsd | mov eax 0 | stosd
        lodsd | mov eax 0 | stosd

        ; Convert 4 POVs (angle value --> pressed buttons)
        mov ecx 4
    L1: lodsd
        if.. ax < 2250+0000  | mov eax 0______80 | else..  ; up
        if.. ax < 2250+4500  | mov eax 0____8080 | else..  ; up+right
        if.. ax < 2250+9000  | mov eax 0____8000 | else..  ; right
        if.. ax < 2250+13500 | mov eax 0__808000 | else..  ; right+down
        if.. ax < 2250+18000 | mov eax 0__800000 | else..  ; down
        if.. ax < 2250+22500 | mov eax 080800000 | else..  ; down+left
        if.. ax < 2250+27000 | mov eax 080000000 | else..  ; left
        if.. ax < 2250+31500 | mov eax 080000080 | else..  ; left+up
        if.. ax < 0000+36000 | mov eax 0______80 | else..  ; up
        if.. ax = 0FFFF      | mov eax 000000000 | endif.. ; center
        stosd
        dec ecx | jnz L1<<

        ; Next device
    S0: add edx D$LengthDeviceState+ebx*4
        inc ebx | jmp L0<<

    endif
    ret

____________________________________________________________________________________________

; Assembles all device states into a single input status array
TranslateInput:

    ; Save previous state
    call CopyMemory InputArray, OldInputArray, LENGTH_INPUTARRAY
    mov edi InputArray, al BUTTON_UP, ecx LENGTH_INPUTARRAY | rep stosb

    ; Loop through all devices
    mov edx DeviceStates
    mov ebx 0
L0: if. ebx < D$nDevices

        ; Loop through all buttons
        mov ecx 0
    L1: if.. ecx < D$LengthDeviceState

            ; Button down?
            test B$edx+ecx 080 | jz S0>

            ; Find mappings for this button
            mov esi D$pMappings+ebx*4
        L2: lodsw | on ax = 0, S0>
            lodsw | on ax != cx, L2<

            ; Set function = down
            movzx eax W$esi-4
            mov B$InputArray+eax BUTTON_DOWN
            jmp L2<

            ; Next button
        S0: inc ecx | jmp L1<
        endif..

        ; Next device
        add edx D$LengthDeviceState
        inc ebx | jmp L0<<

    endif

    ; Compare with old status, set additional flags
    mov ebx 0
L0: ifFlag  B$OldInputArray+ebx BUTTON_DOWN,
        ifFlag B$InputArray+ebx BUTTON_UP,
            or B$InputArray+ebx BUTTON_RELEASED
    ifFlag  B$OldInputArray+ebx BUTTON_UP,
        ifFlag B$InputArray+ebx BUTTON_DOWN,
            or B$InputArray+ebx BUTTON_PRESSED
    inc ebx | on ebx < LENGTH_INPUTARRAY, L0<
    ret

____________________________________________________________________________________________
; Handle input
____________________________________________________________________________________________

HandleInput:

    ; NES
    ifFlag B$InputArray+TOGGLE_POWER       BUTTON_PRESSED, call MenuPower
    ifFlag B$InputArray+RESET              BUTTON_PRESSED, call MenuReset
    ifFlag B$InputArray+QUICK_SAVE         BUTTON_PRESSED, call SaveQuick
    ifFlag B$InputArray+QUICK_LOAD         BUTTON_PRESSED, call LoadQuick
    ifFlag B$InputArray+SAVE_DIALOG        BUTTON_PRESSED, call MenuSaveGame
    ifFlag B$InputArray+LOAD_DIALOG        BUTTON_PRESSED, call MenuLoadGame

    ; Nessie
    ifFlag. B$InputArray+TOGGLE_PAUSE      BUTTON_PRESSED
        xor B$Paused &TRUE
        call ClearAudio
    endif
    ifFlag B$InputArray+FAST_FORWARD       BUTTON_PRESSED,  call StopAudio
    ifFlag B$InputArray+FAST_FORWARD       BUTTON_RELEASED, call PlayAudio
    ifFlag B$InputArray+CLOSE              BUTTON_PRESSED,  call 'User32.DestroyWindow' D$hMainWindow
    ifFlag B$InputArray+FULLSCREEN         BUTTON_PRESSED,  call ToggleFullscreen
    ifFlag B$InputArray+TAKE_SCREENSHOT    BUTTON_PRESSED,  call SaveScreenshot

    ; Autofire
    call HandleAutoFire
    ret

HandleAutoFire:

    ; Button down?
    ifFlag. B$InputArray+PAD1_AUTOFIRE_A BUTTON_DOWN | inc B$AutoFire+00 | else | mov B$AutoFire+00 0 | endif
    ifFlag. B$InputArray+PAD1_AUTOFIRE_B BUTTON_DOWN | inc B$AutoFire+01 | else | mov B$AutoFire+01 0 | endif
    ifFlag. B$InputArray+PAD2_AUTOFIRE_A BUTTON_DOWN | inc B$AutoFire+02 | else | mov B$AutoFire+02 0 | endif
    ifFlag. B$InputArray+PAD2_AUTOFIRE_B BUTTON_DOWN | inc B$AutoFire+03 | else | mov B$AutoFire+03 0 | endif
    ifFlag. B$InputArray+PAD3_AUTOFIRE_A BUTTON_DOWN | inc B$AutoFire+04 | else | mov B$AutoFire+04 0 | endif
    ifFlag. B$InputArray+PAD3_AUTOFIRE_B BUTTON_DOWN | inc B$AutoFire+05 | else | mov B$AutoFire+05 0 | endif
    ifFlag. B$InputArray+PAD4_AUTOFIRE_A BUTTON_DOWN | inc B$AutoFire+06 | else | mov B$AutoFire+06 0 | endif
    ifFlag. B$InputArray+PAD4_AUTOFIRE_B BUTTON_DOWN | inc B$AutoFire+07 | else | mov B$AutoFire+07 0 | endif

    ; Reset autofire cycle?
    mov al B$AutoFireDelay
    if al <= B$AutoFire+00, mov B$AutoFire+00 0
    if al <= B$AutoFire+01, mov B$AutoFire+01 0
    if al <= B$AutoFire+02, mov B$AutoFire+02 0
    if al <= B$AutoFire+03, mov B$AutoFire+03 0
    if al <= B$AutoFire+04, mov B$AutoFire+04 0
    if al <= B$AutoFire+05, mov B$AutoFire+05 0
    if al <= B$AutoFire+06, mov B$AutoFire+06 0
    if al <= B$AutoFire+07, mov B$AutoFire+07 0

    ; Button auto-down?
    mov al B$AutoFireDelay  | shr al 1
    if al >= B$AutoFire+00, if B$AutoFire+00 > 0, mov B$InputArray+PAD1_A BUTTON_DOWN
    if al >= B$AutoFire+01, if B$AutoFire+01 > 0, mov B$InputArray+PAD1_B BUTTON_DOWN
    if al >= B$AutoFire+02, if B$AutoFire+02 > 0, mov B$InputArray+PAD2_A BUTTON_DOWN
    if al >= B$AutoFire+03, if B$AutoFire+03 > 0, mov B$InputArray+PAD2_B BUTTON_DOWN
    if al >= B$AutoFire+04, if B$AutoFire+04 > 0, mov B$InputArray+PAD3_A BUTTON_DOWN
    if al >= B$AutoFire+05, if B$AutoFire+05 > 0, mov B$InputArray+PAD3_B BUTTON_DOWN
    if al >= B$AutoFire+06, if B$AutoFire+06 > 0, mov B$InputArray+PAD4_A BUTTON_DOWN
    if al >= B$AutoFire+07, if B$AutoFire+07 > 0, mov B$InputArray+PAD4_B BUTTON_DOWN
    ret

____________________________________________________________________________________________
; Add/remove button assignments
____________________________________________________________________________________________

AssignFunction:

    arguments @Device, @Button, @Function

    ; Scan through button assignments
    mov ebx D@Device
    mov esi D$pMappings+ebx*4
L0: lodsd
    if. eax = 0
        ; Put new function at the end
        copy W@Function W$esi-4
        copy W@Button   W$esi-2
        mov D$esi 0
    else
        ; Function already assigned?
        on ax != W@Function, L0<
        mov ax W$esi-2 | on ax != W@Button, L0<
    endif
    return

UnAssignFunction:

    arguments @Function

    ; Scan through all devices
    mov ebx 0
L0: if. ebx < D$nDevices

        ; Find function
        mov esi D$pMappings+ebx*4
    L1: lodsd
        if.. eax > 0

            on ax != W@Function, L1<

            ; Remove it
            pushad
                move edi esi-4
            L2: movsd | on D$edi-4 != 0, L2<
            popad
            sub esi 4
            jmp L1<

        endif..

        ; Next device
        inc ebx | jmp L0<

    endif
    return

____________________________________________________________________________________________
; Input array
____________________________________________________________________________________________

; Button assignments
[Mappings: ? #(NUM_DEVICES shl 8)] ; W$ FunctionID, W$ DIK_****

; Input array
[LENGTH_INPUTARRAY 0100]
[OldInputArray: B$ ? #LENGTH_INPUT_ARRAY]
[InputArray:    B$ ? #LENGTH_INPUT_ARRAY]

; Input array flags
[BUTTON_DOWN            080
 BUTTON_UP              040
 BUTTON_CHANGED         BUTTON_RELEASED+BUTTON_PRESSED
 BUTTON_RELEASED        020
 BUTTON_PRESSED         010
 BUTTON_LOCKED_DOWN     08
 BUTTON_TOGGLED         BUTTON_PRESSED]

; Input array indexes
enumerate 1,

    ; Nessie
    CLOSE, TOGGLE_PAUSE, FAST_FORWARD,
    FULLSCREEN, TAKE_SCREENSHOT,

    ; NES
    TOGGLE_POWER, RESET,
    QUICK_SAVE, QUICK_LOAD, SAVE_DIALOG, LOAD_DIALOG,

    ; NES pads
    PAD1_A, PAD1_B, PAD1_SELECT, PAD1_START, PAD1_UP, PAD1_DOWN, PAD1_LEFT, PAD1_RIGHT, PAD1_AUTOFIRE_A, PAD1_AUTOFIRE_B,
    PAD2_A, PAD2_B, PAD2_SELECT, PAD2_START, PAD2_UP, PAD2_DOWN, PAD2_LEFT, PAD2_RIGHT, PAD2_AUTOFIRE_A, PAD2_AUTOFIRE_B,
    PAD3_A, PAD3_B, PAD3_SELECT, PAD3_START, PAD3_UP, PAD3_DOWN, PAD3_LEFT, PAD3_RIGHT, PAD3_AUTOFIRE_A, PAD3_AUTOFIRE_B,
    PAD4_A, PAD4_B, PAD4_SELECT, PAD4_START, PAD4_UP, PAD4_DOWN, PAD4_LEFT, PAD4_RIGHT, PAD4_AUTOFIRE_A, PAD4_AUTOFIRE_B,

    OPEN_DIALOG

____________________________________________________________________________________________
; DirectInput device data
____________________________________________________________________________________________

; Interface pointer
[lpdi: ?]

; Device data
[NUM_DEVICES 20]
[nDevices:          ?
 DeviceStates:      ? #(NUM_DEVICES shl 8)
 GUID:              ? #(NUM_DEVICES shl 2)
 lpdid:             ? #NUM_DEVICES
 DeviceType:        ? #NUM_DEVICES
 LengthDeviceState: ? #NUM_DEVICES
 pMappings:         ? #NUM_DEVICES
 pButtonNames:      ? #NUM_DEVICES]

____________________________________________________________________________________________
; Input settings (autofire)
____________________________________________________________________________________________

[AutoFire: B$ ? #8]
[LENGTH_INPUTSETTINGS <(1 shl 2)>]
[InputSettings:
 AutoFireDelay: ?

 Port1:         ?
 Port2:         ?
 Port3:         ?
 Port4:         ?]

[CONTROLLER_GAMEPAD     01
 CONTROLLER_ZAPPER      02
 CONTROLLER_UNCONNECTED 080]

____________________________________________________________________________________________
; Vtables
____________________________________________________________________________________________

; IDirectInput
[CreateDevice           12
 EnumDevices            16
 GetDeviceStatus        20
 RunControlPanel        24
 diInitialize           28]

; IDirectInputDevice
[GetCapabilities        12
 EnumObjects            16
 GetProperty            20
 SetProperty            24
 Acquire                28
 Unacquire              32
 GetDeviceState         36
 GetDeviceData          40
 SetDataFormat          44
 SetEventNotification   48
 didSetCooperativeLevel 52
 GetObjectInfo          56
 GetDeviceInfo          60
 didRunControlPanel     64
 didInitialize          68
; IDirectInputDevice2
 CreateEffect           72
 EnumEffects            76
 GetEffectInfo          80
 GetForceFeedbackState  84
 SendForceFeedbackCommand 88
 EnumCreatedEffectObjects 92
 Escape                 96
 Poll                   100
 SendDeviceData         104]

[IID_IDirectInputDevice2:
 D$ 05944E682
 W$ 0C92E, 011CF
 B$ 0BF, 0C7, 044, 045, 053, 054, 000, 000]

____________________________________________________________________________________________
; Data format
____________________________________________________________________________________________

Init_rgodfKeyboard:

    mov ecx 0
    mov edi rgodfKeyboard
L0: mov eax GUID_Key                            | stosd
    mov eax ecx                                 | stosd
    shl eax 8 | or eax &DIDFT_BUTTON+080000000  | stosd
    mov eax &NULL                               | stosd
    inc cl | jnz L0<
    ret

; Keyboard data format
[c_dfDIKeyboard:
 @dwSize:     018
 @dwObjSize:  010
 @dwFlags:    &DIDF_RELAXIS
 @dwDataSize: 0100
 @dwNumObjs:  0100
 @rgodf:      rgodfKeyboard]
; GUID_Key, (button #), (DIDFT_BUTTON | 080000000 | DIDFT_MAKEINSTANCE(button #)), NULL
[rgodfKeyboard: ? #0400]

; Joystick data format
[c_dfDIJoyStick:
 @dwSize:       018
 @dwObjSize:    010
 @dwFlags:      &DIDF_ABSAXIS
 @dwDataSize:   050
 @dwNumObjs:    020
 @rgodf:        rgodfJoystick]
[rgodfJoystick:
 GUID_XAxis     00      &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_YAxis     04      &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_ZAxis     08      &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_RxAxis    0C      &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_RyAxis    010     &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_RzAxis    014     &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_Slider    018     &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_Slider    01C     &DIDFT_ANYINSTANCE+080000000+&DIDFT_AXIS    &DIDOI_ASPECTPOSITION
 GUID_POV       020     &DIDFT_ANYINSTANCE+080000000+&DIDFT_POV     0
 GUID_POV       024     &DIDFT_ANYINSTANCE+080000000+&DIDFT_POV     0
 GUID_POV       028     &DIDFT_ANYINSTANCE+080000000+&DIDFT_POV     0
 GUID_POV       02C     &DIDFT_ANYINSTANCE+080000000+&DIDFT_POV     0
 &NULL          030     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          031     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          032     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          033     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          034     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          035     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          036     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          037     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          038     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          039     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03A     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03B     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03C     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03D     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03E     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          03F     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          040     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          041     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          042     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          043     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          044     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          045     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          046     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          047     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          048     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          049     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04A     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04B     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04C     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04D     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04E     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0
 &NULL          04F     &DIDFT_ANYINSTANCE+080000000+&DIDFT_BUTTON  0]

; Input object GUIDs
[GUID_XAxis:   D$ 0A36D02E0, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_YAxis:   D$ 0A36D02E1, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_ZAxis:   D$ 0A36D02E2, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_RxAxis:  D$ 0A36D02F4, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_RyAxis:  D$ 0A36D02F5, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_RzAxis:  D$ 0A36D02E3, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_Slider:  D$ 0A36D02E4, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_Button:  D$ 0A36D02F0, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_Key:     D$ 055728220, W$ 0D33C,011CF, B$ 0BF,0C7,044,045,053,054,000,000
 GUID_POV:     D$ 0A36D02F2, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000]
;GUID_Unknown: D$ 0A36D02F3, W$ 0C9F3,011CF, B$ 0BF,0C7,044,045,053,054,000,000

____________________________________________________________________________________________
; Input object names
____________________________________________________________________________________________

[JoystickNames: B$

 ; Axes
 'lX-',    0    'lX+',   0      '...', 0        '...', 0
 'lY-',    0    'lY+',   0      '...', 0        '...', 0
 'lZ-',    0    'lZ+',   0      '...', 0        '...', 0
 'lRX-',   0    'lRX+',  0      '...', 0        '...', 0
 'lRY-',   0    'lRY+',  0      '...', 0        '...', 0
 'lRZ-',   0    'lRZ+',  0      '...', 0        '...', 0

 ; Sliders
 '...',    0    '...',   0      '...', 0        '...', 0
 '...',    0    '...',   0      '...', 0        '...', 0

 ; POVs
 'POV Up',  0   'POV Right',  0 'POV Down',  0  'POV Left',  0
 'POV2 Up', 0   'POV2 Right', 0 'POV2 Down', 0  'POV2 Left', 0
 'POV3 Up', 0   'POV3 Right', 0 'POV3 Down', 0  'POV3 Left', 0
 'POV4 Up', 0   'POV4 Right', 0 'POV4 Down', 0  'POV4 Left', 0

 ; Buttons
 'Button 0',  0 'Button 1',  0  'Button 2',  0  'Button 3',  0
 'Button 4',  0 'Button 5',  0  'Button 6',  0  'Button 7',  0
 'Button 8',  0 'Button 9',  0  'Button 10', 0  'Button 11', 0
 'Button 12', 0 'Button 13', 0  'Button 14', 0  'Button 15', 0
 'Button 16', 0 'Button 17', 0  'Button 18', 0  'Button 19', 0
 'Button 20', 0 'Button 21', 0  'Button 22', 0  'Button 23', 0
 'Button 24', 0 'Button 25', 0  'Button 26', 0  'Button 27', 0
 'Button 28', 0 'Button 29', 0  'Button 30', 0  'Button 31', 0

KeyboardNames: B$
; 00
'...', 0
'Escape', 0
'1', 0
'2', 0
'3', 0
'4', 0
'5', 0
'6', 0
'7', 0
'8', 0
'9', 0
'0', 0
'-', 0
'=', 0
'Backspace', 0
'Tab', 0
; 10
'Q', 0
'W', 0
'E', 0
'R', 0
'T', 0
'Y', 0
'U', 0
'I', 0
'O', 0
'P', 0
'[', 0
']', 0
'Return', 0
'Left control', 0
'A', 0
'S', 0
; 20
'D', 0
'F', 0
'G', 0
'H', 0
'J', 0
'K', 0
'L', 0
';', 0
"'", 0
167, 0
'Left shift', 0
'\', 0
'Z', 0
'X', 0
'C', 0
'V', 0
; 30
'B', 0
'N', 0
'M', 0
',', 0
'.', 0
'/', 0
'Right shift', 0
'Numpad *', 0
'Left alt', 0
'Space', 0
'Caps lock', 0
'F1', 0
'F2', 0
'F3', 0
'F4', 0
'F5', 0
; 40
'F6', 0
'F7', 0
'F8', 0
'F9', 0
'F10', 0
'Num lock', 0
'Scroll lock', 0
'Numpad 7', 0
'Numpad 8', 0
'Numpad 9', 0
'Numpad -', 0
'Numpad 4', 0
'Numpad 5', 0
'Numpad 6', 0
'Numpad +', 0
'Numpad 1', 0
; 50
'Numpad 2', 0
'Numpad 3', 0
'Numpad 0', 0
'Numpad .', 0
'...', 0 ; 54
'...', 0 ; 55
'<', 0
'F11', 0
'F12', 0
'...', 0 ; 59
'...', 0 ; 5A
'...', 0 ; 5B
'...', 0 ; 5C
'...', 0 ; 5D
'...', 0 ; 5E
'...', 0 ; 5F
; 60
'...', 0 ; 60
'...', 0 ; 61
'...', 0 ; 62
'...', 0 ; 63
'F13', 0
'F14', 0
'F15', 0
'...', 0 ; 67
'...', 0 ; 68
'...', 0 ; 69
'...', 0 ; 6A
'...', 0 ; 6B
'...', 0 ; 6C
'...', 0 ; 6D
'...', 0 ; 6E
'...', 0 ; 6F
; 70
'Kana', 0
'...', 0 ; 71
'...', 0 ; 72
'Cedilha', 0
'...', 0 ; 74
'...', 0 ; 75
'...', 0 ; 76
'...', 0 ; 77
'...', 0 ; 78
'Convert', 0
'...', 0 ; 7A
'No convert', 0
'...', 0 ; 7C
'Yen', 0
'Cedilha', 0
'...', 0 ; 7F
; 80
'...', 0 ; 80
'...', 0 ; 81
'...', 0 ; 82
'...', 0 ; 83
'...', 0 ; 84
'...', 0 ; 85
'...', 0 ; 86
'...', 0 ; 87
'...', 0 ; 88
'...', 0 ; 89
'...', 0 ; 8A
'...', 0 ; 8B
'...', 0 ; 8C
'Numpad =', 0
'...', 0 ; 8E
'...', 0 ; 8F
; 90
'Previous Track', 0
'AT', 0
':', 0
'_', 0
'Kanji', 0
'Stop', 0
'AX', 0
'[Unlabeled]', 0
'...', 0 ; 98
'Next Track', 0
'...', 0 ; 9A
'...', 0 ; 9B
'Numpad Enter', 0
'Right Control', 0
'...', 0 ; 9E
'...', 0 ; 9F
; A0
'Mute', 0
'Calculator', 0
'Play/Pause', 0
'...', 0 ; A3
'Media Stop', 0
'...', 0 ; A5
'...', 0 ; A6
'...', 0 ; A7
'...', 0 ; A8
'...', 0 ; A9
'...', 0 ; AA
'...', 0 ; AB
'...', 0 ; AC
'...', 0 ; AD
'Volume Down', 0
'...', 0 ; AF
; B0
'Volume Up', 0
'...', 0 ; B1
'Home', 0
'Numpad ,', 0
'...', 0 ; B4
'Numpad /', 0
'...', 0 ; B6
'Print screen', 0
'Right alt', 0
'...', 0 ; B9
'...', 0 ; BA
'...', 0 ; BB
'...', 0 ; BC
'...', 0 ; BD
'...', 0 ; BE
'...', 0 ; BF
; C0
'...', 0 ; C0
'...', 0 ; C1
'...', 0 ; C2
'...', 0 ; C3
'...', 0 ; C4
'Pause', 0
'...', 0 ; C6
'Home', 0
'Up', 0
'Page up', 0
'...', 0 ; CA
'Left', 0
'...', 0 ; CC
'Right', 0
'...', 0 ; CE
'End', 0
; D0
'Down', 0
'Page down', 0
'Insert', 0
'Delete', 0
'...', 0 ; D4
'...', 0 ; D5
'...', 0 ; D6
'...', 0 ; D7
'...', 0 ; D8
'...', 0 ; D9
'...', 0 ; DA
'Left Windows Key', 0
'Right Windows Key', 0
'Application Menu', 0
'Power', 0
'Sleep', 0
; E0
'...', 0 ; E0
'...', 0 ; E1
'...', 0 ; E2
'Wake', 0
'...', 0 ; E4
'Web Search', 0
'Web Favorites', 0
'Web Refresh', 0
'Web Stop', 0
'Web Forward', 0
'Web Back', 0
'My Computer', 0
'Mail', 0
'Media Select', 0
'...', 0  ; EE
'...', 0] ; EF
____________________________________________________________________________________________
