TITLE GameGenie

GameGenieDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam
    pushad

        ; Message?
        if. D@Message = &WM_CLOSE       | call @Close      | else
        if. D@Message = &WM_COMMAND     | call @Command    | else
        if. D@Message = &WM_INITDIALOG  | call @InitDialog | else | mov eax &FALSE | endif

        mov D$esp+28 eax

    popad
    return

@InitDialog:

    call @PutCodesInListBox
    mov eax &TRUE
    ret

@Command:

    ; Escape pressed
    on W@wParam = &IDCANCEL, @Close

    ; Enter in edit box -> add code
    if. W@wParam = &IDOK
        call 'User32.GetFocus'
        call 'User32.GetDlgCtrlID' eax
        if eax = IDC_EDIT+0, mov D@wParam IDC_BUTTON+0
    endif

    ; Add code
    if. D@wParam = IDC_BUTTON+0
        ; Decode
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_EDIT+0, &WM_GETTEXT, 010, GameGenieString
        call GameGenieDecode
        if eax = &INVALID_HANDLE_VALUE, break
        ; Encode, add if not found
        call GameGenieEncode
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_FINDSTRINGEXACT, 0-1, GameGenieString
        if eax != &LB_ERR, break
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_ADDSTRING, 0, GameGenieString
    endif

    ; Remove
    if. D@wParam = IDC_BUTTON+1
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCURSEL, 0, 0
        if eax = &LB_ERR, break
        push eax
            call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_DELETESTRING, eax, 0
            call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCOUNT, 0, 0
        pop edx
        dec eax
        if edx <= eax, mov eax edx
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_SETCURSEL, eax, 0
    endif

    ; Close dialog
    if D@wParam = IDC_BUTTON+2, call @Close
    mov eax &TRUE
    ret

@Close:

    call @GetCodesFromListbox
    call 'User32.EndDialog' D@hDialog, 1
    ret
____________________________________________________________________________________________

@PutCodesInListbox:

    ; Fill list box with codes
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_RESETCONTENT, 0, 0
    mov esi GameGenieCodes
L0: lodsd
    if. eax != &INVALID_HANDLE_VALUE
        push esi
            call GameGenieEncode
            call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_ADDSTRING, 0, GameGenieString
        pop esi | jmp L0<
    endif
    ret

@GetCodesFromListbox:

    mov D$GameGenieCodes &INVALID_HANDLE_VALUE
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCOUNT, 0, 0
    mov ebx 0
L0: on ebx >= eax, Q0>
    pushad
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETTEXT, ebx, GameGenieString
        call GameGenieDecode
        call GameGenieAddCode eax
    popad
    inc ebx | jmp L0<
Q0: ret
____________________________________________________________________________________________

GameGenieDecode:

    ; Length valid?
    [@Length: ?]
    mov edi GameGenieString, al 0, ecx 0F | repne scasb
    xor ecx 0F | dec ecx | mov D@Length ecx

    ; Convert characters to binary values, break if invalid character is found
    mov esi GameGenieString, edi GameGenieNumbers
L0: lodsb | or al 020
    mov ebx 0
L1: if. al != B$GameGenieCharacters+ebx
        inc ebx | on ebx <= 0F, L1<
        ; Invalid character found
        mov D@Length 0-1
    else
        mov B$edi bl | inc edi
        on B$esi > 0, L0<
    endif

    ; Extract address
    mov edx 0
    movzx eax B$GameGenieNumbers+04 | and al 07 | shl eax 00 | or edx eax
    movzx eax B$GameGenieNumbers+03 | and al 08 | shl eax 00 | or edx eax
    movzx eax B$GameGenieNumbers+02 | and al 07 | shl eax 04 | or edx eax
    movzx eax B$GameGenieNumbers+01 | and al 08 | shl eax 04 | or edx eax
    movzx eax B$GameGenieNumbers+05 | and al 07 | shl eax 08 | or edx eax
    movzx eax B$GameGenieNumbers+04 | and al 08 | shl eax 08 | or edx eax
    movzx eax B$GameGenieNumbers+03 | and al 07 | shl eax 0C | or edx eax
    movzx eax B$GameGenieNumbers+02 | and al 08 | shl eax 0C | or edx eax
    if D@Length = 8, or edx 08000
    shl edx 8

    ; Extract values
    if. D@Length = 6

        ; 6 character code
        movzx eax B$GameGenieNumbers+00 | and al 07 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+05 | and al 08 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+01 | and al 07 | shl eax 04 | or edx eax
        movzx eax B$GameGenieNumbers+00 | and al 08 | shl eax 04 | or edx eax
        shl edx 8

    else
    if. D@Length = 8

        ; 8 character code
        movzx eax B$GameGenieNumbers+00 | and al 07 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+07 | and al 08 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+01 | and al 07 | shl eax 04 | or edx eax
        movzx eax B$GameGenieNumbers+00 | and al 08 | shl eax 04 | or edx eax
        shl edx 8

        ; Compare value
        movzx eax B$GameGenieNumbers+06 | and al 07 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+05 | and al 08 | shl eax 00 | or edx eax
        movzx eax B$GameGenieNumbers+07 | and al 07 | shl eax 04 | or edx eax
        movzx eax B$GameGenieNumbers+06 | and al 08 | shl eax 04 | or edx eax

    else

        ; Invalid length or invalid character
        mov edx &INVALID_HANDLE_VALUE

    endif
    mov eax edx
    ret

; Gets code in eax, returns string in GameGenieString
GameGenieEncode:

    mov edx eax
    call ZeroMemory GameGenieNumbers, 8

    ; Convert value and compare bits
    ifNotFlag. edx 08000_0000

        ; Value
        shr edx 8
        mov eax edx | shr eax 00 | and al 07 | or B$GameGenieNumbers+00 al
        mov eax edx | shr eax 00 | and al 08 | or B$GameGenieNumbers+05 al
        mov eax edx | shr eax 04 | and al 07 | or B$GameGenieNumbers+01 al
        mov eax edx | shr eax 04 | and al 08 | or B$GameGenieNumbers+00 al
        shr edx 8

        ; 6 characters
        mov ecx 6

    else

        ; Compare
        mov eax edx | shr eax 00 | and al 07 | or B$GameGenieNumbers+06 al
        mov eax edx | shr eax 00 | and al 08 | or B$GameGenieNumbers+05 al
        mov eax edx | shr eax 04 | and al 07 | or B$GameGenieNumbers+07 al
        mov eax edx | shr eax 04 | and al 08 | or B$GameGenieNumbers+06 al
        shr edx 8

        ; Value
        mov eax edx | shr eax 00 | and al 07 | or B$GameGenieNumbers+00 al
        mov eax edx | shr eax 00 | and al 08 | or B$GameGenieNumbers+07 al
        mov eax edx | shr eax 04 | and al 07 | or B$GameGenieNumbers+01 al
        mov eax edx | shr eax 04 | and al 08 | or B$GameGenieNumbers+00 al
        shr edx 8

        ; 8 characters
        mov ecx 8

    endif

    ; Convert address bits
    mov eax edx | shr eax 00 | and al 07 | or B$GameGenieNumbers+04 al
    mov eax edx | shr eax 00 | and al 08 | or B$GameGenieNumbers+03 al
    mov eax edx | shr eax 04 | and al 07 | or B$GameGenieNumbers+02 al
    mov eax edx | shr eax 04 | and al 08 | or B$GameGenieNumbers+01 al
    mov eax edx | shr eax 08 | and al 07 | or B$GameGenieNumbers+05 al
    mov eax edx | shr eax 08 | and al 08 | or B$GameGenieNumbers+04 al
    mov eax edx | shr eax 0C | and al 07 | or B$GameGenieNumbers+03 al
    mov eax edx | shr eax 0C | and al 08 | or B$GameGenieNumbers+02 al ; length bit

    ; Convert numbers to characters
    mov esi GameGenieNumbers, edi GameGenieString, eax 0
L0: lodsb | mov al B$GameGenieCharacters+eax | and al 0FF-020
    stosb | dec ecx | jnz L0<
    mov B$edi 0
    ret
____________________________________________________________________________________________

ResetGameGenie:

    mov esi GameGenieCodes
    mov ebx 0
L0: lodsd | if eax = &INVALID_HANDLE_VALUE, ret

    mov edx eax
    shr edx 16

    ; Save previous setting, override
    ifFlag. edx 08000
        copy D$CPUReadTable+edx*4 D$GameGenieOriginal+ebx*4
        CPURead edx, edx, CompareGameGenie
    else
        or edx 08000
        copy D$CPUReadTable+edx*4 D$GameGenieOriginal+ebx*4
        CPURead edx, edx, ReadGameGenie
    endif

    ; Save Game Genie data for this address
    mov W$GameGenieAddress+ebx*2 dx
    mov B$GameGenieCompare+ebx al
    mov B$GameGenieValue+ebx ah
    inc ebx
    jmp L0<<

ReadGameGenie:

    pushad

        ; Find address
        mov edi GameGenieAddress, ecx 0-1
        repne scasw
        mov ebx edi | sub ebx GameGenieAddress+2 | shr ebx 1

        ; Override value
        movzx eax B$GameGenieValue
        mov D$esp+01C eax

    popad
    ret

CompareGameGenie:

    pushad

        ; Find address
        mov edi GameGenieAddress, ecx 0-1
        repne scasw
        mov ebx edi | sub ebx GameGenieAddress+2 | shr ebx 1

        ; Override value
        push ebx
            call D$GameGenieOriginal+ebx*4
        pop ebx
        if al = B$GameGenieCompare+ebx, mov al B$GameGenieValue+ebx
        mov D$esp+01C eax

    popad
    ret
____________________________________________________________________________________________

GameGenieAddCode:

    arguments @Code

    ; Get current length
    mov edi GameGenieCodes, eax &INVALID_HANDLE_VALUE, ecx 0-1
    repne scasd | not ecx

    ; Code already there?
    mov edi GameGenieCodes, eax D@Code
    repne scasd
    sub edi 4
    if. D$edi = &INVALID_HANDLE_VALUE
        ; Append code to end
        stosd | mov D$edi &INVALID_HANDLE_VALUE
    endif
    return
____________________________________________________________________________________________

SaveGameGenie:

    ; If there are codes, save. Otherwise, delete.
    [GameGenieFile: 'Game genie.gen', 0]
    if. D$GameGenieCodes != &INVALID_HANDLE_VALUE
        call SaveROMFile GameGenieFile
    else
        mov B$Filename 0
        call AddString Filename ROMDirectory
        call ADdString Filename GameGenieFile
        call 'Kernel32.DeleteFileA' Filename
    endif
    ret

LoadGameGenie:

    [GENExtension: '*.gen', 0]
    call LoadFirstFile ROMDirectory, GENExtension
    ret

SaveGEN:

    [@NewLine: B$ 13, 10, 0]

    ; Convert all codes to ascii
    mov ebx 0, edi SaveData
L0: mov eax D$GameGenieCodes+ebx*4 | inc ebx
    if. eax != &INVALID_HANDLE_VALUE
        pushad
            call GameGenieEncode
        popad
        mov esi GameGenieString
    L1: if.. B$esi != 0 | movsb | jmp L1< | endif..
        mov ax W@NewLine | stosw
        jmp L0<
    endif

    ; Set size of file
    sub edi SaveData | mov D$SaveSize edi
    ret

LoadGEN:

    ; Reset parser
    [@Comment: ?]
    mov esi D$pFile
    jmp @EndOfLine

    ; Which ascii?
L0: lodsb
    if al = 00,  ret
    on al = 10,  @EndOfLine
    on al = 13,  @EndOfLine
    on al = ';', @StartComment
    on al = ' ', @EndOfWord
    on al = 09,  @EndOfWord

    ; Character
    on edi > GameGenieString+010, L0<
    on B@Comment = &TRUE, L0<
    stosb | jmp L0<

@EndOfWord:

    ; Try to decode
    mov B$edi 0
    pushad
        call GameGenieDecode
        if eax != &INVALID_HANDLE_VALUE,
            call GameGenieAddCode eax
    popad
    mov edi GameGenieString
    jmp L0<

@EndOfLine:    mov B@Comment &FALSE | jmp @EndOfWord
@StartComment: mov B@Comment &TRUE  | jmp @EndOfWord

____________________________________________________________________________________________

[MAX_GAMEGENIE_CODES 0100]

[GameGenieCharacters: 'apzlgityeoxuksvn']
[GameGenieString:   B$ ? #010]
[GameGenieNumbers:  B$ ? #8]

[GameGenieCodes:    D$ ? #MAX_GAMEGENIE_CODES
 GameGenieAddress:  W$ ? #MAX_GAMEGENIECODES
 GameGenieCompare:  B$ ? #MAX_GAMEGENIECODES
 GameGenieValue:    B$ ? #MAX_GAMEGENIECODES
 GameGenieOriginal: D$ ? #MAX_GAMEGENIECODES]
____________________________________________________________________________________________
