TITLE Files

; Here's where all file loading/saving is handled.
; Pass the full file name to SaveRemoteFile or LoadRemoteFile.
; They will use the filename extension to decide what to do with it.
; From there, *.sav files are handled by LoadSAV and SaveSAV, *.cfg by LoadCFG, SaveCFG and so on.
; SaveNessieFile will save .\saves\settings\[argument]
; SaveROMFile will save .\saves\[ROMName]\[argument]
; For example, call LoadROMFile 'palette.pal' will load the palette for this ROM (if any).
; SaveNumberedROMFile is used for screenshots and save games. It saves .\saves\[ROMName]\[filename]xxx.[extension].

____________________________________________________________________________________________
; Save file
____________________________________________________________________________________________

SaveNessieFile:

    arguments @pFilename

    ; .\saves\
    call 'Kernel32.CreateDirectoryA' FilesDirectory, &NULL
    ; .\saves\settings\
    call 'Kernel32.CreateDirectoryA' NessieDirectory, &NULL
    ; .\saves\settings\filename.ext
    mov B$Filename 0
    call AddString Filename, NessieDirectory
    call AddString Filename, D@pFilename
    call SaveRemoteFile Filename
    return

SaveROMFile:

    arguments @pFilename

    ; .\saves\ROMTitle\
    call CreateROMDirectory
    ; .\saves\ROMTitle\filename.ext
    mov B$Filename 0
    call AddString Filename, ROMDirectory
    call AddString Filename, D@pFilename
    call SaveRemoteFile Filename
    return

SaveRemoteFile:

    arguments @pSaveFilename

    ; Extension
    mov edi D@pSaveFilename, al 0, ecx 0-1 | repne scasb
    copy D$edi-5 D$Extension | or D$Extension 020202020

    ; Identify
    if. D$Extension = '.pal' | call SavePAL | else
    if. D$Extension = '.cfg' | call SaveCFG | else
    if. D$Extension = '.gen' | if D$pImage != &NULL, call SaveGEN | else
    if. D$Extension = '.sav' | if D$pImage != &NULL, call SaveSAV | else
    if. D$Extension = '.bmp' | if D$pImage != &NULL, call SaveBMP | else
    if. D$Extension = '.sst' | if D$pImage != &NULL, call SaveSST | endif

    ; Open file
  . D$hFile = 'Kernel32.CreateFileA' D@pSaveFilename, &GENERIC_WRITE, &NULL, &NULL, &CREATE_ALWAYS, &FILE_ATTRIBUTE_NORMAL, &NULL

    if. D$hFile != &INVALID_HANDLE_VALUE
        call 'Kernel32.WriteFile' D$hFile, SaveData, D$SaveSize, Temp, &NULL
        call 'Kernel32.CloseHandle' D$hFile
    endif
    return

SaveNumberedROMFile:

    arguments @pFilename, @pExtension

    call CreateROMDirectory
    mov D$FileNumber 0

    ; - Convert to decimal -
    ; Push numbers
L0: mov eax D$FileNumber, ecx 10
    push 0FF
L1: mov edx 0 | div ecx
    push edx | on eax != 0, L1<
    ; Pop numbers
    mov edi FileNumberString
L2: pop eax
    if. eax != 0FF
        add al '0' | stosb
        jmp L2<
    endif
    mov B$edi 0

    ; Check if file exists
    mov B$Filename 0
    call AddString Filename, ROMDirectory
    call AddString Filename, D@pFilename
    call AddString Filename, FileNumberString
    call AddString Filename, D@pExtension
    call 'Kernel32.FindFirstFileA' Filename, WIN32_FIND_DATA

    ; File exists, try next number
    if. eax != &INVALID_HANDLE_VALUE
        call 'Kernel32.FindClose' eax
        inc D$FileNumber | jnz L0<< ; jnz, if someone would produce > 0FFFFFFFF save files :-D
    endif

    ; Found an unused number
    call SaveRemoteFile Filename
    return

[FileNumber: ?]
[FileNumberString: B$ ? #10]
[WIN32_FIND_DATA: D$ ? #11
 @cFileName:      B$ ? #&MAX_PATH
 @cAlternate:     B$ ? #14]

____________________________________________________________________________________________
; Load file
____________________________________________________________________________________________

LoadNessieFile:

    arguments @pFileName

    mov B$Filename 0
    call AddString Filename, NessieDirectory
    call AddString Filename, D@pFilename
    call LoadRemoteFile Filename
    return

LoadROMFile:

    arguments @pFileName

    if. D$pImage != &NULL
        mov B$Filename 0
        call AddString Filename, ROMDirectory
        call AddString Filename, D@pFilename
        call LoadRemoteFile Filename
    endif
    return

LoadRemoteFile:  ; Sets D$pFile, D$FileSize and Filetitle

    arguments @pLoadFilename

    ; Extension
    mov edi D@pLoadFileName, al 0, ecx 0-1 | repne scasb
    copy D$edi-5 D$Extension | or D$Extension 020202020

    ; Filetitle
    std
        mov al '\' | repne scasb
        add edi 2
    cld
    mov B$Filetitle 0
    call AddString Filetitle, edi
    mov edi Filetitle, ecx 0-1, al 0
    repne scasb
    sub edi 5 | call ZeroMemory edi, 4

    ; Open file
  . D$hFile = 'Kernel32.CreateFileA' D@pLoadFilename, &GENERIC_READ, &NULL, &NULL, &OPEN_EXISTING, &FILE_ATTRIBUTE_NORMAL, &NULL

    if.. D$hFile != &INVALID_HANDLE_VALUE

        ; Allocate space, read file
      . D$FileSize = 'Kernel32.GetFileSize' D$hFile &NULL
        if. eax <= 0800000 ; Files > 8MB are skipped
          . D$pFile = 'Kernel32.GlobalAlloc' &GPTR, D$FileSize                 | winErrorCheck 'Could not allocate memory for file.'
            call 'Kernel32.ReadFile' D$hFile, D$pFile, D$FileSize, Temp, &NULL | winErrorCheck 'Could not read file.'
        endif

        ; Close file
        call 'Kernel32.CloseHandle' D$hFile

        ; Focus on this window
        call 'User32.SetForegroundWindow' D$hMainWindow

        ; Convert to long name
        call 'Kernel32.GetLongPathNameA' D@pLoadFilename, D@pLoadFilename, &MAX_PATH
        mov edi FileTitle

        ; Identify
        if. D$Extension = '.zip' | call AddMRUItem D@pLoadFilename | call LoadZIP D@pLoadFilename | else
        if. D$Extension = '.nes' | call AddMRUItem D@pLoadFilename | call LoadNES | else
        if. D$Extension = '.pal' | call LoadPAL | else
        if. D$Extension = '.cfg' | call LoadCFG | else
        if. D$Extension = '.gen' | if D$pImage != &NULL, call LoadGEN | else
        if. D$Extension = '.ips' | if D$pImage != &NULL, call LoadIPS | else
        if. D$Extension = '.sst' | if D$pImage != &NULL, call LoadSST | else
        if. D$Extension = '.sav' | if D$pImage != &NULL, call LoadSAV | endif

        call 'Kernel32.GlobalFree' D$pFile | mov D$pFile &NULL

    endif..
    return

LoadFirstFile:

    arguments @pDirectory, @pFilename
    mov B$Filename 0
    call AddString Filename, D@pDirectory
    call AddString Filename, D@pFilename
    call 'Kernel32.FindFirstFileA' Filename, WIN32_FIND_DATA
    if. eax != &INVALID_HANDLE_VALUE
        call 'Kernel32.FindClose' eax
        mov B$Filename 0
        call AddString Filename, D@pDirectory
        call AddString Filename, WIN32_FIND_DATA@cFilename
        call LoadRemoteFile Filename
    endif
    return
____________________________________________________________________________________________
; Subdirectory (for saves and screenshots)
____________________________________________________________________________________________

CreateROMDirectory:

    if D$pImage = &NULL, ret

    ; .\
    call 'Kernel32.CreateDirectoryA' FilesDirectory, &NULL

    ; .\saves\RomTitle\
    call 'Kernel32.CreateDirectoryA' ROMDirectory, &NULL
    ret
____________________________________________________________________________________________
; Chunks
____________________________________________________________________________________________

SaveChunks:

    arguments @FileID, @pSavingTable

    mov edi D@pSavingTable, eax 0, ecx 0-1
    repne scasd | not ecx | dec ecx | mov D$MaxChunks ecx

    mov edi SaveData

    ; File ID
    mov eax D@FileID | stosd

    ; Write data chunks
    mov ebx 0
L0: if. ebx < D$MaxChunks
        mov eax ebx | stosd
        pushad
            mov edx D@pSavingTable
            call D$edx+ebx*4
        popad
        call CopyMemory Chunk, edi, D$ChunkSize | add edi D$ChunkSize
        inc ebx | jmp L0<
    endif
    sub edi SaveData | mov D$SaveSize edi
    return

LoadChunks:

    arguments @FileID, @pLoadingTable

    mov edi D@pLoadingTable, eax 0, ecx 0-1
    repne scasd | not ecx | dec ecx | mov D$MaxChunks ecx

    mov esi D$pFile
    on esi = &NULL, Q0>

    ; Verify file ID
    lodsd | on eax != D@FileID, Q0>

    ; Set end
    [@pEnd: ?]
    mov eax D$pFile | add eax D$FileSize
    mov D@pEnd eax

    ; Read block
L0: if. esi < D@pEnd

        ; Load chunk
        lodsd | mov ebx eax
        call CopyMemory esi, Chunk, D$esi

        ; Handle chunk data
        push esi
            mov edx D@pLoadingTable
            if ebx < D$MaxChunks, call D$edx+ebx*4
        pop esi

        ; Next chunk
        add esi D$ChunkSize | jmp L0<

    endif
Q0: return

SaveChunk:

    arguments @pData, @Size
    copy D@Size D$ChunkSize | add D$ChunkSize 4
    call CopyMemory D@pData, ChunkData, D@Size
    return

LoadChunk:

    arguments @pData, @Size
    call CopyMemory ChunkData, D@pData, D@Size
    return

____________________________________________________________________________________________
; Chunk data
____________________________________________________________________________________________

[ChunkID:   ?
 Chunk:
 ChunkSize: ?
 ChunkData: ? #080000]

[FILE_ID_CFG 'cfg0'
 FILE_ID_SST 'sst0']
[MaxChunks: ?]
[CFGSaveTable:
 SaveConfigVersion
 SaveConfigPreferences
 SaveConfigButtonAssignments
 SaveConfigInputSettings
 SaveConfigMRUList
 &NULL

 CFGLoadTable:
 LoadConfigVersion
 LoadConfigPreferences
 LoadConfigButtonAssignments
 LoadConfigInputSettings
 LoadConfigMRUList
 &NULL]

[SSTSaveTable:
 SaveGameDescription
 SaveGameScreenshot
 SaveGameCPU
 SaveGamePPU
 SaveGameAPU
 SaveGameRendering
 SaveGamePorts
 SaveGameMapper
 &NULL

 SSTLoadTable:
 LoadGameDescription
 LoadGameScreenshot
 LoadGameCPU
 LoadGamePPU
 LoadGameAPU
 LoadGameRendering
 LoadGamePorts
 LoadGameMapper
 &NULL]
____________________________________________________________________________________________
; File data
____________________________________________________________________________________________

[SaveSize: ?
 SaveData: ? #080000]
[WindowTitle: B$ ? #&MAX_PATH]

; File data
[hFile:         ?
 pFile:         ?
 FileSize:      ?
 FileTitle:  B$ ? #&MAX_PATH
 Extension:  D$ ?]

; Directories and filenames
[Argument:        B$ ? #&MAX_PATH]
[ROMDirectory:    B$ ? #&MAX_PATH] ; .\saves\[ROM name]\
[NessieDirectory: B$ ? #&MAX_PATH] ; .\saves\settings\
[FilesDirectory:  B$ ? #&MAX_PATH] ; .\saves\
[Filename:        B$ ? #&MAX_PATH]
[Filesname:         'saves\',       0
 NessieName:        'settings\',      0
 ConfigFilename:    'config.cfg',   0
 QuickSaveFilename: 'quick.sst',    0
 BatteryFilename:   'battery.sav',  0
 Backslash:         '\',            0]
____________________________________________________________________________________________

