TITLE ExSound

; Various sound chips
____________________________________________________________________________________________
; Namco106 sound
____________________________________________________________________________________________

Namco106Sound:

    mov D$SampleHook @SampleHook
    mov D$TimerHook  @TimerHook
    mov D@NumChannels 1
    mov ebx ExChannel, esi 8
L0: mov D$ebx+WaveLength (1 shl 22)
    add ebx 040
    dec esi | jnz L0<
    mov D$Register+04 080
    ret

[@NumChannels Register+08]

enumerate4 02C,
    Frequency, Address, dummy, Speed, WaveLength

@4800:

    call APUSynchronize
    if edx < 040, ret

    if. edx = 07F
        mov ecx eax | shr ecx 4
        and ecx 7 | inc ecx
        mov D@NumChannels ecx
    endif

    mov ebx edx | shr ebx 3
    and ebx 07 | shl ebx 6 ; mul 040, half a channel
    add ebx ExChannel
    and edx 07
    on edx = 0, @WriteReg0
    on edx = 2, @WriteReg1
    on edx = 4, @WriteReg2
    on edx = 6, @WriteReg3
    on edx = 7, @WriteReg4
    ret

@WriteReg0: mov B$ebx+Frequency+00 al | ret
@WriteReg1: mov B$ebx+Frequency+01 al | ret
@WriteReg2:

    ; Frequency
    mov B$ebx+Frequency+02 al
    and B$ebx+Frequency+02 03
    copy D$ebx+Frequency D$ebx+Speed
    ; Wavelength
    shr eax 2 | not eax | and eax 07 | inc eax | shl eax 20
    xchg eax D$ebx+WaveLength
    if eax != D$ebx+WaveLength, mov D$ebx+Phase 0
    jmp @ChannelActive

@WriteReg3: mov B$ebx+Address al | ret
@WriteReg4: and al 0F | mov D$ebx+Volume eax | jmp @ChannelActive
____________________________________________________________________________________________

@TimerHook:
push eax
mul D$CPUCycles
mov ecx (1 shl 20) | mul ecx
mov ecx 45 | div ecx

    mov ebx ExChannel+(7 shl 6)
    mov esi D@NumChannels
L0: if B$ebx+Active = &TRUE, add D$ebx+Timer eax
    sub ebx 040
    dec esi | jnz L0<
pop eax
    ret

@SampleHook:
;mov edi 0
    mov ebx ExChannel+(7 shl 6)
    mov esi D@NumChannels
L0: call @Sample
    add edi eax
    sub ebx 040
    dec esi | jnz L0<
    ret

@Sample:

    mov eax 0
    if B$ebx+Active = &FALSE, ret

    ; Count steps
    mov eax D$ebx+Timer
    mov ecx D@NumChannels | shl ecx 20
    mov eax D$ebx+Speed
L0: if. D$ebx+Timer >= ecx
        sub D$ebx+Timer ecx
        add D$ebx+Phase eax
        jmp L0<
    endif

    mov ecx D$ebx+WaveLength
L0: if. D$ebx+Phase >= ecx
        sub D$ebx+Phase ecx
        jmp L0<
    endif

    mov edx D$ebx+Phase | shr edx 18
    add edx D$ebx+Address
    shr edx 1 | setc cl
    movzx eax B$ExRAM+edx
    ifFlag cl 01, shr eax 4
    and eax 0F

    ; Next channel
    [@VolumeDivider: 12]
    mul D$ebx+Volume
    div D@VolumeDivider
    ret

@ChannelActive:

    mov B$ebx+Active &FALSE
    if D$ebx+Speed > 0,
        if D$ebx+Wavelength > 0,
            if D$ebx+Volume > 0,
                mov B$ebx+Active &TRUE
    ret
____________________________________________________________________________________________
; VRC6 sound
____________________________________________________________________________________________

VRC6:

    ; Hooks
    mov D$TimerHook @TimerHook
    mov D$SampleHook @SampleHook
    ret

[@Square0  ExChannel0
 @Square1  ExChannel1
 @Sawtooth ExChannel2]

@9000: call @SquareReg0 @Square0 | ret
@9001: call @SquareReg1 @Square0 | ret
@9002: call @SquareReg2 @Square0 | ret

@A000: call @SquareReg0 @Square1 | ret
@A001: call @SquareReg1 @Square1 | ret
@A002: call @SquareReg2 @Square1 | ret

; --pp pppp
@B000:

    call APUSynchronize
    and al 03F
    mov B@Sawtooth+Phase al
    ret

@B001: call @SquareReg1 @Sawtooth | ret
@B002: call @SquareReg2 @Sawtooth | ret
____________________________________________________________________________________________

; Dddd vvvv
@SquareReg0:

    call APUSynchronize
    pop edx ebx | push edx

    ; ---- vvvv
    mov B$ebx+Volume al
    and B$ebx+Volume 0F

    ; Dddd
    shr al 4
    ifFlag al 08, mov al 0F
    mov B$ebx+DutyCycleType al
    ret

; wwww wwww
@SquareReg1:

    call APUSynchronize
    pop edx, ebx | push edx

    ; wwww wwww
    mov B$ebx+TimerLatch al
    ret


; e--- wwww
@SquareReg2:

    call APUSynchronize
    pop edx ebx | push edx

    ; e--- ----
    test al 080 | setnz B$ebx+LengthEnabled

    ; ---- wwww
    and al 0F
    mov b$ebx+TimerLatch+1 al
    ret
____________________________________________________________________________________________

@TimerHook:

    add D@Square0+Timer  eax
    add D@Square1+Timer  eax
    add D@Sawtooth+Timer eax
    ret

@SampleHook:

    call @SampleSquare @Square0 | add edi D@Square0+Output
    call @SampleSquare @Square1 | add edi D@Square1+Output
    call @SampleSawtooth        | mov eax D@Sawtooth+Output | shr eax 3 | add edi eax
    ret

@SampleSquare:

    pop eax, ebx | push eax

or D$ebx+TimerLatch 01

    ; Count steps
    mov eax D$ebx+Timer, edx 0
    div D$ebx+TimerLatch
    mov D$ebx+Timer edx

    if B$ebx+LengthEnabled = &FALSE, ret

    ; Wave high or low?
    add eax D$ebx+DutyCycleCounter | and eax 0F
    mov D$ebx+DutyCycleCounter eax

    if. eax > D$ebx+DutyCycleType
        mov B$ebx+Output 0
    else
        copy D$ebx+Volume D$ebx+Output
    endif
    ret

@SampleSawtooth:

or D@SawTooth+TimerLatch 01

    ; Count steps
    mov eax D@Sawtooth+Timer, edx 0
    mov ecx D@SawTooth+TimerLatch | shl ecx 1
    div ecx
    mov D@Sawtooth+Timer edx

    if B@Sawtooth+LengthEnabled = &FALSE, mov eax 0
    mov ecx eax | jecxz Q0>
    mov eax D@Sawtooth+Phase

    ; Add to accumulator
L0: add B@Sawtooth+Output al
    inc D@Sawtooth+Counter7
    if. D@Sawtooth+Counter7 >= 7
        mov D@SawTooth+Counter7 0
        mov D@SawTooth+Output 0
    endif
    dec ecx | jnz L0<
Q0: ret

enumerate4 030, Counter7, Phase

____________________________________________________________________________________________
; FME-7 sound

; !!! Noise channel not implemented yet (Gimmick doesn't seem to use it)

; $C000-$DFFF: xxxxCCCx - command number
; $E000-$FFFF: (CCC = 00)
____________________________________________________________________________________________

FME7Sound:

    ; Channel registers
    CPUWrite 0C000, 0DFFF, @C000_DFFF
    CPUWrite 0E000, 0FFFF, @E000_FFFF

    ; Sample hook
    mov D$TimerHook  @TimerHook
    mov D$SampleHook @SampleHook

    ; Noise
    mov D@Noise+ShiftRegister 01
    ret

____________________________________________________________________________________________

[@Square1       ExChannel0
 @Square2       ExChannel1
 @Square3       ExChannel2
 @Envelope      ExChannel3
 @Noise         ExChannel4]

[Flags          LinearCounter
 NoVolume       LinearCounterHalt
 SquareToggle   LinearCounterLoad
 WaveForm       DutyCycleType]

____________________________________________________________________________________________

@C000_DFFF:

    mov edx 0, ecx 0E
    div ecx | mov D$Command edx
    ret

@E000_FFFF:

    call APUSynchronize
    mov edx D$Command

    ; Timers
    if. dl <= 01
        and edx 1
        shr W@Square1+TimerLatch 3 | mov B@Square1+TimerLatch+edx al
        shl W@Square1+TimerLatch 3
    else
    if. dl <= 03
        and edx 1
        shr W@Square2+TimerLatch 3 | mov B@Square2+TimerLatch+edx al
        shl W@Square2+TimerLatch 3
    else
    if. dl <= 05
        and edx 1
        shr W@Square3+TimerLatch 3 | mov B@Square3+TimerLatch+edx al
        shl W@Square3+TimerLatch 3
    else

    if. dl = 06
        and al 01F | shl al 3
        mov B@Noise+TimerLatch al
    else

    ; Channel select
    if. dl = 07
        not al
ifFlag al 038, outwrite
        mov dl al | and dl 08+01 | mov B@Square1+Flags dl | shr al 1
        mov dl al | and dl 08+01 | mov B@Square2+Flags dl | shr al 1
        mov dl al | and dl 08+01 | mov B@Square3+Flags dl
    else

    ; Volume
    if. dl = 8
        test al 010 | setnz B@Square1+NoVolume | jnz end
        and al 0F | mov B@Square1+Volume al
    else
    if. dl = 09
        test al 010 | setnz B@Square2+NoVolume | jnz end
        and al 0F | mov B@Square2+Volume al
    else
    if. dl = 0A
        test al 010 | setnz B@Square3+NoVolume | jnz end
        and al 0F | mov B@Square3+Volume al
    else

    ; Envelope frequency
    if. dl = 0B
        shr W@Envelope+TimerLatch 3 | mov B@Envelope+TimerLatch+Timer+00 al
        shl W@Envelope+TimerLatch 3
    else
    if. dl = 0C
        shr W@Envelope+TimerLatch 3 | mov B@Envelope+TimerLatch+Timer+01 al
        shl W@Envelope+TimerLatch 3
    else

    ; Envelope waveform
    if. dl = 0D
        and al 0F
        mov B@Envelope+WaveForm al
        mov B@Envelope+Step 0
    endif

    call @SquareActive @Square1
    call @SquareActive @Square2
    call @SquareActive @Square3
    ret

____________________________________________________________________________________________

@TimerHook:

    add D@Envelope+Timer eax
    add D@Noise+Timer eax
    add D@Square1+Timer eax
    add D@Square2+Timer eax
    add D@Square3+Timer eax
    ret

@SampleHook:

    call @SampleEnvelope
    call @SampleNoise
    call @SampleSquare @Square1 | mov eax D@Square1+Output | shr eax 1 | add edi eax
    call @SampleSquare @Square2 | mov eax D@Square2+Output | shr eax 1 | add edi eax
    call @SampleSquare @Square3 | mov eax D@Square3+Output | shr eax 1 | add edi eax
    ret

____________________________________________________________________________________________

@SquareActive:

    pop eax, ebx | push eax
    mov B$ebx+Active &FALSE
    if B$ebx+Volume > 0,
        if W$ebx+TimerLatch > 0,
            mov B$ebx+Active &TRUE
    ret

@SampleSquare:

    pop eax, ebx | push eax
    on B$ebx+Active = &FALSE, Q0>

    ; Count steps
    mov eax D$ebx+Timer, edx 0
    div D$ebx+TimerLatch
    mov D$ebx+Timer edx

    ; Toggle
    add eax D$ebx+SquareToggle
    mov D$ebx+SquareToggle eax

    if. B$ebx+Flags != 0

        ; Envelope instead of volume?
        if B$ebx+NoVolume = &TRUE,
            copy W@Envelope+Output W$ebx+Volume

        ; Square output
        ifFlag.. B$ebx+Flags 01
            mov al B$ebx+Volume
            ifNotFlag B$ebx+SquareToggle 01, mov al 0
        endif..

        ; Noise output
        ifFlag.. B$ebx+Flags 08
            mov al B$ebx+Volume
            if B@Noise+Output = 0, mov al 0
        endif..

        mov B$ebx+Output al

    endif
Q0: ret
____________________________________________________________________________________________

@SampleEnvelope:

    on W@Envelope+TimerLatch = 0, Q0>

    ; Count steps
    mov eax D@Envelope+Timer, edx 0
    div D@Envelope+TimerLatch
    mov D@Envelope+Timer edx
    mov ecx eax | jecxz Q0>

    ; Step
    mov ebx D@Envelope+WaveForm
L0: call D@WaveForms+ebx*4
    dec ecx | jnz L0<

    ; Update output
    ifFlag B@Envelope+WaveForm 04, not al
    and al 01F
    mov B@Envelope+Output al
Q0: ret

[@WaveForms:
 @Once,  @Once,   @Once,     @Once,
 @Once,  @Once,   @Once,     @Once,
 @Loop,  @Once,   @Triangle, @Hold,
 @Loop,  @Once,   @Triangle, @Hold]

@Once:

    mov al B@Envelope+Step
    if B@Envelope+Step < 01F, inc B@Envelope+Step
    ret

@Loop:

    mov al B@Envelope+Step | inc B@Envelope+Step
    ret

@Triangle:

    mov al B@Envelope+Step | inc B@Envelope+Step
    ifFlag al 020, xor al 01F
    ret

@Hold:

    if. B@Envelope+Step < 020
        mov al B@Envelope+Step
        inc B@Envelope+Step
    else
        mov al 0
    endif
    ret

@SampleNoise:

    on W@Noise+TimerLatch = 0, Q0>

    ; Count steps
    mov eax D@Noise+Timer, edx 0
    div D@Noise+TimerLatch
    mov D@Noise+Timer edx
    mov ecx eax | jecxz Q0>

    mov eax D@Noise+ShiftRegister
L0: ifFlag. eax 01
        ifFlag eax 02, xor B@Noise+Output 01
        xor eax 028000
    endif
    shr eax 1
    dec ecx | jnz L0<
    mov D@Noise+ShiftRegister eax
Q0: ret
____________________________________________________________________________________________
; MMC5 sound
____________________________________________________________________________________________

MMC5Sound:

    ; Channel registers
    CPUWrite 05000, 05000, @5000
    CPUWrite 05002, 05002, @5002
    CPUWrite 05003, 05003, @5003
    CPUWrite 05004, 05004, @5004
    CPUWrite 05006, 05006, @5006
    CPUWrite 05007, 05007, @5007
    CPUWrite 05010, 05010, @5010
    CPUWrite 05011, 05011, @5011
    CPUWrite 05015, 05015, @5015

    ; Reset squares
    mov W@Square1+MaxWavelength MAX_SQUARE_WAVELENGTH
    mov W@Square2+MaxWavelength MAX_SQUARE_WAVELENGTH

    ; APU hooks
    mov D$TimerHook @TimerHook
    mov D$SampleHook @SampleHook
    mov D$FrameCounterHook120Hz @120Hz
    mov D$FrameCounterHook240Hz @240Hz
    ret

[@Square1 ExChannel0
 @Square2 ExChannel1
 @PCM     ExChannel2]

@5000: call WriteSquareReg0 @Square1 | ret
@5002: call WriteSquareReg2 @Square1 | ret
@5003: call WriteSquareReg3 @Square1 | ret
@5004: call WriteSquareReg0 @Square2 | ret
@5006: call WriteSquareReg2 @Square2 | ret
@5007: call WriteSquareReg3 @Square2 | ret
@5010: call APUSynchronize | test al 01 | setnz B@PCM+LengthEnabled | ret  ; Discarded (Shin 4 Nin Uchi Mahjong - Yakuman Tengoku)
@5011: call APUSynchronize | mov B@PCM+Output al | ret
@5015:

    call APUSynchronize
    test al 01 | setnz B@Square1+LengthEnabled
    test al 02 | setnz B@Square2+LengthEnabled
    call SquareActive @Square1
    call SquareActive @Square2
    ret

____________________________________________________________________________________________

@TimerHook:

    add D@Square1+Timer eax
    add D@Square2+Timer eax
    ret

@SampleHook:

    call SampleSquare @Square1 | add edi D@Square1+Output
    call SampleSquare @Square2 | add edi D@Square2+Output
    mov eax D@PCM+Output | shr eax 3 | add edi eax
    ret

@120Hz:

    call ClockSweepUnit @Square1
    call ClockSweepUnit @Square2
    call ClockLengthCounter @Square1
    call ClockLengthCounter @Square2
    ret

@240Hz:

    call ClockEnvelopeDecay @Square1
    call ClockEnvelopeDecay @Square2
    ret

____________________________________________________________________________________________
