TITLE Debug
; Ports
[CPUReadTable:  ? #010000]
[CPUWriteTable: ? #010000]
[PPUReadTable:  ? #04000]
[PPUWriteTable: ? #04000]
[closeMessage
    msgError #1
    call ClearVideo
    call ClearAudio
    call UnloadNES]
;
[ASSERT | NOPE]
[dxErrorCheck | NOPE]
[winErrorCheck | NOPE]
[outWrite  | NOPE]
[outDec    | NOPE]
[outHex    | NOPE]
[outString | NOPE]
[outText   | NOPE]
[outError  | NOPE]
;;
____________________________________________________________________________________________
; Debug macros
____________________________________________________________________________________________

[outWrite  | call DebugOutputWrite]
[outDec    | &1=#1 | { &0: B$ '&1', 0 } | call DebugOutputDec    &0 #1]
[outHex    | &1=#1 | { &0: B$ '&1', 0 } | call DebugOutputHex    &0 #1]
[outString | &1=#1 | { &0: B$ '&1', 0 } | call DebugOutputString &0 #1]
[outText   | &1=#1 | { &0: B$  &1,  0 } | call DebugOutputText   &0 ]
[outError  | call DebugOutputError]

[ASSERT | #=3 | on #1 #2 #3, M0> | M0:]
[winErrorCheck | test eax eax | jnz M0> | outError | outText #1 | M0:]
[dxErrorCheck  | test eax eax | jns M0> | outhex eax | outText #1 |  M0:]
____________________________________________________________________________________________
; Debug window
____________________________________________________________________________________________

[NewLine:         B$ 13, 10,         0
 Equal:              ' = ',          0
 DebugWindowName:    'Debug window', 0
 EditClass:          'edit',         0]
[hDebugWindow: ?]

LoadDebugWindow:

  . D$hDebugWindow = 'User32.FindWindowA' EditClass, DebugWindowName
    if D$hDebugWindow != &NULL, ret
  . D$hDebugWindow = 'User32.CreateWindowExA' &NULL,
                                              EditClass,
                                              DebugWindowName,
                                              &WS_VISIBLE+&WS_OVERLAPPEDWINDOW+&ES_MULTILINE+&ES_LEFT+&ES_AUTOVSCROLL+&WS_VSCROLL+&WS_HSCROLL,
                                              10, 550,
                                              800, 180,
                                              D$hMainWindow,
                                              &NULL,
                                              D$hInstance,
                                              &NULL
    winErrorCheck 'Could not create window.'
    call 'User32.SetWindowTextA' D$hDebugWindow, &NULL
    call 'User32.SetForegroundWindow' D$hMainWindow
    ret
 ____________________________________________________________________________________________

DebugOutputString:

    arguments @pStringName, @pString
    pushad

        call LoadDebugWindow

        ; Output text
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pStringName
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, Equal
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pString
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine

    popad
    return

DebugOutputText:

    arguments @pText
    pushad

        call LoadDebugWindow

        ; Output text
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pText
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine

    popad
    return

DebugOutputWrite:

    pushad

        push eax

            ; Address
            [@Address: B$ '$0000', 0]
            mov edi @Address+4, ecx 4
            std
            L0: mov eax edx
                and eax 0F | mov al B$HexTable+eax
                stosb
                shr edx 4 | dec ecx | jnz L0<
            cld
        
        pop edx
        
        ; Data
        [@Data: B$ '$00', 0]
        mov edi @Data+2, ecx 2
        std
        L0: mov eax edx
            and eax 0F | mov al B$HexTable+eax
            stosb
            shr edx 4 | dec ecx | jnz L0<
        cld

        call LoadDebugWindow

        ; Output text
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, @Address
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, Equal
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, @Data
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine

    popad
    ret

[HexTable: '0123456789ABCDEF']
DebugOutputHex:

    arguments @pHexName, @Number
    pushad

        call LoadDebugWindow

        ; Convert to hex
        [@HexString: B$ '$00000000', 0]
        mov edx D@Number, edi @HexString, ecx 8
        ifNotFlag edx 0FFFF0000, mov ecx 4
        ifNotFlag edx 0FFFFFF00, mov ecx 2
        add edi ecx
        mov B$edi+1 0
        std
        L0: mov eax edx
            and eax 0F | mov al B$HexTable+eax
            stosb
            shr edx 4 | dec ecx | jnz L0<
        cld

        ; Output text
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pHexName
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, Equal
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, @HexString
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine

    popad
    return

DebugOutputDec:

    arguments @pDecName, @Number
    pushad

        call LoadDebugWindow

        ; Convert to decimal
        [@DecString: B$ '0000000000000', 0]
        mov eax D@Number, edi @DecString
        mov dl 0FF | push edx
        mov ecx 10
    L0: mov edx 0 | div ecx
        push edx | on eax > 0, L0<
    L0: pop eax
        if. al != 0FF
            add al '0'
            stosb
            jmp L0<
        endif
        mov B$edi 0

        ; Output text
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pDecName
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, Equal
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, @DecString
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine

    popad
    return

DebugOutputError:

    pushad

        [@pMessage: ?]
        call 'Kernel32.GetLastError'
        call 'Kernel32.FormatMessageA' &FORMAT_MESSAGE_ALLOCATE_BUFFER+&FORMAT_MESSAGE_FROM_SYSTEM,
                                       &NULL,
                                       eax,
                                       &NULL,
                                       @pMessage,
                                       &NULL,
                                       &NULL
        call LoadDebugWindow

        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, D@pMessage
        call 'USER32.SendMessageA' D$hDebugWindow &EM_SCROLLCARET 0, 0
        call 'USER32.SendMessageA' D$hDebugWindow &EM_REPLACESEL &FALSE, NewLine
        call 'Kernel32.LocalFree' D$@pMessage

    popad
    ret
____________________________________________________________________________________________
; Emulation debugging
____________________________________________________________________________________________

DrawNameTable:

    mov esi NameTable, edi VideoBuffer
    mov edx 28
L1: pushad | mov ecx 32 | L0: lodsb | stosb | stosb | stosb | stosb | loop L0< | popad | add edi 0100 | add esi 32
    pushad | mov ecx 32 | L0: lodsb | stosb | stosb | stosb | stosb | loop L0< | popad | add edi 0100 | add esi 32
    pushad | mov ecx 32 | L0: lodsb | stosb | stosb | stosb | stosb | loop L0< | popad | add edi 0100 | add esi 32
    pushad | mov ecx 32 | L0: lodsb | stosb | stosb | stosb | stosb | loop L0< | popad | add edi 0100 | add esi 32
    dec edx | jnz L1<
    ret

[Emulate:
 @SoundSquare1:  &TRUE
 @SoundSquare2:  &TRUE
 @SoundTriangle: &TRUE
 @SoundNoise:    &TRUE
 @SoundDMC:      &TRUE
 @Background:    &TRUE
 @Sprites:       &TRUE
 @SpriteZero:    &FALSE]
;;
____________________________________________________________________________________________
