TITLE Config

; Config file handling and the preferences dialog.

____________________________________________________________________________________________
; Config files
____________________________________________________________________________________________

SaveConfiguration:

    call SaveNessieFile ConfigFilename
    ret

LoadConfiguration:

    ; Load internal config
    push D$pFile
    push D$FileSize

        call 'Kernel32.FindResourceA'  D$hInstance, IDR_CONFIG, &RT_RCDATA
        call 'Kernel32.SizeofResource' D$hInstance, eax
        mov D$FileSize eax
        copy D$pConfig D$pFile | call LoadCFG

    pop D$Filesize
    pop D$pFile

    ; Load external config
    call LoadFirstFile NessieDirectory, ConfigFilename
    if D$pImage != &NULL, call LoadFirstFile ROMDirectory, ConfigFilename
    ret

SaveCFG: call SaveChunks FILE_ID_CFG, CFGSaveTable | ret
LoadCFG: call LoadChunks FILE_ID_CFG, CFGLoadTable | ret
____________________________________________________________________________________________
; Chunk saving/loading
; They all use ChunkData and ChunkSize
____________________________________________________________________________________________

SaveConfigMRUList:

    ; Length?
    mov edi MRUList, ecx 0-1, al 0, edx D$nMRUItems
L0: if. edx > 0
        if B$edi = 0, break
        repne scasb
        dec edx | jnz L0<
    endif
    sub edi MRUList

    ; Set data
    call CopyMemory MRUList, ChunkData, edi
    add edi 4 | mov D$ChunkSize edi
    ret

LoadConfigMRUList:

    call ZeroMemory MRUList, LENGTH_MRULIST
    mov ecx D$ChunkSize | sub ecx 4
    if ecx > LENGTH_MRULIST, mov ecx LENGTH_MRULIST
    call CopyMemory ChunkData, MRUList, ecx

    call UpdateMRUList
    ret

____________________________________________________________________________________________

SaveConfigVersion:

    ; Version 0: TechNES 1.00
    ; - Saves/loads 010 preferences bytes, eventhough only 4 are used
    ; - Saves/loads 040 input settings bytes, eventhough only 4 are used
    [NESSIE_VERSION 1]
    [ConfigVersion: ?]
    mov D$ChunkSize 8
    mov D$ChunkData NESSIE_VERSION
    ret

LoadConfigVersion:

    copy D$ChunkData D$ConfigVersion
    ret
____________________________________________________________________________________________

SaveConfigPreferences:

    mov D$ChunkSize LENGTH_PREFERENCES+4
    call CopyMemory Preferences, ChunkData, LENGTH_PREFERENCES
    ret

LoadConfigPreferences:

    mov ecx D$ChunkSize | sub ecx 4
    if ecx > LENGTH_PREFERENCES, mov ecx LENGTH_PREFERENCES
if D$ConfigVersion = 0, mov ecx 4
    call CopyMemory ChunkData, Preferences, ecx
    ret
____________________________________________________________________________________________

SaveConfigInputSettings:

    mov D$ChunkSize LENGTH_INPUTSETTINGS+4
    call CopyMemory InputSettings, ChunkData, LENGTH_INPUTSETTINGS
    ret

LoadConfigInputSettings:

    mov ecx D$ChunkSize | sub ecx 4
    if ecx > LENGTH_INPUTSETTINGS, mov ecx LENGTH_INPUTSETTINGS
if D$ConfigVersion = 0, mov ecx 4
    call CopyMemory ChunkData, InputSettings, ecx

    call UpdateCursor
    ret
____________________________________________________________________________________________

; Button assigments are saved in chunks:
; 00-15: D$ #4 - instance GUID (sys keyboard, joystick 1, etc...)
; 16-??: W$ #2 - A bunch of WORD pairs:
;                W$ Offset in InputStatus array
;                W$ Offset in DeviceState array
; ??:    D$ #1  - A null-DWORD terminating the WORD pairs

SaveConfigButtonAssignments:

    mov edx ChunkData
    mov ebx 0
L0: if. ebx < D$nDevices

        ; Save GUID
        mov eax ebx | shl eax 4 | add eax GUID
        call CopyMemory eax, edx, 010 | add edx 010

        ; Save mappings
        mov edi D$pMappings+ebx*4, eax 0, ecx 0-1 | repne scasd
        not ecx | shl ecx 2
        call CopyMemory D$pMappings+ebx*4, edx, ecx | add edx ecx

        inc ebx | jmp L0<

    endif

    ; Save size
    sub edx Chunk | mov D$ChunkSize edx
    ret

LoadConfigButtonAssignments:

    ; Set start/end
    [@pEnd: ?]
    mov eax D$ChunkSize | add eax Chunk | mov D@pEnd eax
    mov esi ChunkData

L0: if. esi < D@pEnd

        mov ebx 0
    L1: if.. ebx < D$nDevices

            ; Compare GUID
            push esi
                move edi ebx | shl edi 4 | add edi GUID
                mov ecx 010
                repe cmpsb
            pop esi
            jecxz F0>

            ; Check GUID of next device
        S0: inc ebx | jmp L1<<

            ; Load mappings
        F0: add esi 010
            mov edi D$pMappings+ebx*4
        L2: movsd | on D$edi-4 != 0, L2<
            jmp L0<

        endif..

        ; GUID not found, skip
        add esi 010
    L2: lodsd | on eax != 0, L2<
        jmp L0<<

    endif
    ret
____________________________________________________________________________________________
; Preferences dialog
____________________________________________________________________________________________

PreferencesDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam
    pushad

        ; Message?
        mov eax &TRUE
        if. D@Message = &WM_CLOSE      | call @Close      | else
        if. D@Message = &WM_COMMAND    | call @Command    | else
        if. D@Message = &WM_INITDIALOG | call @InitDialog | else | mov eax &FALSE   | endif

        mov D$esp+28 eax

    popad
    return

@InitDialog:

    ; Checkboxes
    movzx eax B$Preferences@UseDatabase  | call 'User32.CheckDlgButton' D@hDialog, IDC_CHECKBOX+0, eax
    movzx eax B$Preferences@AutoPowerOn  | call 'User32.CheckDlgButton' D@hDialog, IDC_CHECKBOX+1, eax
    movzx eax B$Preferences@AutoHideMenu | call 'User32.CheckDlgButton' D@hDialog, IDC_CHECKBOX+2, eax

    ; Radio buttons
    if. B$Preferences@PreferNTSC = &TRUE
        mov eax IDC_RADIOBUTTON+0
    else
        mov eax IDC_RADIOBUTTON+1
    endif
    call 'User32.CheckRadioButton' D@hDialog, IDC_RADIOBUTTON+0, IDC_RADIOBUTTON+1, eax

    mov eax &TRUE
    ret

@Command:

    ; Escape pressed
    on W@wParam = &IDCANCEL, @Close

    ; Which button?
    mov W@wParam+2 0
    on W@wParam = IDC_OK,            @SaveAndExit
    on W@wParam = IDC_CANCEL,        @Close
    on W@wParam = IDC_CHECKBOX+0,    @CheckBox
    on W@wParam = IDC_CHECKBOX+1,    @CheckBox
    on W@wParam = IDC_CHECKBOX+2,    @CheckBox
    ret

@Close:

    call 'User32.EndDialog' D@hDialog, 1
    ret
____________________________________________________________________________________________

@CheckBox:

    call 'User32.IsDlgButtonChecked' D@hDialog, D@wParam | xor eax &BST_CHECKED
    call 'User32.CheckDlgButton' D@hDialog, D@wParam, eax
    ret

@SaveAndExit:

    ; Save new settings
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_CHECKBOX+0    | mov B$Preferences@UseDatabase  al
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_CHECKBOX+1    | mov B$Preferences@AutoPowerOn  al
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_CHECKBOX+2    | mov B$Preferences@AutoHideMenu al
    call 'User32.IsDlgButtonChecked' D@hDialog, IDC_RADIOBUTTON+0 | mov B$Preferences@PreferNTSC   al
    call SaveConfiguration
    call @Close
    ret
____________________________________________________________________________________________
; Preferences
____________________________________________________________________________________________

[LENGTH_PREFERENCES 4]
[Preferences:

 @UseDatabase:    B$ ?
 @AutoPowerOn:    B$ ?
 @AutoHideMenu:   B$ ?
 @PreferNTSC:     B$ ?]
____________________________________________________________________________________________
