TITLE Audio

____________________________________________________________________________________________
; Init/shutdown
____________________________________________________________________________________________

AudioInit:

    ; IDirectSound interface
    call 'DSound.DirectSoundCreate' &NULL, lpds, &NULL
    dxErrorCheck 'Could not create DirectSound interface.'
    if D$lpds = &NULL, ret

    ; Set cooperative level
    dxCall lpds,dsSetCooperativeLevel D$hMainWindow, &DSSCL_NORMAL
    dxErrorCheck 'Could not set cooperative level.'

    ; Create a secondary sound buffer
    dxCall lpds,CreateSoundBuffer dsbd, lpdsb, &NULL
    dxErrorCheck 'Could not create sound buffer.'
    if D$lpdsb = &NULL, ret

    ; Start playing buffer
    call PlayAudio
    ret

AudioShutdown:

    ; Release interfaces
    dxRelease lpdsb | dxErrorCheck 'Could not release DirectSound buffer.'
    dxRelease lpds  | dxErrorCheck 'Could not release DirectSound interface.'
    ret

____________________________________________________________________________________________
; Sound output
____________________________________________________________________________________________

AudioOutput: ; 8-bit sample in al

    ; Write byte to buffer
    mov edx D$AudioCursor
    inc D$AudioCursor
    mov B$edx+AudioBuffer al

    ; Buffer full?
    on D$AudioCursor >= SOUND_BUFFER_LENGTH, FlushAudio
    ret

FlushAudio:

    ; Reset cursor
    mov D$AudioCursor 0
    if B$AudioActive = &FALSE, ret
    if D$lpdsb =  &NULL, ret

    ; Position of the block to write -> WriteCursor
    inc D$nDSBuffer | and D$nDSBuffer 07
    mov ecx D$nDSBuffer
    mov eax SOUND_BUFFER_LENGTH
    mul ecx
    mov D$WriteCursor eax

    ; Wait for block to finish playing
L0: dxCall lpdsb,GetCurrentPosition Temp, &NULL
    dxErrorCheck 'Could not retrieve sound position.'
    mov eax D$Temp, edx 0, ecx SOUND_BUFFER_LENGTH
    div ecx
    if. eax = D$nDSBuffer
        ; Give CPU time to other applications
;        call 'Kernel32.SwitchToThread'
        call 'Kernel32.Sleep' 0
        jmp L0<
;;
        on eax > 0, L0<
        ; Give CPU time to message loop
        call CheckMessageQueue
        on eax = 0, L0<
        call 'User32.PostQuitMessage' 0 | jmp L0<
;;
    endif

    ; Lock output buffer
    dxCall lpdsb,dsbLock D$WriteCursor, SOUND_BUFFER_LENGTH, pAudio1, lAudio1, pAudio2, lAudio2, 0
    dxErrorCheck 'Sound buffer lock failed.'

    ; Write block #1
    mov esi AudioBuffer
    mov edi D$pAudio1
    mov ecx D$lAudio1
    rep movsb

    ; Write block #2 (most probably not necessary, or something's wrong...)
    if. D$lAudio2 != 0
        mov edi D$pAudio2
        mov ecx D$lAudio2
        rep movsb
    endif

    ; Unlock output buffer
    dxCall lpdsb,dsbUnlock D$pAudio1, D$lAudio1, D$pAudio2, D$lAudio2
    dxErrorCheck 'Could not unlock sound buffer.'
    ret

PlayAudio:

    if B$AudioActive = &TRUE, ret
    if D$lpdsb = &NULL, ret

    ; Start playing buffer
    mov D$AudioActive &TRUE
    dxCall lpdsb,Play 0, 0, &DSBPLAY_LOOPING
    dxErrorCheck 'Could not play audio.'
    ret

StopAudio:

    if B$AudioActive = &FALSE, ret
    if D$lpdsb = &NULL, ret

    ; Stop playing buffer
    call ClearAudio
    mov D$AudioActive &FALSE
    dxCall lpdsb,Stop
    dxErrorCheck 'Could not stop playing audio.'
    ret

ClearAudio:

    if D$lpdsb = &NULL, ret

    ; Lock output buffer
    dxCall lpdsb,dsbLock 0, DSB_LENGTH, pAudio1, lAudio1, pAudio2, lAudio2, &DSBLOCK_ENTIREBUFFER
    dxErrorCheck 'Sound buffer lock failed on ClearAudio.'

    ; Clear it
    mov edi D$pAudio1
    if. edi != &NULL
        mov al B$edi
        mov ecx DSB_LENGTH
        rep stosb
    endif

    ; Unlock
    dxCall lpdsb,dsbUnlock D$pAudio1, D$lAudio1, D$pAudio2, D$lAudio2
    dxErrorCheck 'Could not unlock sound buffer.'
    ret

____________________________________________________________________________________________
; Data
____________________________________________________________________________________________

; Interface pointers
[lpds:  ?
 lpdsb: ?]

; Input buffer
[AudioBuffer:   ? #SOUND_BUFFER_LENGTH
 AudioCursor:   ?]

; Output buffer
[AudioActive:   ?
 nDSBuffer:     ?
 WriteCursor:   ?
 pAudio1:       ?
 lAudio1:       ?
 pAudio2:       ?
 lAudio2:       ?]

; Equates
[SAMPLE_RATE          44100
 SOUND_BUFFER_LENGTH  734]

; WaveFormatEx
[WAVEFORMATEX:
 @wFormatTag:        W$ &WAVE_FORMAT_PCM
 @nChannels:         W$ 1
 @nSamplesPerSec:    D$ SAMPLE_RATE
 @nAvgBytesPerSec:   D$ SAMPLE_RATE
 @nBlockAlign:       W$ 1
 @nBitsPerSample:    W$ 8
 @cbSize:            W$ 0]

; DirectSoundBuffer description
[DSB_LENGTH <(SOUND_BUFFER_LENGTH shl 3)>]
[dsbd:
 @dwSize:         len
 @dwFlags:        &DSBCAPS_GETCURRENTPOSITION2
 @dwBufferBytes:  DSB_LENGTH
 @dwReserved:     0
 @lpwfxFormat:    WAVEFORMATEX]

____________________________________________________________________________________________
; DirectSound vtables
____________________________________________________________________________________________

; IDirectSound
[CreateSoundBuffer      12
 dsGetCaps              16
 DuplicateSoundBuffer   20
 dsSetCooperativeLevel  24
 dsCompact              28
 GetSpeakerConfig       32
 SetSpeakerConfig       36
 dsInitialize           40

; IDirectSoundBuffer
 dsbGetCaps             12
 GetCurrentPosition     16
 GetFormat              20
 GetVolume              24
 GetPan                 28
 GetFrequency           32
 GetStatus              36
 dsbInitialize          40
 dsbLock                44
 Play                   48
 SetCurrentPosition     52
 SetFormat              56
 SetVolume              60
 SetPan                 64
 SetFrequency           68
 Stop                   72
 dsbUnlock              76
 dsbRestore             80]

____________________________________________________________________________________________
