#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <dzcomm.h>

void main(int argc,char* argv[])
{
        dzcomm_init();

        comm_port* COM;
        char* ROM;        
        int Offset = 0;
        int Size;
        int LastOff = 0;
        int LastTime = 0;
        int fh;

        clrscr();
        gotoxy(1,1);
        printf("\nROM dumper v2.2");
        printf("\nby Randy Gluvna");
        printf("\nrandman@home.com");
        printf("\n----------------\n\n");    

        if(argc != 4)
        {
                printf("Syntax: romdump [filename] [size] [COM port]\n");
                return;
        }

        Size = atoi(argv[2]);

        if((ROM = malloc(Size)) == NULL)
        {
                printf("Out of memory!\a\n");
                return;
        }

        COM = comm_port_init(atoi(argv[3])-1);        

        COM->nComm = atoi(argv[3])-1;
        COM->nBaud = _9600;
        COM->control_type = NO_CONTROL;

        if(!comm_port_install_handler(COM))
        {
                printf("Error opening COM port!\a\n");
                return;
        }

        gotoxy(1,7);
        printf("Saving to %s\n",argv[1]);
        gotoxy(1,8);
        printf("File size: %d\n",Size);
        gotoxy(1,10);
        printf("Bytes received: 0\n");
        gotoxy(1,11);
        printf("Percent: 0%%\n");
        gotoxy(1,12);
        printf("CPS: 0\n");

        while(1)
        {
                if(kbhit())
                {
                        if(getch() == 27)
                        {
                                gotoxy(1,13);                         
                                return;
                        }
                }

                if(LastTime != (clock()/CLK_TCK))
                {
                        LastTime = (clock()/CLK_TCK);

                        if((Offset == 1) && (LastOff == 0))
                                Offset = 0;

                        gotoxy(6,12);
                        printf("%d   \n",Offset-LastOff);
                        LastOff = Offset;
                }

                if(!queue_empty(COM->InBuf))
                {
                        ROM[Offset++] = (char)queue_get(COM->InBuf);

                        if(!(Offset % 1024))
                        {
                                gotoxy(17,10);
                                printf("%d\n",Offset);
                                gotoxy(10,11);
                                printf("%d%%\n",(int)(double(Offset)/Size*100));
                        }

                        if(Offset == Size)
                        {
                                gotoxy(17,10);
                                printf("%d\n",Size);
                                gotoxy(10,11);
                                printf("100%%\n");
                                fh = open(argv[1],O_WRONLY|O_BINARY|O_CREAT,S_IWRITE);
                                write(fh,ROM,Size);
                                close(fh);
                                gotoxy(1,14);
                                printf("Done\n");
                                return;
                        }                        
                }
        }      
}
