#DEFINE equ 							=
#DEFINE EQU 							=
#DEFINE 0FCH							0FCh
#DEFINE 0D4H							0D4h
#DEFINE 0E8H    						0E8h
#DEFINE 0C0H							0C0h
.include "ti86asm.inc"
PORT = 7
.org _asm_exec_ram
            
        call _runindicoff
        call _clrLCD
        ld hl,$0000
        ld (_curRow),hl
        ld hl,_str_TITLE
        set 3,(iy+5)
        call _puts
        res 3,(iy+5)
        ld hl,$0003
        ld (_curRow),hl
        ld hl,_str_ENTER
        call _puts     
key_loop:
        call _getkey
        cp kExit
        jr z,quit
        cp kEnter
        jr z,start_dump
        jr key_loop
start_dump:
        ld hl,$0003
        ld (_curRow),hl
        ld hl,_str_SENDING
        call _puts
        call _runindicon
        xor a
        out (5),a
        ld hl,$4000
dump_loop:
        ld a,%10111101
        out (1),a
        in a,(1)
        cp %10111111
        jr z,quit
        ld a,(hl)
        call SEND_BYTE
        inc hl
        ld bc,$8000
        push hl
        or a
        sbc hl,bc
        pop hl
        jr nz,dump_loop
        in a,(5)
        cp 15
        jr z,quit
        inc a
        out (5),a
        ld hl,$4000
        jr dump_loop
quit:
        ld a,$0D
        out (5),a
        ld a,$C0
        out (7),a
        call _runindicoff
        ld hl,$0000
        ld (_curRow),hl
        jp _clrLCD

SEND_BYTE:
        LD      C,A             
        LD      B,008H          
S0:
        LD      DE,0FFFFH       
        RR      C               
        JR      NC,S1           
        LD      A,0E8H          
        JR      S2              
S1:
        LD      A,0D4H          
S2:
        OUT     (PORT),A        
S3:
        IN      A,(PORT)        
        AND     003H            
        JR      Z,S4            
        IN      A,(PORT)        
        AND     003H            
        JR      Z,S4            
        DEC     DE              
        LD      A,D             
        OR      E               
        JR      NZ,S3           
        RET                     
S4:
        LD      A,0C0H          
        OUT     (PORT),A        
        LD      DE,0FFFFH       
S5:
        DEC     DE              
        LD      A,D             
        OR      E               
        RET     Z               
        IN      A,(PORT)        
        AND     003H            
        CP      003H            
        JR      NZ,S5           
        DJNZ    S0              
        RET                     

_str_TITLE:
        .db "   ROM dumper v2.1   "
        .db "   by Randy Gluvna   ",0
_str_ENTER:
        .db "Press Enter to start",0
_str_SENDING:
        .db "Sending...          ",0

.end

