.include "ti-85.h"
PORT = 7
.org 0
.db "ROM dumper v2.1",0
          
        ROM_CALL(CLEARLCD)
        ld hl,$0000
        ld (CURSOR_ROW),hl
        ld hl,_str_TITLE
        ld de,(PROGRAM_ADDR)
        add hl,de
        set 3,(iy+5)
        ROM_CALL(D_ZT_STR)
        res 3,(iy+5)
        ld hl,$0003
        ld (CURSOR_ROW),hl
        ld hl,_str_ENTER
        ld de,(PROGRAM_ADDR)
        add hl,de
        ROM_CALL(D_ZT_STR)     
        CALL_(scan_keys)
key_loop:
        ld a,%10111101
        out (1),a
        in a,(1)
        cp %10111111
        jr z,quit
        cp %11111110
        jr z,start_dump
        jr key_loop
start_dump:   
        ld hl,$0003
        ld (CURSOR_ROW),hl
        ld hl,_str_SENDING
        ld de,(PROGRAM_ADDR)
        add hl,de
        ROM_CALL(D_ZT_STR)
        ROM_CALL(BUSY_ON)
        xor a
        out (5),a
        ld hl,$4000
dump_loop:
        ld a,%10111101
        out (1),a
        in a,(1)
        cp %10111111     
        jr z,quit
        ld a,(hl)
        CALL_(SEND_BYTE)
        inc hl
        ld bc,$8000
        push hl
        or a
        sbc hl,bc
        pop hl
        jr nz,dump_loop
        in a,(5)
        cp 7
        jr z,quit
        inc a
        out (5),a
        ld hl,$4000
        jr dump_loop
quit:        
        ld a,4
        out (5),a
        ld a,$C0
        out (7),a
        ROM_CALL(BUSY_OFF)

scan_keys:
        di
scan_loop:
        xor a
        out (1),a
        in a,(1)
        cp $FF
        jr nz,scan_loop
        ei
        ret

SEND_BYTE:
        LD      C,A             
        LD      B,008H          
S0:
        LD      DE,0FFFFH       
        RR      C               
        JR      NC,S1           
        LD      A,0E8H          
        JR      S2              
S1:
        LD      A,0D4H          
S2:
        OUT     (PORT),A        
S3:
        IN      A,(PORT)        
        AND     003H            
        JR      Z,S4            
        IN      A,(PORT)        
        AND     003H            
        JR      Z,S4            
        DEC     DE              
        LD      A,D             
        OR      E               
        JR      NZ,S3           
        RET                     
S4:
        LD      A,0C0H          
        OUT     (PORT),A        
        LD      DE,0FFFFH       
S5:
        DEC     DE              
        LD      A,D             
        OR      E               
        RET     Z               
        IN      A,(PORT)        
        AND     003H            
        CP      003H            
        JR      NZ,S5           
        DJNZ    S0              
        RET                     

_str_TITLE:
        .db "   ROM dumper v2.1   "
        .db "   by Randy Gluvna   ",0
_str_ENTER:
        .db "Press Enter to start",0
_str_SENDING:
        .db "Sending...          ",0

.end

