/**
 * This file is a part of JaC64 - a Java C64 Emulator
 * Main Developer: Joakim Eriksson (Dreamfabric.com)
 * Contact: joakime@sics.se
 * Web: http://www.dreamfabric.com/c64
 * ---------------------------------------------------
 */

package com.dreamfabric.jac64;

/**
 * Waveform lookup tables borrowed from the Re-Sid SID emulator
 *
 *
 * Created: Fri Aug 26 22:42:51 2005
 *
 */
public class RS6581Waves {

  // Compressed versions of the resid sampled waves (6581)

  private static int wave6581_PS_src[] = new int[] {
    0xff00, 0x7, 0x7f00, 0x3, 0x3f00, 0x3, 0x3e00, 0x2, 0x1f, 0x7f00, 0x3,
    0x3f00, 0x1, 0x3f00, 0x2f, 0x7f00, 0x37, 0x3f00, 0x3b, 0x1f00, 0x3d,
    0xf00, 0x3e, 0x600, 0x30, 0x3f, 0x100, 0x30, 0x38, 0x3f, 0x3e,
    0x3f, 0x3f, 0x3f, 0x7f00, 0x3, 0x7f00, 0x4f, 0x7f00, 0x57, 0x3f00, 0x5b,
    0x1f00, 0x5d, 0xf00, 0x5e, 0x600, 0x40, 0x5f, 0x100, 0x40, 0x40,
    0x5f, 0x5c, 0x5f, 0x5f, 0x5f, 0x7f00, 0x67, 0x3e00, 0x40, 0x6b,
    0x1d00, 0x40, 0x40, 0x6d, 0x700, 0x40, 0x300, 0x40, 0x100, 0x40,
    0x40, 0x6e, 0x300, 0x40, 0x100, 0x60, 0x60, 0x6f, 0x100, 0x60,
    0x60, 0x6f, 0x60, 0x6f, 0x6f, 0x6f, 0x1f00, 0x40, 0xf00, 0x40,
    0x700, 0x40, 0x300, 0x40, 0x100, 0x40, 0x60, 0x73, 0xf00, 0x40,
    0x700, 0x40, 0x300, 0x40, 0x100, 0x60, 0x60, 0x75, 0x700, 0x60,
    0x300, 0x60, 0x100, 0x60, 0x60, 0x76, 0x300, 0x60, 0x100, 0x60,
    0x60, 0x77, 0x100, 0x70, 0x70, 0x77, 0x70, 0x77, 0x77, 0x77,
    0xf00, 0x60, 0x700, 0x60, 0x300, 0x60, 0x100, 0x60, 0x60, 0x79,
    0x700, 0x60, 0x300, 0x60, 0x100, 0x70, 0x70, 0x7a, 0x300, 0x70,
    0x100, 0x70, 0x70, 0x7b, 0x40, 0x70, 0x70, 0x7b, 0x78, 0x7b,
    0x7b, 0x7b, 0x700, 0x70, 0x300, 0x70, 0x100, 0x70, 0x70, 0x7c,
    0x300, 0x70, 0x40, 0x70, 0x70, 0x7d, 0x40, 0x70, 0x78, 0x7d,
    0x78, 0x7d, 0x7d, 0x7d, 0x100, 0x40, 0x40, 0x78, 0x60, 0x78,
    0x78, 0x7e, 0x60, 0x78, 0x78, 0x7e, 0x7c, 0x7e, 0x7e, 0x7e,
    0x70, 0x7c, 0x7c, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff00, 0x7, 0x7f00, 0x3,
    0x3f00, 0x3, 0x3e00, 0x2, 0x1f, 0x7f00, 0x3, 0x3f00, 0x1, 0x3f00, 0x2f,
    0x7f00, 0x37, 0x3f00, 0x3b, 0x1f00, 0x3d, 0xf00, 0x3e, 0x600, 0x30,
    0x3f, 0x100, 0x30, 0x38, 0x3f, 0x3e, 0x3f, 0x3f, 0x3f, 0x7f00, 0x3,
    0x7f00, 0x4f, 0x7f00, 0x57, 0x3f00, 0x5b, 0x1f00, 0x5d, 0xf00, 0x5e,
    0x600, 0x40, 0x5f, 0x100, 0x40, 0x40, 0x5f, 0x5c, 0x5f, 0x5f,
    0x5f, 0x7f00, 0x67, 0x3e00, 0x40, 0x6b, 0x1e00, 0x40, 0x6d, 0x700, 0x40,
    0x300, 0x40, 0x100, 0x40, 0x40, 0x6e, 0x300, 0x40, 0x100, 0x60,
    0x60, 0x6f, 0x100, 0x60, 0x60, 0x6f, 0x60, 0x6f, 0x6f, 0x6f,
    0x1f00, 0x40, 0xf00, 0x40, 0x700, 0x40, 0x300, 0x40, 0x100, 0x40,
    0x60, 0x73, 0xf00, 0x40, 0x700, 0x40, 0x300, 0x40, 0x100, 0x60,
    0x60, 0x75, 0x700, 0x60, 0x300, 0x60, 0x100, 0x60, 0x60, 0x76,
    0x300, 0x60, 0x100, 0x60, 0x60, 0x77, 0x100, 0x70, 0x70, 0x77,
    0x70, 0x77, 0x77, 0x77, 0xf00, 0x60, 0x700, 0x60, 0x300, 0x60,
    0x100, 0x60, 0x60, 0x79, 0x700, 0x60, 0x300, 0x60, 0x100, 0x70,
    0x70, 0x7a, 0x300, 0x70, 0x100, 0x70, 0x70, 0x7b, 0x40, 0x70,
    0x70, 0x7b, 0x78, 0x7b, 0x7b, 0x7b, 0x700, 0x70, 0x300, 0x70,
    0x100, 0x70, 0x70, 0x7c, 0x300, 0x70, 0x40, 0x70, 0x70, 0x7d,
    0x40, 0x70, 0x78, 0x7d, 0x78, 0x7d, 0x7d, 0x7d, 0x100, 0x40,
    0x40, 0x78, 0x60, 0x78, 0x78, 0x7e, 0x60, 0x78, 0x78, 0x7e,
    0x7c, 0x7e, 0x7e, 0x7e, 0x70, 0x7c, 0x7c, 0x7f, 0x7c, 0x7f,
    0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f
  };

  private static int wave6581_P_Tsrc[] = new int[] {
    0x1fd00, 0x20, 0x38, 0x3f, 0xfb00, 0x40, 0x100, 0x40, 0x40, 0x5f,0x6f00,0x40,
    0x700, 0x40, 0x300, 0x60, 0x100, 0x60, 0x60, 0x6f, 0x1f00, 0x40,
    0xf00, 0x60, 0x700, 0x60, 0x300, 0x60, 0x100, 0x60, 0x70, 0x77,
    0xf00, 0x60, 0x700, 0x60, 0x300, 0x70, 0x40, 0x70, 0x70, 0x7b,
    0x600, 0x40, 0x70, 0x100, 0x40, 0x40, 0x70, 0x60, 0x70, 0x78,
    0x7d, 0x100, 0x40, 0x60, 0x78, 0x60, 0x78, 0x78, 0x7e, 0x70,
    0x7c, 0x7c, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f00, 0x80, 0x3f00, 0x80,
    0x1f00, 0x80, 0xf00, 0x80, 0x700, 0x80, 0x300, 0x80, 0x80, 0x80,
    0x80, 0x9f, 0x3f00, 0x80, 0x1f00, 0x80, 0xf00, 0x80, 0x700, 0x80,
    0x100, 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0, 0xaf, 0x1f00, 0x80,
    0xd00, 0x80, 0x80, 0x80, 0x300, 0x80, 0x100, 0x80, 0x80, 0xa0,
    0x100, 0x80, 0x80, 0xa0, 0x80, 0xa0, 0xb0, 0xb7, 0x700, 0x80,
    0x300, 0x80, 0x100, 0x80, 0x80, 0xa0, 0x300, 0x80, 0x100, 0x80,
    0x80, 0xa0, 0x100, 0x80, 0x80, 0xa0, 0x80, 0xb0, 0xb0, 0xbb,
    0x300, 0x80, 0x80, 0x80, 0x80, 0xb0, 0x80, 0x80, 0x80, 0xb0,
    0x80, 0xb0, 0xb8, 0xbd, 0x80, 0x80, 0x80, 0xb8, 0xa0, 0xb8,
    0xb8, 0xbe, 0xa0, 0xb8, 0xbc, 0xbf, 0xbe, 0xbf, 0xbf, 0xbf,
    0x3f00, 0xc0, 0x1d00, 0x80, 0x80, 0xc0, 0xb00, 0x80, 0x100, 0x80,
    0x80, 0xc0, 0x300, 0x80, 0x100, 0x80, 0x80, 0xc0, 0x100, 0x80,
    0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xcf, 0xf00, 0x80, 0x700, 0x80,
    0x300, 0x80, 0x100, 0x80, 0x80, 0xc0, 0x700, 0x80, 0x300, 0x80,
    0x100, 0x80, 0x80, 0xc0, 0x300, 0x80, 0x100, 0x80, 0xc0, 0xc0,
    0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0, 0xd7, 0x700, 0x80,
    0x300, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0x100, 0x80, 0x80, 0xc0,
    0x80, 0xc0, 0xc0, 0xc0, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0,
    0xd0, 0xdb, 0x100, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0xd0,
    0x80, 0xc0, 0xc0, 0xd0, 0xc0, 0xd0, 0xd8, 0xdd, 0xc0, 0xc0,
    0xc0, 0xd0, 0xc0, 0xd8, 0xd8, 0xde, 0xc0, 0xd8, 0xdc, 0xdf,
    0xdc, 0xdf, 0xdf, 0xdf, 0xf00, 0x80, 0x700, 0x80, 0x300, 0x80,
    0x80, 0xc0, 0xc0, 0xe0, 0x700, 0x80, 0x100, 0x80, 0x80, 0xc0,
    0x80, 0xc0, 0xc0, 0xe0, 0x100, 0x80, 0x80, 0xc0, 0x80, 0xc0,
    0xc0, 0xe0, 0x80, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe7,
    0x300, 0x80, 0x100, 0x80, 0x80, 0xc0, 0x100, 0x80, 0x80, 0xc0,
    0x80, 0xc0, 0xc0, 0xe0, 0x100, 0x80, 0x80, 0xc0, 0x80, 0xc0,
    0xc0, 0xe0, 0xc0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xeb,
    0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xed, 0xc0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe8, 0xe8, 0xee, 0xe0, 0xe8, 0xec, 0xef, 0xec, 0xef,
    0xef, 0xef, 0x300, 0x80, 0x80, 0x80, 0x80, 0xc0, 0x80, 0x80,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xf0, 0x80, 0xc0, 0xc0, 0xc0,
    0xc0, 0xe0, 0xe0, 0xf0, 0xc0, 0xe0, 0xe0, 0xf0, 0xe0, 0xf0,
    0xf0, 0xf3, 0x80, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xf0,
    0xc0, 0xe0, 0xe0, 0xf0, 0xe0, 0xf0, 0xf0, 0xf5, 0xe0, 0xe0,
    0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf6, 0xf0, 0xf0, 0xf4, 0xf7,
    0xf4, 0xf7, 0xf7, 0xf7, 0xc0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xf8, 0xf0, 0xf8, 0xf8, 0xf9,
    0xe0, 0xf0, 0xf0, 0xf8, 0xf0, 0xf8, 0xf8, 0xfa, 0xf0, 0xf8,
    0xf8, 0xfb, 0xf8, 0xfb, 0xfb, 0xfb, 0xe0, 0xf0, 0xf0, 0xf8,
    0xf0, 0xf8, 0xfc, 0xfc, 0xf8, 0xfc, 0xfc, 0xfd, 0xfc, 0xfd,
    0xfd, 0xfd, 0xf8, 0xfc, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    0xfe, 0xfe, 0xfc, 0xf8, 0xfd, 0xfd, 0xfd, 0xfc, 0xfd, 0xfc,
    0xfc, 0xf8, 0xfc, 0xfc, 0xfc, 0xf0, 0xf8, 0xf0, 0xf0, 0xe0,
    0xfb, 0xfb, 0xfb, 0xf8, 0xfb, 0xf8, 0xf8, 0xf0, 0xfa, 0xf8,
    0xf8, 0xf0, 0xf8, 0xf0, 0xf0, 0xe0, 0xf9, 0xf8, 0xf8, 0xf0,
    0xf8, 0xf0, 0xe0, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0,
    0xc0, 0xc0, 0xf7, 0xf7, 0xf7, 0xf4, 0xf7, 0xf4, 0xf0, 0xf0,
    0xf6, 0xf0, 0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xf5, 0xf0,
    0xf0, 0xe0, 0xf0, 0xe0, 0xe0, 0xc0, 0xf0, 0xe0, 0xe0, 0xc0,
    0xe0, 0xc0, 0xc0, 0x80, 0xf3, 0xf0, 0xf0, 0xe0, 0xf0, 0xe0,
    0xe0, 0xc0, 0xf0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80,
    0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0xc0, 0x80,
    0x80, 0x80, 0x80, 0x300, 0xef, 0xef, 0xef, 0xec, 0xef, 0xec,
    0xe8, 0xe0, 0xee, 0xe8, 0xe8, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0,
    0xed, 0xe8, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xe0, 0xe0,
    0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0xeb, 0xe0, 0xe0, 0xe0,
    0xe0, 0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xc0, 0x80, 0xc0, 0x80,
    0x80, 0x100, 0xe0, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x100, 0xc0,
    0x80, 0x80, 0x100, 0x80, 0x300, 0xe7, 0xe0, 0xe0, 0xc0, 0xe0,
    0xc0, 0xc0, 0x80, 0xe0, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80,
    0x100, 0xe0, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x100, 0x80,
    0x80, 0x600, 0xe0, 0xc0, 0xc0, 0x80, 0x80, 0x300, 0x80, 0x700, 0x80,
    0xf00, 0xdf, 0xdf, 0xdf, 0xdc, 0xdf, 0xdc, 0xd8, 0xc0, 0xde,
    0xd8, 0xd8, 0xc0, 0xd8, 0xc0, 0xc0, 0xc0, 0xdd, 0xd8, 0xd0,
    0xc0, 0xd0, 0xc0, 0xc0, 0x80, 0xd0, 0xc0, 0xc0, 0x80, 0xc0,
    0x80, 0x80, 0x100, 0xdb, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0, 0xc0,
    0x80, 0xc0, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x100, 0xc0,
    0xc0, 0x80, 0x80, 0x80, 0x300, 0x80, 0x700, 0xd7, 0xd0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0xc0, 0xc0, 0x80, 0x100, 0x80,
    0x300, 0xc0, 0x80, 0x80, 0x100, 0x80, 0x300, 0x80, 0x700, 0xc0,
    0x80, 0x80, 0x100, 0x80, 0x300, 0x80, 0x700, 0x80, 0xf00, 0xcf,
    0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x100, 0xc0, 0x80, 0x80,
    0x100, 0x80, 0x300, 0xc0, 0x80, 0x80, 0x100, 0x80, 0xb00, 0xc0,
    0x80, 0x80, 0x1d00, 0xc0, 0x80, 0x3e00, 0xbf, 0xbf, 0xbf, 0xbe,
    0xbf, 0xbc, 0xbc, 0xa0, 0xbe, 0xbc, 0xb8, 0xa0, 0xb8, 0xa0,
    0x80, 0x80, 0xbd, 0xb8, 0xb0, 0x80, 0xb0, 0x80, 0x80, 0x80,
    0xb0, 0x80, 0x80, 0x80, 0x80, 0x300, 0xbb, 0xb0, 0xb0, 0x80,
    0xa0, 0x80, 0x80, 0x100, 0xa0, 0x80, 0x80, 0x100, 0x80, 0x300, 0xa0,
    0x80, 0x80, 0x100, 0x80, 0x300, 0x80, 0x700, 0xb7, 0xb0, 0xa0,
    0x80, 0xa0, 0x80, 0x80, 0x100, 0xa0, 0x80, 0x80, 0x100, 0x80,
    0x300, 0x80, 0x80, 0x80, 0xd00, 0x80, 0x80, 0x1e00, 0xaf, 0xa0,
    0xa0, 0x80, 0x80, 0x80, 0x80, 0x100, 0x80, 0x80, 0x600, 0x80,
    0xf00, 0x80, 0x1f00, 0x80, 0x3f00, 0x9f, 0x90, 0x80, 0x80, 0x80,
    0x300, 0x80, 0x700, 0x80, 0xf00, 0x80, 0x1f00, 0x80, 0x3f00, 0x80,
    0x7f00, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7c, 0x7c, 0x70, 0x7e,
    0x7c, 0x78, 0x60, 0x78, 0x60, 0x60, 0x100, 0x7d, 0x78, 0x78,
    0x60, 0x70, 0x40, 0x40, 0x100, 0x70, 0x40, 0x600, 0x7b, 0x78,
    0x70, 0x40, 0x70, 0x40, 0x200, 0x60, 0x700, 0x60, 0xf00, 0x77,
    0x70, 0x70, 0x100, 0x60, 0x300, 0x60, 0x700, 0x60, 0xf00, 0x40,
    0x1f00, 0x6f, 0x60, 0x60, 0x100, 0x60, 0x300, 0x40, 0x700, 0x40,
    0x6f00, 0x5f, 0x58, 0x40, 0x100, 0x40, 0x300, 0x40, 0xf700, 0x3f,
    0x3c, 0x30, 0x1fd00};

  private static int wave6581__STsrc[] = new int[] {
    0x7e00, 0x3, 0x3, 0x3f00, 0x1, 0x3c00, 0x7, 0x7, 0x7, 0x7, 0x3f00, 0x1,
    0x3e00, 0x3, 0x3, 0x3f00, 0x1, 0x3800, 0xe, 0xe, 0xe, 0xe,
    0xf, 0xf, 0xf, 0xf, 0x7e00, 0x3, 0x3, 0x3f00, 0x1, 0x3c00, 0x7,
    0x7, 0x7, 0x7, 0x3f00, 0x1, 0x3e00, 0x3, 0x3, 0x3f00, 0x1,
    0x3000, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1f, 0x1f, 0x3f, 0x3f, 0x7e00, 0x3, 0x3,
    0x3f00, 0x1, 0x3c00, 0x7, 0x7, 0x7, 0x7, 0x3f00, 0x1, 0x3e00, 0x3,
    0x3, 0x3f00, 0x1, 0x3800, 0xe, 0xe, 0xe, 0xe, 0xf, 0xf,
    0xf, 0x1f, 0x7e00, 0x3, 0x3, 0x3f00, 0x1, 0x3c00, 0x7, 0x7,
    0x7, 0x7, 0x3f00, 0x1, 0x3e00, 0x3, 0x3, 0x3f00, 0x1, 0x2000, 0x38,
    0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
    0x38, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3e, 0x3e, 0x3f, 0x3f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7e00, 0x3, 0x3, 0x3f00, 0x1, 0x3c00, 0x7, 0x7, 0x7,
    0x7, 0x3f00, 0x1, 0x3e00, 0x3, 0x3, 0x3f00, 0x1, 0x3800, 0xe,
    0xe, 0xe, 0xe, 0xf, 0xf, 0xf, 0xf, 0x7e00, 0x3, 0x3,
    0x3f00, 0x1, 0x3c00, 0x7, 0x7, 0x7, 0x7, 0x3f00, 0x1, 0x3e00, 0x3,
    0x3, 0x3f00, 0x1, 0x3000, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
    0x1c, 0x1c, 0x1e, 0x1e, 0x1e, 0x1e, 0x1f, 0x1f, 0x3f, 0x3f,
    0x7e00, 0x3, 0x3, 0x3f00, 0x1, 0x3c00, 0x7, 0x7, 0x7, 0x7,
    0x3f00, 0x1, 0x3e00, 0x3, 0x3, 0x3f00, 0x1, 0x3800, 0xe, 0xe,
    0xe, 0xe, 0xf, 0xf, 0xf, 0x1f, 0x7e00, 0x3, 0x3, 0x3f00, 0x1,
    0x3c00, 0x7, 0x7, 0x7, 0x7, 0x3f00, 0x1, 0x3e00, 0x3, 0x3,
    0x3f00, 0x1, 0x2000, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
    0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3c,
    0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3e, 0x3e, 0x3f,
    0x3f, 0x7f, 0x7f, 0x7f, 0x7f
  };

  private static int wave6581_PSTsrc[] = new int[] {
    0x3ff00, 0x3f, 0x3ef00, 0x20, 0x700, 0x30, 0x300, 0x78, 0x78, 0x7e, 0x7f,
    0x7f, 0x3ff00, 0x3f, 0x3ef00, 0x20, 0x700, 0x30, 0x300, 0x78, 0x78,
    0x7e, 0x7f, 0x7f
  };



  public static int wave6581_PS_[] = new int[4096];
  public static int wave6581_P_T[] = new int[4096];
  public static int wave6581_PST[] = new int[4096];
  public static int wave6581__ST[] = new int[4096];

  static {
    initWaves();
  }

  public static void initWaves() {
    unpack(wave6581_PS_src, wave6581_PS_);
    unpack(wave6581_P_Tsrc, wave6581_P_T);
    unpack(wave6581_PSTsrc, wave6581_PST);
    unpack(wave6581__STsrc, wave6581__ST);
  }

  private static void unpack(int[] src, int[] dst) {
    int wavePos = 0;
    for (int i = 0, n = src.length; i < n; i++) {
      if (src[i] > 0xff) {
	// Skip a bunch of zeroes!
	for (int j = 0, m = (src[i] >> 8); j < m; j++) {
	  dst[wavePos++] = 0;
	}
	//	wavePos += src[i] >> 8;
      } else {
	// Make them 12 bits samples
	dst[wavePos++] = (src[i] << 4);
      }
    }
    System.out.println("Unpacked: " + wavePos + " data");
  }

  public static void main(String[] args) {
    initWaves();
    int[] wave = wave6581__ST;
    for (int i = 0, n = 4096; i < n; i++) {
      System.out.print("0x" + Integer.toString(wave[i], 16));
      if (i % 8 == 7) System.out.print("\n" + Integer.toString(i + 1, 16) + "\t");
      else System.out.print(",");
    }

  }

}
