/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.SID;
import com.dreamfabric.jac64.SID6581;
import com.dreamfabric.jac64.SIDMixer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SIDMixerSE
extends SIDMixer {
    private SourceDataLine dataLine;
    private SourceDataLine syncDataLine;
    private FloatControl volume;
    byte[] syncBuffer = new byte[4096];
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public SIDMixerSE() {
    }

    public SIDMixerSE(SID6581[] sID6581Array, SID sID) {
        this.init(sID6581Array, sID);
    }

    public void init(SID6581[] sID6581Array, SID sID) {
        super.init(sID6581Array, sID);
        AudioFormat audioFormat = new AudioFormat(44000.0f, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SIDMixerSE.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat, DL_BUFFER_SIZE);
        DataLine.Info info2 = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SIDMixerSE.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat, 1760);
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.syncDataLine = (SourceDataLine)AudioSystem.getLine(info2);
            if (this.dataLine == null) {
                System.out.println("DataLine: not existing...");
            } else {
                System.out.println("Format: " + this.dataLine.getFormat());
                this.dataLine.open(this.dataLine.getFormat(), DL_BUFFER_SIZE);
                this.syncDataLine.open(this.syncDataLine.getFormat(), 1760);
                this.volume = (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                this.setMasterVolume(100);
                this.dataLine.start();
                this.syncDataLine.start();
            }
        }
        catch (Exception exception) {
            System.out.println("Problem while getting data line ");
            exception.printStackTrace();
        }
    }

    public void write(byte[] byArray) {
        if (!this.fullSpeed && this.getBufferLevel() > 80.0) {
            while (this.dataLine.available() < 88) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            this.dataLine.write(byArray, 0, 88);
        } else {
            this.dataLine.write(byArray, 0, 88);
        }
    }

    public long getMicros() {
        if (this.dataLine == null) {
            return System.currentTimeMillis() * 1000L;
        }
        return this.dataLine.getMicrosecondPosition();
    }

    public boolean hasSound() {
        return this.dataLine != null;
    }

    public int available() {
        return this.dataLine.available();
    }

    public void setMasterVolume(int n) {
        this.masterVolume = n;
        if (this.volume != null) {
            this.volume.setValue(-10.0f + 0.1f * (float)n);
        }
    }

    public int getMasterVolume() {
        return this.masterVolume;
    }

    public double getBufferLevel() {
        if (this.dataLine != null) {
            return 100.0 - 100.0 * (double)this.dataLine.available() / (double)DL_BUFFER_SIZE;
        }
        return 0.0;
    }

    public void shutdown() {
        this.dataLine.close();
        this.syncDataLine.close();
        this.dataLine = null;
        this.syncDataLine = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

