/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.SID;
import com.dreamfabric.jac64.SID6581;
import com.dreamfabric.jac64.SIDMixerListener;

public abstract class SIDMixer {
    public static int BYTES_PER_SAMPLE = 2;
    public static final boolean NO_SOUND = false;
    public static final boolean DEBUG = false;
    public static int DL_BUFFER_SIZE = 88000;
    public static final int SYNCH_BUFFER = 1760;
    public static final int EFX_NONE = 0;
    public static final int EFX_FLANGER_1 = 1;
    public static final int EFX_FLANGER_2 = 2;
    public static final int EFX_FLANGER_3 = 3;
    public static final int EFX_PHASER_1 = 4;
    public static final int EFX_PHASER_2 = 5;
    public static final int EFX_CHORUS_1 = 6;
    public static final int EFX_CHORUS_2 = 7;
    public static final int EFX_ECHO_1 = 8;
    public static final int EFX_ECHO_2 = 9;
    public static final int EFX_REV_SMALL = 10;
    public static final int EFX_REV_MED = 11;
    public static final int EFX_REV_LARGE = 12;
    public static final int EFX_FSWEEP = 13;
    public static final int EFX_FSWEEP_RES = 14;
    private String[] efxNames = new String[]{"EFX_NONE", "EFX_FLANGER_1", "EFX_FLANGER_2", "EFX_FLANGER_3", "EFX_PHASER_1", "EFX_PHASER_2", "EFX_CHORUS_1", "EFX_CHORUS_2", "EFX_ECHO_1", "EFX_ECHO_2", "EFX_REV_SMALL", "EFX_REV_MED", "EFX_REV_LARGE", "EFX_FSWEEP", "EFX_FSWEEP_RES"};
    public boolean fullSpeed = false;
    private SID psid;
    private SID6581[] channels;
    private boolean soundOn = true;
    private SIDMixerListener listener = null;
    byte[] buffer = new byte[88];
    byte[] syncBuffer = new byte[4096];
    int[] intBuffer = new int[44];
    int[] noFltBuffer = new int[44];
    boolean effects = false;
    public static final int LFO_WAVELEN = 500;
    int[] echo;
    int echoSize = 0;
    int echoPos = 0;
    int echoLFODiff = 0;
    int echoLFODiffMax = 0;
    int echoLFODepth = 50;
    int echoFeedback = 0;
    int echoLFOSpeed = 0;
    int echoLFOPos = 0;
    int echoDW = 50;
    int maxefx;
    int minefx;
    int sidVol = 15;
    int[] sidVolArr = new int[44];
    long lastCycles = 0L;
    int filterVal = 0;
    public int cutoff = 0;
    public int resonance = 0;
    int filterOn = 0;
    int masterVolume = 100;
    boolean lpOn = false;
    boolean hpOn = false;
    boolean bpOn = false;
    long vlp;
    long vhp;
    long vbp;
    long w0;
    long div1024Q;
    long exVlp;
    long exVhp;
    long exVo;
    long exw0lp;
    long exw0hp;
    int irq = 0;
    int[] sine10Hz;
    public static final int SLEEP_SYNC = 1;
    private int sleep = 100;
    private int syncMode = 0;
    private double avg = 10.0;
    private long lastTime = System.currentTimeMillis();
    private long micros = 0L;

    public SIDMixer() {
    }

    public SIDMixer(SID6581[] sID6581Array, SID sID) {
        this.init(sID6581Array, sID);
    }

    public void init(SID6581[] sID6581Array, SID sID) {
        this.channels = sID6581Array;
        this.psid = sID;
        System.out.println("Micros per SIDGen: " + this.getMicrosPerGen());
        this.exw0hp = 105L;
        this.exw0lp = 104858L;
        this.sine10Hz = new int[500];
        int n = 500;
        for (int i = 0; i < n; ++i) {
            this.sine10Hz[i] = (int)(500.0 + 500.0 * Math.sin((double)(i * 2) * 3.1415 / 500.0));
        }
        this.setEFX(8);
        this.setEFX(0);
    }

    public void setListener(SIDMixerListener sIDMixerListener) {
        this.listener = sIDMixerListener;
    }

    public void setEchoTime(int n) {
        int n2 = n * 44000 / 1000;
        System.out.println("SamplesDelay: " + n2);
        this.echoSize = n2;
        this.echo = new int[this.echoSize];
        this.echoLFODiffMax = this.echoSize * this.echoLFODepth / 110;
        this.echoLFODiff = 0;
        this.echoPos = 0;
    }

    public int getEchoTime() {
        return 1000 * this.echoSize / 44000;
    }

    public int getEFXCount() {
        return this.efxNames.length;
    }

    public String getEFXName(int n) {
        return this.efxNames[n];
    }

    public void setEchoFeedback(int n) {
        this.echoFeedback = n;
    }

    public int getEchoFeedback() {
        return this.echoFeedback;
    }

    public void setEchoLFOSpeed(int n) {
        this.echoLFOSpeed = n;
    }

    public int getEchoLFOSpeed() {
        return this.echoLFOSpeed;
    }

    public void setEchoDW(int n) {
        this.echoDW = n;
    }

    public int getEchoDW() {
        return this.echoDW;
    }

    public void setEchoLFODepth(int n) {
        this.echoLFODepth = n;
        this.echoLFODiffMax = this.echoSize * this.echoLFODepth / 110;
    }

    public int getEchoLFODepth() {
        return this.echoLFODepth;
    }

    public boolean getEffectsOn() {
        return this.effects;
    }

    public void setEFX(int n) {
        this.effects = true;
        switch (n %= this.efxNames.length) {
            case 0: {
                this.effects = false;
                break;
            }
            case 1: {
                this.setEchoTime(5);
                this.setEchoFeedback(75);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(35);
                this.setEchoDW(33);
                break;
            }
            case 2: {
                this.setEchoTime(15);
                this.setEchoFeedback(70);
                this.setEchoLFOSpeed(5);
                this.setEchoLFODepth(35);
                this.setEchoDW(35);
                break;
            }
            case 3: {
                this.setEchoTime(2);
                this.setEchoFeedback(85);
                this.setEchoLFOSpeed(3);
                this.setEchoLFODepth(55);
                this.setEchoDW(30);
                break;
            }
            case 4: {
                this.setEchoTime(10);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(75);
                this.setEchoDW(50);
                break;
            }
            case 5: {
                this.setEchoTime(3);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(2);
                this.setEchoLFODepth(85);
                this.setEchoDW(40);
                break;
            }
            case 6: {
                this.setEchoTime(25);
                this.setEchoFeedback(60);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(35);
                this.setEchoDW(35);
                break;
            }
            case 7: {
                this.setEchoTime(30);
                this.setEchoFeedback(50);
                this.setEchoLFOSpeed(5);
                this.setEchoLFODepth(25);
                this.setEchoDW(35);
                break;
            }
            case 8: {
                this.setEchoTime(150);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 9: {
                this.setEchoTime(300);
                this.setEchoFeedback(33);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(45);
                break;
            }
            case 10: {
                this.setEchoTime(70);
                this.setEchoFeedback(40);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 11: {
                this.setEchoTime(130);
                this.setEchoFeedback(50);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 12: {
                this.setEchoTime(100);
                this.setEchoFeedback(70);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(40);
            }
        }
        if (this.listener != null) {
            this.listener.updateValues();
        }
    }

    public void setEffectsOn(boolean bl) {
        this.effects = bl;
    }

    public boolean isEffectsOn() {
        return this.effects;
    }

    public void setFilterCutoffLO(int n) {
        this.cutoff = this.cutoff & 0xFF8 | n & 7;
        this.recalcFilter();
    }

    public void setFilterCutoffHI(int n) {
        this.cutoff = this.cutoff & 7 | n << 3;
        this.recalcFilter();
    }

    public void setFilterResonance(int n) {
        this.resonance = n;
        this.recalcFilter();
    }

    public void setFilterCtrl(int n) {
        this.lpOn = (n & 0x10) > 0;
        this.bpOn = (n & 0x20) > 0;
        this.hpOn = (n & 0x40) > 0;
        this.recalcFilter();
    }

    public void setFilterOn(int n) {
        this.filterOn = n;
    }

    public void setMoogFilterOn(boolean bl) {
    }

    public boolean isMoogFilterOn() {
        return false;
    }

    public void setMoogResonance(int n) {
    }

    public int getMoogResonance() {
        return 0;
    }

    public void setMoogCutoff(int n) {
    }

    public int getMoogCutoff() {
        return 0;
    }

    public void setMoogSpeed(int n) {
    }

    public int getMoogSpeed() {
        return 0;
    }

    public void setMoogDepth(int n) {
    }

    public int getMoogDepth() {
        return 0;
    }

    public void setVolume(int n) {
        this.sidVol = n;
    }

    public void setVolume(int n, long l) {
        if (this.lastCycles > 0L) {
            int n2 = (int)((l - this.lastCycles) / 32L);
            this.sidVolArr[n2 % 44] = n;
        } else {
            this.sidVol = n;
        }
    }

    private void recalcFilter() {
        int n = 30 + 12000 * this.cutoff / 2048;
        this.w0 = (long)(Math.PI * 2 * (double)n * 1.048576);
        this.div1024Q = (int)(1024.0 / (0.707 + 1.0 * (double)this.resonance / 15.0));
    }

    public void stop() {
        this.setVolume(0);
    }

    public void reset() {
        this.exVo = 0L;
        this.exVhp = 0L;
        this.exVlp = 0L;
        this.cutoff = 0;
        this.resonance = 0;
        this.w0 = 0L;
        this.div1024Q = 0L;
        this.filterOn = 0;
        this.maxefx = 0;
        this.minefx = 0;
        int n = 44;
        for (int i = 0; i < n; ++i) {
            this.sidVolArr[i] = -1;
        }
        this.setVolume(15);
        this.recalcFilter();
    }

    public void printStatus() {
        System.out.println("SIDMixer  ----------------------------");
        System.out.println("Volume: " + this.sidVol);
        System.out.println("FilterOn: " + this.filterOn);
        System.out.println("Cutoff: " + this.cutoff);
        System.out.println("Resonance: " + this.resonance);
        System.out.println("Max Efx:" + this.maxefx);
        System.out.println("Min Efx:" + this.minefx);
    }

    public void setFullSpeed(boolean bl) {
        System.out.println("Set full speed: " + bl);
        this.fullSpeed = bl;
    }

    public boolean fullSpeed() {
        return this.fullSpeed;
    }

    public int[] getBuffer() {
        return this.intBuffer;
    }

    public boolean updateSound(long l) {
        boolean bl;
        ++this.irq;
        boolean bl2 = bl = this.irq % 20 == 0;
        if (bl && this.syncMode == 1 && !this.fullSpeed) {
            long l2 = System.currentTimeMillis() - this.lastTime;
            this.lastTime = System.currentTimeMillis();
            this.avg = 0.99 * this.avg + 0.01 * (double)l2;
            if (this.avg < 20.0) {
                ++this.sleep;
            }
            if (this.avg > 20.0) {
                --this.sleep;
            }
            System.out.println("Avg: " + this.avg + " Sleep: " + (double)this.sleep / 10.0 + " " + (this.getMicros() - this.micros));
            double d = 19.75 - (double)(this.getMicros() - this.micros) / 1000.0;
            try {
                Thread.sleep((int)d);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.micros = this.getMicros();
        }
        if (!this.hasSound()) {
            return bl;
        }
        if ((this.fullSpeed || this.syncMode == 1) && this.available() < 88) {
            return false;
        }
        this.lastCycles = l;
        if (this.soundOn) {
            int n;
            int n2;
            int n3;
            if (this.psid != null) {
                int[] nArray = this.psid.generateSound(l);
                n3 = 44;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.intBuffer[n2] = 0;
                    this.noFltBuffer[n2] = nArray[n2] << 4;
                }
            } else {
                n3 = 44;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.intBuffer[n2] = 0;
                    this.noFltBuffer[n2] = 0;
                }
            }
            n3 = this.channels.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int[] nArray = this.channels[n2].generateSound(l);
                int[] nArray2 = (this.filterOn & 1 << n2) > 0 ? this.intBuffer : this.noFltBuffer;
                n = 44;
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] + (nArray[i] >> 2);
                }
            }
            n3 = 44;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = this.intBuffer[n2];
                if (this.filterOn > 0) {
                    this.vbp -= 8L * this.w0 * this.vhp >> 20;
                    this.vlp -= 8L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)n5;
                    this.vbp -= 8L * this.w0 * this.vhp >> 20;
                    this.vlp -= 8L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)n5;
                    this.vbp -= 7L * this.w0 * this.vhp >> 20;
                    this.vlp -= 7L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)n5;
                    n5 = (int)((this.bpOn ? this.vbp : 0L) + (this.hpOn ? this.vhp : 0L) + (this.lpOn ? this.vlp : 0L));
                }
                n5 += this.noFltBuffer[n2];
                if (this.sidVolArr[n2] != -1) {
                    this.sidVol = this.sidVolArr[n2];
                    this.sidVolArr[n2] = -1;
                }
                n5 = n5 * this.sidVol >> 3;
                this.exVlp += (8L * this.exw0lp >> 8) * ((long)n5 - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 8L * (this.exVlp - this.exVhp) >> 20;
                this.exVlp += (8L * this.exw0lp >> 8) * ((long)n5 - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 8L * (this.exVlp - this.exVhp) >> 20;
                this.exVo = this.exVlp - this.exVhp;
                this.exVlp += (7L * this.exw0lp >> 8) * ((long)n5 - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 7L * (this.exVlp - this.exVhp) >> 20;
                this.intBuffer[n2] = (int)this.exVo;
            }
            if (this.effects) {
                n3 = 44;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n6 = this.intBuffer[n2];
                    int n7 = (this.echoPos + this.echoLFODiff) % this.echoSize;
                    n = (n6 * (100 - this.echoDW) + this.echo[n7] * this.echoDW) / 100;
                    if (n > Short.MAX_VALUE) {
                        n = Short.MAX_VALUE;
                    }
                    if (n < -32767) {
                        n = -32767;
                    }
                    this.intBuffer[n2] = n;
                    if ((n6 += this.echo[n7] * this.echoFeedback / 100) > this.maxefx) {
                        this.maxefx = n6;
                    }
                    if (n6 < this.minefx) {
                        this.minefx = n6;
                    }
                    if (n6 > Short.MAX_VALUE) {
                        n6 = Short.MAX_VALUE;
                    }
                    if (n6 < -32767) {
                        n6 = -32767;
                    }
                    this.echo[this.echoPos] = n6;
                    this.echoPos = (this.echoPos + 1) % this.echoSize;
                }
            }
            n2 = 0;
            if (BYTES_PER_SAMPLE == 2) {
                int n8 = 44;
                for (n3 = 0; n3 < n8; ++n3) {
                    this.buffer[n2++] = (byte)(this.intBuffer[n3] & 0xFF);
                    this.buffer[n2++] = (byte)(this.intBuffer[n3] >> 8);
                }
            } else {
                int n9 = 44;
                for (n3 = 0; n3 < n9; ++n3) {
                    this.buffer[n2++] = (byte)(this.intBuffer[n3] >> 8);
                }
            }
        }
        this.write(this.buffer);
        if (bl) {
            this.echoLFODiff = this.echoLFODiffMax * this.sine10Hz[this.echoLFOPos] / 1000;
            this.echoLFOPos = (this.echoLFOPos + this.echoLFOSpeed) % 500;
        }
        return bl;
    }

    public int getMicrosPerGen() {
        long l = 44000000L;
        return (int)(l / 44000L);
    }

    public boolean soundOn() {
        return this.soundOn;
    }

    public void setSoundOn(boolean bl) {
        this.soundOn = bl;
        if (!this.soundOn) {
            int n = this.buffer.length;
            for (int i = 0; i < n; ++i) {
                this.buffer[i] = 0;
            }
        }
    }

    public abstract void write(byte[] var1);

    public abstract long getMicros();

    public abstract boolean hasSound();

    public abstract int available();

    public abstract int getMasterVolume();

    public abstract void setMasterVolume(int var1);

    public abstract void shutdown();
}

