/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

public class MoogFilter {
    private int samplingFrq;
    private double f;
    private double k;
    private double p;
    private double r;
    private double y1;
    private double y2;
    private double y3;
    private double y4;
    private double oldx;
    private double oldy1;
    private double oldy2;
    private double oldy3;
    private double yMax;
    private double yMin;

    public MoogFilter(int n) {
        this.samplingFrq = n;
    }

    public void printStatus() {
        System.out.println("yMax: " + this.yMax);
        System.out.println("yMin: " + this.yMin);
    }

    public void setFilterParams(int n, double d) {
        this.f = 2.0 * (double)n / (double)this.samplingFrq;
        this.k = 3.6 * this.f - 1.6 * this.f * this.f - 1.0;
        this.p = (this.k + 1.0) * 0.5;
        double d2 = Math.exp((1.0 - this.p) * 1.386249);
        this.r = d * d2;
    }

    public void performFilter(int[] nArray, int n) {
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            double d = (double)nArray[i] / 32768.0 - this.r * this.y4;
            if (nArray[i] != 0) {
                // empty if block
            }
            this.y1 = d * this.p + this.oldx * this.p - this.k * this.y1;
            this.y2 = this.y1 * this.p + this.oldy1 * this.p - this.k * this.y2;
            this.y3 = this.y2 * this.p + this.oldy2 * this.p - this.k * this.y3;
            this.y4 = this.y3 * this.p + this.oldy3 * this.p - this.k * this.y4;
            this.y4 -= this.y4 * this.y4 * this.y4 / 6.0;
            this.oldx = d;
            this.oldy1 = this.y1;
            this.oldy2 = this.y2;
            this.oldy3 = this.y3;
            if (this.y4 > this.yMax) {
                this.yMax = this.y4;
            }
            if (this.y4 < this.yMin) {
                this.yMin = this.y4;
            }
            if (this.y4 > 0.9) {
                this.y4 = 0.9;
            }
            if (this.y4 < -0.9) {
                this.y4 = -0.9;
            }
            nArray[i] = (int)(this.y4 * 32768.0);
        }
    }
}

