/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C64Chips;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.MOS6510Ops;
import com.dreamfabric.jac64.PatchListener;
import java.io.BufferedInputStream;
import java.io.InputStream;

public abstract class MOS6510Core
extends MOS6510Ops {
    protected int[] memory;
    public static final int NMI_INT = 1;
    public static final int IRQ_INT = 2;
    protected PatchListener list;
    protected C64Chips chips = null;
    protected IMonitor monitor;
    public String codebase;
    public boolean checkInterrupt = false;
    public boolean NMILow = false;
    public boolean NMILastLow = false;
    public boolean IRQLow = false;
    public int lastInterrupt = 0;
    public boolean busAvailable = true;
    public long baLowUntil = 0L;
    boolean sign = false;
    boolean zero = false;
    boolean overflow = false;
    boolean carry = false;
    boolean decimal = false;
    boolean brk = false;
    protected int acc = 0;
    protected int x = 0;
    protected int y = 0;
    protected int s = 255;
    protected long nmiCycleStart = 0L;
    protected long irqCycleStart = 0L;
    private String[] debugInfo;
    protected int jumpTo = -1;
    public long cycles = 0L;
    protected long lastMillis = 0L;
    protected long nr_ins = 0L;
    protected long nr_irq = 0L;
    protected long start = System.currentTimeMillis();
    protected int pc;
    protected int interruptInExec = 0;
    protected boolean disableInterupt = false;
    protected int rindex = 0;
    protected int lastReadOP = 0;

    public MOS6510Core(IMonitor iMonitor, String string) {
        this.monitor = iMonitor;
        this.codebase = string;
    }

    public int[] getMemory() {
        return this.memory;
    }

    public void stealCycles(int n) {
        this.cycles += (long)n;
    }

    public void jump(int n) {
        this.jumpTo = n;
        this.checkInterrupt = true;
    }

    public long getCycles() {
        return this.cycles;
    }

    public void setIRQLow(boolean bl) {
        if (!this.IRQLow && bl) {
            this.checkInterrupt = true;
            this.irqCycleStart = this.cycles + 2L;
        }
        this.IRQLow = bl;
    }

    public void setNMILow(boolean bl) {
        if (!this.NMILow && bl) {
            this.checkInterrupt = true;
            this.nmiCycleStart = this.cycles + 2L;
        }
        this.NMILow = bl;
        if (!bl) {
            this.NMILastLow = bl;
        }
    }

    public int getSP() {
        return this.s;
    }

    private final void doInterrupt(int n, int n2) {
        this.fetchByte(this.pc);
        ++this.cycles;
        this.fetchByte(this.pc + 1);
        ++this.cycles;
        this.push((this.pc & 0xFF00) >> 8);
        this.push(this.pc & 0xFF);
        this.push(n2);
        ++this.interruptInExec;
        this.pc = this.fetchByte(n + 1) << 8;
        ++this.cycles;
        this.pc += this.fetchByte(n);
        ++this.cycles;
    }

    protected final int getStatusByte() {
        return (this.carry ? 1 : 0) + (this.zero ? 2 : 0) + (this.disableInterupt ? 4 : 0) + (this.decimal ? 8 : 0) + (this.brk ? 16 : 0) + 32 + (this.overflow ? 64 : 0) + (this.sign ? 128 : 0);
    }

    private final void setStatusByte(int n) {
        this.carry = (n & 1) != 0;
        this.zero = (n & 2) != 0;
        this.disableInterupt = (n & 4) != 0;
        this.decimal = (n & 8) != 0;
        this.brk = (n & 0x10) != 0;
        this.overflow = (n & 0x40) != 0;
        this.sign = (n & 0x80) != 0;
    }

    protected abstract int fetchByte(int var1);

    protected abstract void writeByte(int var1, int var2);

    private final void setZS(int n) {
        this.zero = n == 0;
        this.sign = n > 127;
    }

    private final void setCarry(int n) {
        this.carry = n > 127;
    }

    private final int pop() {
        this.s = this.s + 1 & 0xFF;
        int n = this.fetchByte(this.s | 0x100);
        ++this.cycles;
        return n;
    }

    private final void push(int n) {
        this.writeByte(this.s & 0xFF | 0x100, n);
        this.s = this.s - 1 & 0xFF;
        ++this.cycles;
    }

    private final void opADCimp(int n) {
        int n2 = n + this.acc + (this.carry ? 1 : 0);
        boolean bl = this.zero = (n2 & 0xFF) == 0;
        if (this.decimal) {
            n2 = (this.acc & 0xF) + (n & 0xF) + (this.carry ? 1 : 0);
            if (n2 > 9) {
                n2 += 6;
            }
            n2 = n2 <= 15 ? (n2 & 0xF) + (this.acc & 0xF0) + (n & 0xF0) : (n2 & 0xF) + (this.acc & 0xF0) + (n & 0xF0) + 16;
            this.overflow = ((this.acc ^ n) & 0x80) == 0 && ((this.acc ^ n2) & 0x80) != 0;
            boolean bl2 = this.sign = (n2 & 0x80) > 0;
            if ((n2 & 0x1F0) > 144) {
                n2 += 96;
            }
            this.carry = n2 > 153;
        } else {
            this.overflow = ((this.acc ^ n) & 0x80) == 0 && ((this.acc ^ n2) & 0x80) != 0;
            this.carry = n2 > 255;
            this.sign = (n2 & 0x80) > 0;
        }
        this.acc = n2 & 0xFF;
    }

    private final void branch(boolean bl, int n, int n2) {
        if (bl) {
            int n3 = this.pc;
            this.pc = n;
            if (n2 == 1) {
                this.fetchByte(this.pc);
                ++this.cycles;
            } else {
                if (this.pc < n3) {
                    this.fetchByte(this.pc + 256);
                } else {
                    this.fetchByte(this.pc - 256);
                }
                ++this.cycles;
                this.fetchByte(this.pc);
                ++this.cycles;
            }
        }
    }

    private final void opSBCimp(int n) {
        int n2 = this.acc - n - (this.carry ? 0 : 1);
        boolean bl = n2 >= 0;
        this.sign = ((n2 &= 0x1FF) & 0x80) == 128;
        this.zero = (n2 & 0xFF) == 0;
        boolean bl2 = this.overflow = ((this.acc ^ n2) & 0x80) != 0 && ((this.acc ^ n) & 0x80) != 0;
        if (this.decimal) {
            n2 = (this.acc & 0xF) - (n & 0xF) - (this.carry ? 0 : 1);
            if (((n2 = (n2 & 0x10) > 0 ? n2 - 6 & 0xF | (this.acc & 0xF0) - (n & 0xF0) - 16 : n2 & 0xF | (this.acc & 0xF0) - (n & 0xF0)) & 0x100) > 0) {
                n2 -= 96;
            }
        }
        this.acc = n2 & 0xFF;
        this.carry = bl;
    }

    public void emulateOp() {
        if (this.checkInterrupt) {
            if (this.NMILow && !this.NMILastLow && this.cycles > this.nmiCycleStart) {
                this.lastInterrupt = 1;
                this.doInterrupt(65530, this.getStatusByte() & 0xEF);
                this.disableInterupt = true;
                this.NMILastLow = this.NMILow;
                return;
            }
            if (this.IRQLow && this.cycles > this.irqCycleStart || this.brk) {
                if (!this.disableInterupt) {
                    this.lastInterrupt = 2;
                    int n = this.getStatusByte();
                    if (this.brk) {
                        n |= 0x10;
                        ++this.pc;
                    } else {
                        n &= 0xEF;
                    }
                    this.doInterrupt(65534, n);
                    this.disableInterupt = true;
                    this.brk = false;
                    return;
                }
                this.brk = false;
                this.checkInterrupt = this.NMILow && !this.NMILastLow;
            } else if (this.jumpTo != -1) {
                this.pc = this.jumpTo;
                this.jumpTo = -1;
            }
        }
        int n = INSTRUCTION_SET[this.fetchByte(this.pc++)];
        int n2 = n & 0xFF;
        int n3 = n & 0xF00;
        boolean bl = (n & 0x1000) != 0;
        boolean bl2 = (n & 0x2000) != 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = false;
        this.lastReadOP = this.rindex;
        ++this.cycles;
        int n6 = this.fetchByte(this.pc);
        ++this.cycles;
        switch (n3) {
            case 256: {
                ++this.pc;
                n = n6;
                break;
            }
            case 768: {
                ++this.pc;
                n4 = (this.fetchByte(this.pc++) << 8) + n6;
                ++this.cycles;
                if (!bl) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 512: {
                ++this.pc;
                n4 = n6;
                if (!bl) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 1024: 
            case 1280: {
                ++this.pc;
                this.fetchByte(n6);
                ++this.cycles;
                n4 = n3 == 1024 ? n6 + this.x & 0xFF : n6 + this.y & 0xFF;
                if (!bl) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 1536: 
            case 1792: {
                ++this.pc;
                n4 = this.fetchByte(this.pc++) << 8;
                ++this.cycles;
                n6 = n3 == 1536 ? (n6 += this.x) : (n6 += this.y);
                n = this.fetchByte(n4 + (n6 & 0xFF));
                ++this.cycles;
                n4 += n6;
                if (!bl || n6 <= 255 && !bl2) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 2048: {
                ++this.pc;
                n4 = this.pc + (byte)n6;
                if (((n4 ^ this.pc) & 0xFF00) > 0) {
                    n5 = 2;
                    break;
                }
                n5 = 1;
                break;
            }
            case 2816: {
                n = this.acc;
                bl2 = false;
                break;
            }
            case 2304: {
                ++this.pc;
                this.fetchByte(n6);
                n5 = n6 + this.x & 0xFF;
                ++this.cycles;
                n4 = this.fetchByte(n5 + 1) << 8;
                ++this.cycles;
                n4 |= this.fetchByte(n5);
                ++this.cycles;
                if (!bl) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 2560: {
                ++this.pc;
                n4 = this.fetchByte(n6 + 1) << 8;
                ++this.cycles;
                n6 = this.fetchByte(n6);
                ++this.cycles;
                n = this.fetchByte(n4 + ((n6 += this.y) & 0xFF));
                n4 += n6;
                ++this.cycles;
                if (!bl || n6 <= 255 && !bl2) break;
                n = this.fetchByte(n4);
                ++this.cycles;
                break;
            }
            case 3072: {
                ++this.pc;
                n4 = (this.fetchByte(this.pc) << 8) + n6;
                ++this.cycles;
                n5 = n4 & 0xFFF00 | n4 + 1 & 0xFF;
                n4 = this.fetchByte(n4);
                ++this.cycles;
                n4 += this.fetchByte(n5) << 8;
                ++this.cycles;
            }
        }
        if (bl && bl2) {
            this.writeByte(n4, n);
            ++this.cycles;
        }
        switch (n2) {
            case 0: {
                this.brk = true;
                this.checkInterrupt = true;
                System.err.println("Break... at " + Integer.toString(this.pc, 16) + ": " + this.cycles);
                this.monitor.info("Break... at " + Integer.toString(this.pc, 16) + ": " + this.cycles);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                break;
            }
            case 11: {
                this.acc &= n;
                this.setZS(this.acc);
                break;
            }
            case 28: {
                this.opADCimp(n);
                break;
            }
            case 70: {
                this.opSBCimp(n);
                break;
            }
            case 1: {
                this.acc |= n;
                this.setZS(this.acc);
                break;
            }
            case 19: {
                this.acc ^= n;
                this.setZS(this.acc);
                break;
            }
            case 13: {
                this.sign = n > 127;
                this.overflow = (n & 0x40) > 0;
                this.zero = (this.acc & n) == 0;
                break;
            }
            case 21: {
                this.carry = (n & 1) != 0;
                this.zero = (n >>= 1) == 0;
                this.sign = false;
                break;
            }
            case 14: {
                n = (n << 1) + (this.carry ? 1 : 0);
                this.carry = (n & 0x100) != 0;
                this.setZS(n &= 0xFF);
                break;
            }
            case 30: {
                bl3 = (n & 1) != 0;
                n = (n >> 1) + (this.carry ? 128 : 0);
                this.carry = bl3;
                this.setZS(n);
                break;
            }
            case 40: {
                this.acc = this.x;
                this.setZS(this.acc);
                break;
            }
            case 53: {
                this.x = this.acc;
                this.setZS(this.x);
                break;
            }
            case 44: {
                this.acc = this.y;
                this.setZS(this.acc);
                break;
            }
            case 55: {
                this.y = this.acc;
                this.setZS(this.y);
                break;
            }
            case 58: {
                this.x = this.s;
                this.setZS(this.x);
                break;
            }
            case 45: {
                this.s = this.x & 0xFF;
                break;
            }
            case 63: {
                n = n - 1 & 0xFF;
                this.setZS(n);
                break;
            }
            case 72: {
                n = n + 1 & 0xFF;
                this.setZS(n);
                break;
            }
            case 73: {
                this.x = this.x + 1 & 0xFF;
                this.setZS(this.x);
                break;
            }
            case 65: {
                this.x = this.x - 1 & 0xFF;
                this.setZS(this.x);
                break;
            }
            case 64: {
                this.y = this.y + 1 & 0xFF;
                this.setZS(this.y);
                break;
            }
            case 39: {
                this.y = this.y - 1 & 0xFF;
                this.setZS(this.y);
                break;
            }
            case 10: {
                ++this.pc;
                n4 = (this.fetchByte(this.pc) << 8) + n6;
                ++this.cycles;
                this.fetchByte(this.s | 0x100);
                ++this.cycles;
                this.push((this.pc & 0xFF00) >> 8);
                this.push(this.pc & 0xFF);
                this.pc = n4;
                break;
            }
            case 24: {
                this.pc = n4;
                break;
            }
            case 27: {
                this.fetchByte(this.s | 0x100);
                ++this.cycles;
                this.pc = this.pop() + (this.pop() << 8);
                ++this.pc;
                this.fetchByte(this.pc);
                ++this.cycles;
                break;
            }
            case 18: {
                this.fetchByte(this.s | 0x100);
                ++this.cycles;
                n5 = this.pop();
                this.setStatusByte(n5);
                this.pc = this.pop() + (this.pop() << 8);
                this.brk = false;
                --this.interruptInExec;
                this.checkInterrupt = true;
                break;
            }
            case 2: {
                this.monitor.info("TRAP Instruction executed");
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.setCarry(n);
                n = n << 1 & 0xFF;
                this.setZS(n);
                break;
            }
            case 22: {
                this.push(this.acc);
                break;
            }
            case 31: {
                this.fetchByte(this.s | 0x100);
                ++this.cycles;
                this.acc = this.pop();
                this.setZS(this.acc);
                break;
            }
            case 6: {
                this.brk = true;
                this.push(this.getStatusByte());
                this.brk = false;
                break;
            }
            case 15: {
                n5 = this.pop();
                this.setStatusByte(n5);
                this.brk = false;
                this.checkInterrupt = true;
                break;
            }
            case 7: {
                this.acc &= n;
                this.setZS(this.acc);
                this.carry = (this.acc & 0x80) != 0;
                break;
            }
            case 61: {
                n = this.acc - n;
                this.carry = n >= 0;
                this.setZS(n & 0xFF);
                break;
            }
            case 69: {
                n = this.x - n;
                this.carry = n >= 0;
                this.setZS(n & 0xFF);
                break;
            }
            case 60: {
                n = this.y - n;
                this.carry = n >= 0;
                this.setZS(n & 0xFF);
                break;
            }
            case 42: {
                this.branch(!this.carry, n4, n5);
                break;
            }
            case 56: {
                this.branch(this.carry, n4, n5);
                break;
            }
            case 74: {
                this.branch(this.zero, n4, n5);
                break;
            }
            case 67: {
                this.branch(!this.zero, n4, n5);
                break;
            }
            case 25: {
                this.branch(!this.overflow, n4, n5);
                break;
            }
            case 33: {
                this.branch(this.overflow, n4, n5);
                break;
            }
            case 8: {
                this.branch(!this.sign, n4, n5);
                break;
            }
            case 16: {
                this.branch(this.sign, n4, n5);
                break;
            }
            case 9: {
                this.carry = false;
                break;
            }
            case 17: {
                this.carry = true;
                break;
            }
            case 68: {
                this.decimal = false;
                break;
            }
            case 75: {
                this.decimal = true;
                break;
            }
            case 57: {
                this.overflow = false;
                break;
            }
            case 34: {
                this.disableInterupt = true;
                break;
            }
            case 26: {
                this.disableInterupt = false;
                this.checkInterrupt = true;
                break;
            }
            case 50: {
                this.acc = n;
                this.setZS(n);
                break;
            }
            case 51: {
                this.x = n;
                this.setZS(n);
                break;
            }
            case 49: {
                this.y = n;
                this.setZS(n);
                break;
            }
            case 36: {
                n = this.acc;
                break;
            }
            case 38: {
                n = this.x;
                break;
            }
            case 37: {
                n = this.y;
                break;
            }
            case 41: {
                this.acc = n6 & this.x & (this.acc | 0xEE);
                this.setZS(this.acc);
                break;
            }
            case 32: {
                n5 = n6 & this.acc;
                int n7 = this.acc = this.carry ? n5 >> 1 | 0x80 : n5 >> 1;
                if (!this.decimal) {
                    this.setZS(this.acc);
                    this.carry = (this.acc & 0x40) != 0;
                    this.overflow = (this.acc & 0x40 ^ (this.acc & 0x20) << 1) != 0;
                    break;
                }
                this.sign = this.carry;
                this.zero = this.acc == 0;
                boolean bl4 = this.overflow = ((n5 ^ this.acc) & 0x40) != 0;
                if ((n5 & 0xF) + (n5 & 1) > 5) {
                    this.acc = this.acc & 0xF0 | this.acc + 6 & 0xF;
                }
                if (!(this.carry = (n5 + (n5 & 0x10) & 0x1F0) > 80)) break;
                this.acc += 96;
                break;
            }
            case 23: {
                this.acc &= n;
                bl3 = (this.acc & 1) != 0;
                this.acc >>= 1;
                this.carry = bl3;
                this.setZS(this.acc);
                break;
            }
            case 62: {
                n = n - 1 & 0xFF;
                this.setZS(n);
                n5 = this.acc - n;
                this.carry = n5 >= 0;
                this.setZS(n5 & 0xFF);
                break;
            }
            case 71: {
                n = n + 1 & 0xFF;
                this.opSBCimp(n);
                break;
            }
            case 52: {
                this.acc = this.x = n;
                this.setZS(this.acc);
                break;
            }
            case 59: {
                break;
            }
            case 54: {
                this.x = this.acc = (this.acc | 0xEE) & n6;
                this.setZS(this.acc);
                break;
            }
            case 12: {
                n = (n << 1) + (this.carry ? 1 : 0);
                this.carry = (n & 0x100) != 0;
                this.acc &= (n &= 0xFF);
                this.zero = this.acc == 0;
                this.sign = this.acc > 127;
                break;
            }
            case 29: {
                bl3 = (n & 1) != 0;
                n = (n >> 1) + (this.carry ? 128 : 0);
                this.carry = bl3;
                this.opADCimp(n);
                break;
            }
            case 66: {
                this.x = (this.acc & this.x) - n6;
                this.carry = this.x >= 0;
                this.x &= 0xFF;
                this.setZS(this.x);
                break;
            }
            case 43: {
                n = this.acc & this.x & (n4 >> 8) + 1;
                break;
            }
            case 46: {
                n = this.acc & this.x & (n4 >> 8) + 1;
                this.s = this.acc & this.x;
                break;
            }
            case 48: {
                n = this.x & (n4 >> 8) + 1;
                break;
            }
            case 47: {
                n = this.y & (n4 >> 8) + 1;
                break;
            }
            case 35: {
                n = this.acc & this.x;
                break;
            }
            case 20: {
                this.carry = (n & 1) != 0;
                this.acc ^= (n >>= 1);
                this.setZS(this.acc);
                break;
            }
            case 3: {
                this.setCarry(n);
                n = n << 1 & 0xFF;
                this.acc |= n;
                this.setZS(this.acc);
                break;
            }
            case 77: {
                this.cycles += 100L;
                break;
            }
            case 76: {
                int n8;
                if (this.acc == 0) {
                    this.monitor.info("**** LOAD FILE! ***** PC = " + Integer.toString(this.pc, 16) + " => " + Integer.toString(this.rindex, 16));
                } else {
                    this.monitor.info("**** VERIFY!    ***** PC = " + this.pc + " => " + this.rindex);
                }
                int n9 = this.memory[187] + (this.memory[188] << 8);
                int n10 = this.memory[183];
                this.monitor.info("Filename len:" + n10);
                String string = "";
                for (n8 = 0; n8 < n10; ++n8) {
                    string = string + (char)this.memory[n9++];
                }
                string = string + '\n';
                n8 = this.memory[185];
                this.monitor.info("name = " + string);
                this.monitor.info("Sec Address: " + n8);
                int n11 = -1;
                if (n8 == 0) {
                    n11 = this.memory[43] + (this.memory[44] << 8);
                }
                if (this.list != null && this.list.readFile(string, n11)) {
                    this.acc = 0;
                }
                --this.pc;
            }
        }
        if (bl2) {
            this.writeByte(n4, n);
            ++this.cycles;
        } else if (n3 == 2816) {
            this.acc = n;
        }
    }

    public void init(C64Chips c64Chips) {
        MOS6510Ops.init();
        this.installROMS();
        this.chips = c64Chips;
    }

    protected abstract void installROMS();

    protected abstract void patchROM(PatchListener var1);

    public void reset() {
        this.chips.reset();
        this.sign = false;
        this.zero = false;
        this.overflow = false;
        this.carry = false;
        this.decimal = false;
        this.brk = false;
        this.disableInterupt = false;
        this.interruptInExec = 0;
        this.rindex = 0;
        this.checkInterrupt = false;
        this.NMILow = false;
        this.NMILastLow = false;
        this.IRQLow = false;
        if (this.list != null) {
            this.patchROM(this.list);
        }
    }

    public void setDebug(int n, String string) {
        if (this.debugInfo == null) {
            this.debugInfo = new String[65536];
        }
        this.debugInfo[n & 0xFFFF] = string;
    }

    public String getDebug(int n) {
        if (this.debugInfo != null) {
            return this.debugInfo[n & 0xFFFF];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadROM(InputStream inputStream, int n, int n2) {
        block15: {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                if (bufferedInputStream == null) break block15;
                byte[] byArray = new byte[n2];
                int n3 = 0;
                try {
                    int n4;
                    while ((n4 = bufferedInputStream.read(byArray, n3, n2 - n3)) > 0) {
                        n3 += n4;
                    }
                    this.monitor.info("Installing rom at :" + Integer.toString(n, 16) + " size:" + n3);
                    for (int i = 0; i < byArray.length; ++i) {
                        this.memory[i + n] = byArray[i] & 0xFF;
                    }
                }
                catch (Exception exception) {
                    this.monitor.error("Problem reading rom file ");
                    exception.printStackTrace();
                }
                finally {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                this.monitor.error("Error loading resource" + exception);
            }
        }
    }
}

