/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.c64utils.C64Script;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.CIA;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Locale;

public class Keyboard {
    public static final int IO_OFFSET = 12288;
    public static final int AUTO_SHIFT = 1024;
    public static final int AUTO_CTRL = 2048;
    public static final int AUTO_COMMODORE = 4096;
    public static final int MIN_AUTO = 1024;
    public static final int STICK_UPDOWN = 3;
    public static final int STICK_LEFTRIGHT = 12;
    public static final int STICK_UP = 1;
    public static final int STICK_DOWN = 2;
    public static final int STICK_LEFT = 4;
    public static final int STICK_RIGHT = 8;
    public static final int STICK_FIRE = 16;
    public static final char[][] KEYMAPS = new char[][]{{'s', 'v', ';', '\u00f6', '\'', '\u00e4', '[', '\u00e5', '`', '\u00a7', '\\', '\u00de', '/', '-', ']', '\u0087', '-', '\u0209', '=', '\u0081'}, {'d', 'e', ';', '\u00f6', '\'', '\u00e4', '[', '\u00fc', '`', '^', '\\', '\u0208', '/', '-', ']', '\u0209', '-', '\u00df', '=', '\u0081'}};
    boolean extendedKeyboardEmulation = false;
    boolean stickExits = false;
    int joystick1 = 255;
    int bval;
    boolean lastUp = false;
    boolean lastLeft = false;
    private int joy1 = 255;
    private int joy2 = 255;
    int stick = 68608;
    private int keyPressed = 0;
    private int lastKey;
    public boolean ready = false;
    public int reads = 0;
    private C64Script c64script;
    private ArrayList hotkeyScript;
    int[] keyrow = new int[8];
    int[] keycol = new int[8];
    int[][] keytable = new int[1024][3];
    int keyShift = 0;
    int[][] keytableDef = new int[][]{{65, 1, 2, 0}, {66, 3, 4, 0}, {67, 2, 4, 0}, {68, 2, 2, 0}, {69, 1, 6, 0}, {70, 2, 5, 0}, {71, 3, 2, 0}, {72, 3, 5, 0}, {73, 4, 1, 0}, {74, 4, 2, 0}, {75, 4, 5, 0}, {76, 5, 2, 0}, {77, 4, 4, 0}, {78, 4, 7, 0}, {79, 4, 6, 0}, {80, 5, 1, 0}, {81, 7, 6, 0}, {82, 2, 1, 0}, {83, 1, 5, 0}, {84, 2, 6, 0}, {85, 3, 6, 0}, {86, 3, 7, 0}, {87, 1, 1, 0}, {88, 2, 7, 0}, {89, 3, 1, 0}, {90, 1, 4, 0}, {48, 4, 3, 0}, {49, 7, 0, 0}, {50, 7, 3, 0}, {51, 1, 0, 0}, {52, 1, 3, 0}, {53, 2, 0, 0}, {54, 2, 3, 0}, {55, 3, 0, 0}, {56, 3, 3, 0}, {57, 4, 0, 0}, {10, 0, 1, 0}, {10, 0, 1, 0}, {32, 7, 4, 0}, {44, 5, 7, 0}, {46, 5, 4, 0}, {92, 6, 5, 0}, {59, 5, 5, 0}, {45, 5, 0, 0}, {61, 5, 3, 0}, {96, 7, 1, 0}, {39, 6, 2, 0}, {109, 5, 3, 0}, {91, 5, 6, 0}, {93, 6, 1, 0}, {27, 7, 1, 0}, {47, 6, 7, 0}, {111, 6, 7, 0}, {63, 6, 7, 1024}, {127, 0, 0, 0}, {8, 0, 0, 0}, {16, 1, 7, 0}, {20, 6, 4, 0}, {19, 7, 7, 0}, {27, 7, 7, 0}, {13, 0, 1, 0}, {17, 7, 5, 2}, {10, 0, 1, 0}, {40, 0, 7, 0}, {38, 0, 7, 1024}, {39, 0, 2, 0}, {37, 0, 2, 1024}, {112, 0, 4, 0}, {114, 0, 5, 0}, {116, 0, 6, 0}, {118, 0, 3, 0}, {36, 6, 3, 0}, {35, 6, 6, 0}, {155, 6, 0, 0}, {9, 7, 2, 0}};
    private int restoreKey = 33;
    public static final int USER_UP = 0;
    public static final int USER_DOWN = 1;
    public static final int USER_LEFT = 2;
    public static final int USER_RIGHT = 3;
    public static final int USER_FIRE = 4;
    private static final int[] ARROWS = new int[]{38, 0, 40, 0, 37, 0, 39, 0, 17, 3};
    private int[] userDefinedStick = ARROWS;
    private CIA cia;
    private C64Screen screen;

    private void remap(char c, char c2) {
        int n = this.keytableDef.length;
        for (int i = 0; i < n; ++i) {
            if (this.keytableDef[i][0] != c) continue;
            this.keytableDef[i][0] = c2;
            System.out.println("Remapped: " + c + " => " + c2 + "  key " + c + " => " + c2);
            return;
        }
    }

    private boolean doMap(String string) {
        int n = KEYMAPS.length;
        for (int i = 0; i < n; ++i) {
            char[] cArray = KEYMAPS[i];
            String string2 = "" + cArray[0] + cArray[1];
            System.out.println("Checking map for: " + string2);
            if (!string.equals(string2)) continue;
            System.out.println("Found map - mapping...");
            int n2 = cArray.length;
            for (int j = 2; j < n2; j += 2) {
                this.remap(cArray[j], cArray[j + 1]);
            }
            return true;
        }
        return false;
    }

    public Keyboard(C64Screen c64Screen, CIA cIA, int[] nArray) {
        int n;
        Locale locale = Locale.getDefault();
        System.out.println("Locale: " + locale);
        String string = locale.getLanguage();
        if (!this.doMap(string)) {
            System.out.println("Could not find map for keyboard: " + string);
        }
        this.cia = cIA;
        this.screen = c64Screen;
        for (n = 0; n < this.keytable.length; ++n) {
            this.keytable[n][0] = -1;
        }
        for (n = 0; n < this.keytableDef.length; ++n) {
            int n2 = this.keytableDef[n][0];
            this.keytable[n2][0] = this.keytableDef[n][1];
            this.keytable[n2][1] = this.keytableDef[n][2];
            this.keytable[n2][2] = this.keytableDef[n][3];
        }
        this.reset();
    }

    public void registerHotKey(int n, int n2, String string, Object object) {
        if (this.hotkeyScript == null) {
            this.c64script = new C64Script();
            this.hotkeyScript = new ArrayList();
        }
        this.hotkeyScript.add(new Object[]{string, object, new int[]{n, n2}});
    }

    public void setStick(boolean bl) {
        this.stick = bl ? 68609 : 68608;
    }

    private int getUserStick(int n, int n2) {
        if (this.userDefinedStick != null) {
            int n3 = this.userDefinedStick.length;
            for (int i = 0; i < n3; i += 2) {
                int n4;
                if (n != this.userDefinedStick[i] || (n4 = this.userDefinedStick[i + 1]) != 0 && n2 != this.userDefinedStick[i + 1]) continue;
                return i / 2;
            }
        }
        return -1;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getKeyLocation();
        if (this.hotkeyScript != null) {
            n = keyEvent.getModifiersEx();
            int n4 = this.hotkeyScript.size();
            for (int i = 0; i < n4; ++i) {
                Object[] objectArray = (Object[])this.hotkeyScript.get(i);
                int[] nArray = (int[])objectArray[2];
                if (nArray[0] != n2 || (n & nArray[1]) != nArray[1]) continue;
                this.c64script.interpretCall((String)objectArray[0], objectArray[1]);
            }
        }
        if (n2 == 0) {
            System.out.println("KeyZero ???");
            n2 = Character.toLowerCase(c);
        }
        if (n2 == this.restoreKey) {
            this.screen.restoreKey(true);
        }
        if (n2 != this.lastKey) {
            ++this.keyPressed;
        }
        this.lastKey = n2;
        n = this.getUserStick(n2, n3);
        if (this.extendedKeyboardEmulation) {
            n = -1;
        }
        if (n == -1) {
            n = this.getNormalStick(n2);
        }
        switch (n) {
            case 0: {
                this.joystick1 &= 0xFE;
                this.lastUp = true;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 1: {
                this.joystick1 &= 0xFD;
                this.lastUp = false;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 2: {
                this.joystick1 &= 0xFB;
                this.lastLeft = true;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 3: {
                this.joystick1 &= 0xF7;
                this.lastLeft = false;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 4: {
                this.joystick1 &= 0xEF;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
        }
        switch (n2) {
            case 121: {
                this.setStick(this.stick == 68608);
                break;
            }
            case 120: {
                System.out.println("F9");
                this.extendedKeyboardEmulation = !this.extendedKeyboardEmulation;
                this.stickExits = !this.extendedKeyboardEmulation;
                break;
            }
        }
        if (this.extendedKeyboardEmulation) {
            if ((this.keytable[n2][2] & 0x400) != 0) {
                ++this.keyShift;
                if (this.keyShift == 1) {
                    this.handleKeyPress(16, n3);
                }
            } else if (n2 == 16) {
                ++this.keyShift;
            }
            this.handleKeyPress(n2, n3);
            this.updateKeyboard();
        } else if (this.keytable[n2][2] < 1024) {
            this.handleKeyPress(n2, n3);
            this.updateKeyboard();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n3 = keyEvent.getKeyLocation();
        if (n2 == 0) {
            System.out.println("KeyZero???");
            n2 = Character.toLowerCase(c);
        }
        if (n2 == this.restoreKey) {
            this.screen.restoreKey(false);
        }
        --this.keyPressed;
        this.lastKey = 0;
        if (this.keyPressed < 0) {
            this.keyPressed = 0;
        }
        if ((n = this.getUserStick(n2, n3)) == -1) {
            n = this.getNormalStick(n2);
        }
        switch (n) {
            case 0: {
                this.joystick1 |= 1;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 1: {
                this.joystick1 |= 2;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 2: {
                this.joystick1 |= 4;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 3: {
                this.joystick1 |= 8;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
            case 4: {
                this.joystick1 |= 0x10;
                if (!this.stickExits) break;
                this.updateKeyboard();
                return;
            }
        }
        if (this.extendedKeyboardEmulation) {
            if ((this.keytable[n2][2] & 0x400) != 0) {
                --this.keyShift;
                if (this.keyShift == 0) {
                    this.handleKeyRelease(16, n3);
                }
            } else if (n2 == 16) {
                --this.keyShift;
                if (this.keyShift > 0) {
                    return;
                }
            }
            this.handleKeyRelease(n2, n3);
        } else if (this.keytable[n2][2] < 1024) {
            this.handleKeyRelease(n2, n3);
        }
    }

    private int getNormalStick(int n) {
        switch (n) {
            case 104: {
                return 0;
            }
            case 98: 
            case 101: {
                return 1;
            }
            case 100: {
                return 2;
            }
            case 102: {
                return 3;
            }
            case 96: {
                return 4;
            }
        }
        return -1;
    }

    private void handleKeyPress(int n, int n2) {
        int n3 = this.keytable[n][0];
        int n4 = this.keytable[n][1];
        if (n3 != -1 && n4 != -1) {
            this.keyrow[n3] = this.keyrow[n3] & 255 - (1 << this.keytable[n][1]);
            this.keycol[n4] = this.keycol[n4] & 255 - (1 << this.keytable[n][0]);
        }
    }

    private void handleKeyRelease(int n, int n2) {
        int n3 = this.keytable[n][0];
        int n4 = this.keytable[n][1];
        if (n3 != -1 && n4 != -1) {
            this.keyrow[n3] = this.keyrow[n3] | 1 << this.keytable[n][1];
            this.keycol[n4] = this.keycol[n4] | 1 << this.keytable[n][0];
        }
        this.updateKeyboard();
    }

    int readDC00(int n) {
        int n2 = 255;
        int n3 = n < 65536 ? this.joy1 : 255;
        int n4 = (this.cia.ciaMemory[1] | ~this.cia.ciaMemory[3]) & n3;
        int n5 = 1;
        for (int i = 0; i < 8; ++i) {
            if ((n4 & n5) == 0) {
                n2 &= this.keycol[i];
            }
            n5 <<= 1;
        }
        n3 = n < 65536 ? this.joy2 : 255;
        return n2 & (this.cia.ciaMemory[0] | ~this.cia.ciaMemory[2]) & n3;
    }

    void setButtonval(int n) {
        this.bval = n;
        this.updateKeyboard();
    }

    int readDC01(int n) {
        int n2 = 255;
        int n3 = n < 65536 ? this.joy2 & this.bval : 255;
        int n4 = (this.cia.ciaMemory[0] | ~this.cia.ciaMemory[2]) & n3;
        int n5 = 1;
        for (int i = 0; i < 8; ++i) {
            if ((n4 & n5) == 0) {
                n2 &= this.keyrow[i];
            }
            n5 <<= 1;
        }
        n3 = n < 65536 ? this.joy1 & this.bval : 255;
        return n2 & (this.cia.ciaMemory[1] | ~this.cia.ciaMemory[3]) & n3;
    }

    void updateKeyboard() {
        int n = this.joystick1 & this.bval;
        if ((n & 3) == 0) {
            n = (n | 3) & 255 - (this.lastUp ? 1 : 2);
        }
        if ((n & 0xC) == 0) {
            n = (n | 0xC) & 255 - (this.lastLeft ? 4 : 8);
        }
        this.joy2 = this.stick == 68608 ? 255 : n;
        int n2 = this.joy1 = this.stick == 68608 ? n : 255;
        if (!this.ready && this.reads++ > 20) {
            this.ready = true;
            this.reads = 0;
        }
    }

    public void reset() {
        this.lastKey = 0;
        this.keyPressed = 0;
        this.keyShift = 0;
        this.joystick1 = 255;
        this.reads = 0;
        this.ready = false;
        for (int i = 0; i < 8; ++i) {
            this.keyrow[i] = 255;
            this.keycol[i] = 255;
        }
    }
}

