/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.c64utils.AutoStore;
import com.dreamfabric.jac64.C1541Emu;
import com.dreamfabric.jac64.DefaultIMon;
import com.dreamfabric.jac64.Hex;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Loader;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.PatchListener;

public class CPU
extends MOS6510Core {
    public static final int IO_OFFSET = 12288;
    public static final int BASIC_ROM2 = 106496;
    public static final int KERNAL_ROM2 = 122880;
    public static final int CHAR_ROM2 = 118784;
    public static final boolean EMULATE_1541 = true;
    public static final int CH_PROTECT = 1;
    public static final int CH_MONITOR_WRITE = 2;
    public static final int CH_MONITOR_READ = 4;
    private int romFlag = 40960;
    public boolean basicROM = true;
    public boolean kernalROM = true;
    public boolean charROM = false;
    public boolean ioON = true;
    public boolean running = true;
    public boolean exit = false;
    public boolean pause = false;
    private static final long CYCLES_PER_DEBUG = 10000000L;
    public static final boolean DEBUG = false;
    private C1541Emu c1541;
    private Loader loader;
    private int windex = 0;
    private int[] cheatMon;
    private AutoStore[] autoStore;

    public CPU(IMonitor iMonitor, String string, Loader loader) {
        super(iMonitor, string);
        this.memory = new int[131072];
        this.loader = loader;
        DefaultIMon defaultIMon = new DefaultIMon();
        this.c1541 = new C1541Emu(defaultIMon, string);
    }

    public C1541Emu getDrive() {
        return this.c1541;
    }

    protected final int fetchByte(int n) {
        this.chips.updateChips(this.cycles);
        while (this.baLowUntil > this.cycles) {
            this.cycles = this.baLowUntil;
            this.chips.updateChips(this.cycles);
        }
        if ((this.romFlag & n) == this.romFlag) {
            this.rindex = n | 0x10000;
            return this.memory[this.rindex];
        }
        if ((n & 0xF000) == 53248) {
            if (this.ioON) {
                this.rindex = n;
                return this.chips.performRead(this.rindex, this.cycles);
            }
            if (this.charROM) {
                this.rindex = n | 0x10000;
                return this.memory[this.rindex];
            }
            this.rindex = n;
            return this.memory[this.rindex];
        }
        this.rindex = n;
        return this.memory[this.rindex];
    }

    private void fixRindex(int n) {
        if (this.basicROM && (n & 0xE000) == 40960 || this.kernalROM && (n & 0xE000) == 57344 || this.charROM && (n & 0xF000) == 53248) {
            n |= 0x10000;
        }
        this.rindex = n;
    }

    public void poke(int n, int n2) {
        this.writeByte(n & 0xFFFF, n2 & 0xFF);
    }

    protected final void writeByte(int n, int n2) {
        this.chips.updateChips(this.cycles);
        if (n <= 1) {
            this.memory[n] = n2;
            int n3 = this.memory[0] ^ 0xFF | this.memory[1];
            this.kernalROM = (n3 & 2) == 2;
            this.basicROM = (n3 & 3) == 3;
            this.charROM = (n3 & 3) != 0 && (n3 & 4) == 0;
            boolean bl = this.ioON = (n3 & 3) != 0 && (n3 & 4) != 0;
            this.romFlag = this.basicROM ? 40960 : (this.kernalROM ? 57344 : 65536);
        }
        if (this.ioON && ((n &= 0xFFFF) & 0xF000) == 53248) {
            this.chips.performWrite(n, n2, this.cycles);
        } else {
            this.windex = n;
            this.memory[this.windex] = n2;
        }
    }

    public void patchROM(PatchListener patchListener) {
        this.list = patchListener;
        int n = 128158;
        this.memory[n++] = 32;
        this.memory[n++] = 210;
        this.memory[n++] = 245;
        System.out.println("Patched LOAD at: " + Hex.hex2(n));
        this.memory[n++] = 76;
        this.memory[n++] = 96;
    }

    public void runBasic() {
        this.memory[631] = 82;
        this.memory[632] = 85;
        this.memory[633] = 78;
        this.memory[634] = 13;
        this.memory[198] = 4;
    }

    public void enterText(String string) {
        int n;
        System.out.println("Entering text into textbuffer: " + string);
        string = string.toUpperCase();
        int n2 = string.length();
        int n3 = 0;
        int n4 = n2;
        for (n = 0; n < n4; ++n) {
            int n5 = string.charAt(n);
            if (n5 == 126) {
                n5 = 13;
            }
            this.memory[631 + n3] = n5;
            if (++n3 != 5) continue;
            this.memory[198] = n3;
            n3 = 0;
            int n6 = 5;
            while (n6 > 0 && this.memory[198] > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (--n6 != 0) continue;
                System.out.println("Buffer still full: " + this.memory[198]);
            }
        }
        this.memory[198] = n3;
        n = 5;
        while (n > 0 && this.memory[198] > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (--n != 0) continue;
            System.out.println("Buffer still full: " + this.memory[198]);
        }
    }

    protected void installROMS() {
        this.loadROM(this.loader.getResourceStream("/roms/kernal.c64"), 122880, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/basic.c64"), 106496, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/chargen.c64"), 118784, 4096);
    }

    public void run(int n) {
        this.reset();
        this.exit = false;
        this.running = true;
        this.setPC(n);
        this.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        while (!this.exit) {
            this.run(64738);
            if (this.pause) {
                while (this.pause) {
                    System.out.println("Entering pause mode...");
                    CPU cPU = this;
                    synchronized (cPU) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    System.out.println("Exiting pause mode...");
                    this.loop();
                }
                continue;
            }
            if (this.exit) continue;
            this.monitor.info("Resetting!!!!");
            this.reset();
        }
    }

    public synchronized void setPause(boolean bl) {
        if (bl) {
            this.pause = true;
            this.running = false;
        } else {
            this.pause = false;
            this.running = true;
        }
        this.notify();
    }

    public synchronized void stop() {
        this.running = false;
        this.pause = false;
        this.exit = true;
        this.notify();
    }

    public void reset() {
        this.running = false;
        this.exit = false;
        this.writeByte(1, 7);
        super.reset();
        this.c1541.reset();
    }

    public void setPC(int n) {
        this.pc = n;
    }

    public void loop() {
        if (this.cheatMon != null) {
            this.cheatLoop();
            return;
        }
        long l = this.cycles + 10000000L;
        this.monitor.info("Starting CPU at: " + Integer.toHexString(this.pc));
        try {
            while (this.running) {
                if (this.monitor.isEnabled() && this.baLowUntil <= this.cycles) {
                    this.fixRindex(this.pc);
                    this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
                }
                this.emulateOp();
                this.c1541.tick(this.cycles);
                ++this.nr_ins;
                if (l >= this.cycles) continue;
                long l2 = System.currentTimeMillis() - this.lastMillis;
                int n = this.monitor.getLevel();
                this.nr_irq = 0L;
                this.nr_ins = 0L;
                this.lastMillis = System.currentTimeMillis();
                l = this.cycles + 10000000L;
            }
        }
        catch (Exception exception) {
            this.monitor.error("Exception in loop " + this.pc + " : " + exception);
            exception.printStackTrace();
            this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
        }
    }

    public void setAutoStore(int n, AutoStore autoStore) {
        this.autoStore[n] = autoStore;
    }

    public AutoStore getAutoStore(int n) {
        return this.autoStore[n];
    }

    public void setCheatEnabled(int n) {
        this.cheatMon = new int[65536];
        this.autoStore = new AutoStore[n];
    }

    public void protect(int n, int n2) {
        this.cheatMon[n] = this.cheatMon[n] & 0xFF | n2 << 8 | 1;
    }

    public void monitorRead(int n) {
        int n2 = n;
        this.cheatMon[n2] = this.cheatMon[n2] | 4;
    }

    public void monitorWrite(int n) {
        int n2 = n;
        this.cheatMon[n2] = this.cheatMon[n2] | 2;
    }

    public void cheatLoop() {
        try {
            while (this.running) {
                int n;
                int n2;
                int n3;
                this.emulateOp();
                if (this.rindex < 65536 && (n3 = this.cheatMon[this.rindex]) != 0 && (n3 & 4) != 0) {
                    n2 = this.autoStore.length;
                    for (n = 0; n < n2; ++n) {
                        if (this.autoStore[n] == null) continue;
                        this.autoStore[n].checkRules(this.memory);
                    }
                }
                if (this.windex < 65536 && (n3 = this.cheatMon[this.windex]) != 0) {
                    if ((n3 & 1) != 0) {
                        this.memory[this.windex] = this.cheatMon[this.windex] >> 16 & 0xFF;
                    }
                    if ((n3 & 2) != 0) {
                        n2 = this.autoStore.length;
                        for (n = 0; n < n2; ++n) {
                            if (this.autoStore[n] == null) continue;
                            this.autoStore[n].checkRules(this.memory);
                        }
                    }
                }
                this.c1541.tick(this.cycles);
            }
        }
        catch (Exception exception) {
            this.monitor.error("Exception in loop " + this.pc + " : " + exception);
            exception.printStackTrace();
            this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
        }
    }
}

