/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C64Chips;
import com.dreamfabric.jac64.Hex;

public class CIA {
    public static final boolean TIMER_DEBUG = false;
    public static final boolean WRITE_DEBUG = false;
    public static final int PRA = 0;
    public static final int PRB = 1;
    public static final int DDRA = 2;
    public static final int DDRB = 3;
    public static final int TIMALO = 4;
    public static final int TIMAHI = 5;
    public static final int TIMBLO = 6;
    public static final int TIMBHI = 7;
    public static final int TODTEN = 8;
    public static final int TODSEC = 9;
    public static final int TODMIN = 10;
    public static final int TODHRS = 11;
    public static final int CIAICR = 13;
    public static final int CIACRA = 14;
    public static final int CIACRB = 15;
    boolean timersONA = false;
    boolean timersONB = false;
    int ta = 0;
    int tb = 0;
    int ciaicrRead;
    int timerATrigg = 0;
    int timerBTrigg = 0;
    boolean[] timersIRQ = new boolean[2];
    long nextTimersA = 0L;
    long nextTimersB = 0L;
    public static final int TIMER_B_DIV_MASK = 96;
    public static final int TIMER_B_DIV_VAL = 64;
    int timerBDiv = 1;
    int[] latchValue = new int[2];
    private static final int RELATCH_DELAY = 1;
    private static final int START_DELAY = 2;
    long nextUpdate = 0L;
    public long nextCIAUpdate = 0L;
    public int[] ciaMemory = new int[16];
    private int[] cpuMemory;
    private int offset;
    public int serialFake = 0;
    private C64Chips chips;
    private int lastTrigg = 0;

    public CIA(int[] nArray, int n, C64Chips c64Chips) {
        this.cpuMemory = nArray;
        this.offset = n;
        this.chips = c64Chips;
    }

    public void reset() {
        this.timerATrigg = 0;
        this.timerBTrigg = 0;
        this.timersONA = false;
        this.timersONB = false;
    }

    public String ciaID() {
        return this.offset == 68608 ? "CIA 1" : "CIA 2";
    }

    public int updateCIA(long l) {
        int n = 0;
        this.nextCIAUpdate += 37L;
        if (this.timersONA && this.nextTimersA <= l) {
            this.ciaicrRead |= 1;
            int n2 = this.timerATrigg = this.timersIRQ[0] ? 1 : 0;
            if ((this.ciaMemory[14] & 8) == 0) {
                this.nextTimersA = this.nextTimersA + (long)this.latchValue[0] + 1L;
            } else {
                this.timersONA = false;
                int n3 = this.offset + 14;
                this.cpuMemory[n3] = this.cpuMemory[n3] & 0xFE;
            }
        }
        if (this.timersONB && this.nextTimersB <= l) {
            this.ciaicrRead |= 2;
            int n4 = this.timerBTrigg = this.timersIRQ[1] ? 2 : 0;
            if ((this.ciaMemory[15] & 8) == 0) {
                this.nextTimersB = (this.ciaMemory[15] & 0x60) == 64 ? (this.nextTimersB += (long)(this.latchValue[1] * this.latchValue[0])) : (this.nextTimersB += (long)this.latchValue[1]);
                ++this.nextTimersB;
            } else {
                this.timersONB = false;
                int n5 = this.offset + 15;
                this.cpuMemory[n5] = this.cpuMemory[n5] & 0xFE;
            }
        }
        if ((n += this.timerATrigg + this.timerBTrigg) > 0) {
            this.ciaicrRead |= 0x80;
        }
        if (l > this.nextUpdate) {
            this.nextUpdate += 100000L;
            int n6 = (this.cpuMemory[this.offset + 8] & 0xF) + 1;
            this.cpuMemory[this.offset + 8] = n6 % 10;
            if (n6 > 9) {
                n6 = (this.cpuMemory[this.offset + 9] & 0x7F) + 1;
                if ((n6 & 0xF) > 9) {
                    n6 += 6;
                }
                if (n6 > 89) {
                    n6 = 0;
                }
                this.cpuMemory[this.offset + 9] = n6;
                if (n6 == 0) {
                    n6 = (this.cpuMemory[this.offset + 10] & 0x7F) + 1;
                    if ((n6 & 0xF) > 9) {
                        n6 += 6;
                    }
                    if (n6 > 89) {
                        n6 = 0;
                    }
                    this.cpuMemory[this.offset + 10] = n6;
                    if (n6 == 0) {
                        n6 = (this.cpuMemory[this.offset + 11] & 0x1F) + 1;
                        if ((n6 & 0xF) > 9) {
                            n6 += 6;
                        }
                        if (n6 > 17) {
                            n6 = 0;
                        }
                        this.cpuMemory[this.offset + 11] = n6;
                    }
                }
            }
        }
        if (this.timersONA && this.nextTimersA < this.nextCIAUpdate) {
            this.nextCIAUpdate = this.nextTimersA;
        }
        if (this.timersONB && this.nextTimersB < this.nextCIAUpdate) {
            this.nextCIAUpdate = this.nextTimersB;
        }
        return n;
    }

    public int performRead(int n, long l) {
        int n2 = this.cpuMemory[n];
        switch (n -= this.offset) {
            case 4: {
                if (this.timersONA) {
                    if (this.nextTimersA > l) {
                        return (int)(this.nextTimersA - l) & 0xFF;
                    }
                    return 0;
                }
                return this.ta & 0xFF;
            }
            case 5: {
                if (this.timersONA) {
                    if (this.nextTimersA > l) {
                        return (int)(this.nextTimersA - l) >> 8;
                    }
                    return 0;
                }
                return this.ta >> 8;
            }
            case 6: {
                if (this.timersONB) {
                    if (this.nextTimersB > l) {
                        return (int)(this.nextTimersB - l) & 0xFF;
                    }
                    return 0;
                }
                return this.tb & 0xFF;
            }
            case 7: {
                if (this.timersONB) {
                    if (this.nextTimersB > l) {
                        return (int)(this.nextTimersB - l) >> 8;
                    }
                    return 0;
                }
                return this.tb >> 8;
            }
            case 13: {
                n2 = this.ciaicrRead;
                this.ciaicrRead = 0;
                this.timerATrigg = 0;
                this.timerBTrigg = 0;
                if (this.offset == 68608) {
                    this.chips.clearIRQ(2);
                    break;
                }
                this.chips.clearNMI(2);
            }
        }
        return n2;
    }

    public void performWrite(int n, int n2, long l) {
        switch (n -= this.offset) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.latchValue[0] = this.latchValue[0] & 0xFF00 | n2;
                break;
            }
            case 5: {
                this.latchValue[0] = this.latchValue[0] & 0xFF | n2 << 8;
                break;
            }
            case 6: {
                this.latchValue[1] = this.latchValue[1] & 0xFF00 | n2;
                break;
            }
            case 7: {
                this.latchValue[1] = this.latchValue[1] & 0xFF | n2 << 8;
                break;
            }
            case 13: {
                boolean bl;
                boolean bl2 = bl = (n2 & 0x80) != 0;
                if ((n2 & 1) == 1) {
                    this.timersIRQ[0] = bl;
                }
                if ((n2 & 2) == 2) {
                    this.timersIRQ[1] = bl;
                }
                this.timerATrigg = 0;
                this.timerBTrigg = 0;
                this.ciaicrRead = 0;
                this.ciaMemory[13] = bl ? this.ciaMemory[13] | n2 & 0x7F : this.ciaMemory[13] & ~(n2 & 0x7F);
                return;
            }
            case 14: {
                if ((n2 & 0x10) != 0) {
                    this.latchValue[0] = this.ciaMemory[4] + (this.ciaMemory[5] << 8);
                    this.timerATrigg = 0;
                }
                if ((n2 & 1) == 1) {
                    this.timersONA = true;
                    this.timerATrigg = 0;
                    this.nextTimersA = l + (long)this.latchValue[0] + 2L;
                } else {
                    this.timersONA = false;
                    this.timerATrigg = 0;
                    this.ta = (int)(this.nextTimersA - l);
                    if (this.ta < 0) {
                        this.ta = 0;
                    }
                }
                if ((n2 & 2) == 0) break;
                this.println("******* Timer A shows on dc01 b6 - mode: " + (n2 & 4));
                break;
            }
            case 15: {
                if ((n2 & 0x10) != 0) {
                    this.latchValue[1] = this.ciaMemory[6] + (this.ciaMemory[7] << 8);
                    this.timerBTrigg = 0;
                }
                if ((n2 & 1) == 1) {
                    this.timersONB = true;
                    this.nextTimersB = l + (long)this.latchValue[1] + 2L;
                    this.timerBTrigg = 0;
                } else {
                    this.timersONB = false;
                    this.timerBTrigg = 0;
                    this.tb = (int)(this.nextTimersB - l);
                    if (this.tb < 0) {
                        this.tb = 0;
                    }
                }
                if ((n2 & 2) == 0) break;
                this.println("******* Timer B shows on dc01 b6 - mode: " + (n2 & 4));
            }
        }
        this.ciaMemory[n] = n2;
    }

    private void println(String string) {
        System.out.println(this.ciaID() + ": " + string);
    }

    public void printStatus() {
        System.out.println("--------------------------");
        this.println(" status");
        System.out.println("Timer A on: " + this.timersONA);
        System.out.println("Timer A next trigger: " + this.nextTimersA);
        System.out.println("CIA CRA: " + Hex.hex2(this.ciaMemory[14]) + " => " + ((this.ciaMemory[14] & 8) == 0 ? "cont" : "one-shot"));
        System.out.println("Timer A Interrupt: " + this.timerATrigg);
        System.out.println("Timer A Latch: " + this.latchValue[0]);
        System.out.println("Timer B on: " + this.timersONB);
        System.out.println("Timer B next trigger: " + this.nextTimersB);
        System.out.println("CIA CRB: " + Hex.hex2(this.ciaMemory[15]) + " => " + ((this.ciaMemory[15] & 8) == 0 ? "cont" : "one-shot"));
        System.out.println("Timer B Interrupt: " + this.timerBTrigg);
        System.out.println("Timer B Latch: " + this.latchValue[1]);
        System.out.println("--------------------------");
    }
}

