/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C1541Chips;
import com.dreamfabric.jac64.C64Canvas;
import com.dreamfabric.jac64.C64Chips;
import com.dreamfabric.jac64.CIA;
import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Keyboard;
import com.dreamfabric.jac64.Observer;
import com.dreamfabric.jac64.SID6581;
import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jac64.SIDMixerSE;
import com.dreamfabric.jac64.TFE_CS8900;
import com.dreamfabric.jac64.VICConstants;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class C64Screen
extends C64Chips
implements Observer,
MouseListener,
MouseMotionListener {
    public static final String version = "1.0";
    public static final int SERIAL_ATN = 8;
    public static final int SERIAL_CLK_OUT = 16;
    public static final int SERIAL_DATA_OUT = 32;
    public static final int SERIAL_CLK_IN = 64;
    public static final int SERIAL_DATA_IN = 128;
    public static final boolean IRQDEBUG = false;
    public static final boolean SPRITEDEBUG = false;
    public static final boolean IODEBUG = false;
    public static final boolean VIC_MEM_DEBUG = false;
    public static final boolean BAD_LINE_DEBUG = false;
    public static final boolean STATE_DEBUG = false;
    public static final boolean DEBUG_IEC = false;
    public static final boolean DEBUG_CYCLES = false;
    public static final int IO_UPDATE = 37;
    private static final int VIC_IRQ = 1;
    private static final int CIA_TIMER_IRQ = 2;
    private static final int CIA_TIMER_NMI = 2;
    public static final int CYCLES_PER_LINE = 63;
    public static final int IO_OFFSET = 12288;
    public static final boolean SOUND_AVAIABLE = true;
    public static final Color TRANSPARENT_BLACK = new Color(0, 0, 64, 64);
    public static final Color DARKER_0 = new Color(0, 0, 64, 32);
    public static final Color LIGHTER_0 = new Color(224, 224, 255, 48);
    public static final Color DARKER_N = new Color(0, 0, 64, 112);
    public static final Color LIGHTER_N = new Color(224, 224, 255, 160);
    public static final Color LED_ON = new Color(96, 223, 96, 192);
    public static final Color LED_OFF = new Color(32, 96, 32, 192);
    public static final Color LED_BORDER = new Color(64, 96, 64, 160);
    public static final int LABEL_COUNT = 32;
    private Color[] darks = new Color[32];
    private Color[] lites = new Color[32];
    private int colIndex = 0;
    private static final int SC_WIDTH = 384;
    private static final int SC_HEIGHT = 284;
    private final int SC_XOFFS = 32;
    private final int SC_SPXOFFS = 8;
    private final int FIRST_VISIBLE_VBEAM = 15;
    private final int SC_SPYOFFS = 16;
    private IMonitor monitor;
    private int targetScanTime = 20000;
    private int actualScanTime = 20000;
    private int sidUpdate = 1000;
    private long lastScan = 0L;
    private long nextIOUpdate = 0L;
    private boolean DOUBLE = false;
    private int reset = 100;
    private C64Canvas canvas;
    private int[] memory;
    private Keyboard keyboard;
    SID6581[] sid;
    SIDMixer mixer;
    CIA[] cia;
    C1541Chips c1541Chips;
    TFE_CS8900 tfe;
    int iecLines = 0;
    int cia2PRA = 0;
    int cia2DDRA = 0;
    AudioClip trackSound = null;
    AudioClip motorSound = null;
    private int lastTrack = 0;
    private int lastSector = 0;
    private boolean ledOn = false;
    private boolean motorOn = false;
    boolean emulateDisk = false;
    private int[] cbmcolor = VICConstants.COLOR_SETS[0];
    public int vicBank;
    public int charSet;
    public int videoMatrix;
    public int videoMode;
    private int vicBase = 0;
    private boolean badLine = false;
    private int spr0BlockSel;
    int vc = 0;
    int vcBase = 0;
    int rc = 0;
    int vmli = 0;
    int vPos = 0;
    int mpos = 0;
    int displayWidth = 384;
    int displayHeight = 284;
    int offsetX = 0;
    int offsetY = 0;
    boolean gfxVisible = false;
    boolean paintBorder = false;
    int borderColor = this.cbmcolor[0];
    int bgColor = this.cbmcolor[1];
    int irqMask = 0;
    int irqFlags = 0;
    boolean extended = false;
    boolean multiCol = false;
    boolean blankRow = false;
    boolean hideColumn = false;
    int[] multiColor = new int[4];
    int[] collissionMask = new int[432];
    Sprite[] sprites = new Sprite[8];
    private Color[] colors = null;
    private int horizScroll = 0;
    private int vScroll = 0;
    private Image image;
    private Graphics g2;
    private int charMemoryIndex = 0;
    private int[] vicCharCache = new int[40];
    private int[] vicColCache = new int[40];
    public int[] vicMemory = new int[4096];
    public Image screen = null;
    private MemoryImageSource mis = null;
    int[] mem = new int[112896];
    int rnd = 754;
    String message;
    String tmsg = "";
    int vbeam = 0;
    int frame = 0;
    boolean updating = false;
    boolean displayEnabled = true;
    boolean irqTriggered = false;
    long nextSID = 0L;
    long lastLine = 0L;
    long firstLine = 0L;
    long lastIRQ = 0L;
    int potx = 0;
    int poty = 0;
    boolean button1 = false;
    boolean button2 = false;
    int frq;
    private static final int[] IO_ADDRAND = new int[]{53311, 53311, 53311, 53311, 54303, 54303, 54303, 54303, 55551, 55807, 56063, 56319, 56335, 56591, 57087, 57343};
    int lastX = 0;
    int lastDLine = 0;
    byte vicState = 0;
    int oldDelta = 0;
    int xPos = 0;
    int lastSpriteRead = -2;
    long lastCycle = 0L;
    public static final int IMG_TOTWIDTH = 384;
    public static final int IMG_TOTHEIGHT = 284;
    public Image crtImage;
    long repaint = 0L;

    public C64Screen(IMonitor iMonitor, boolean bl) {
        this.monitor = iMonitor;
        this.DOUBLE = bl;
        this.setScanRate(50.0);
        this.makeColors(this.darks, DARKER_0, DARKER_N);
        this.makeColors(this.lites, LIGHTER_0, LIGHTER_N);
    }

    public void setAutoscale(boolean bl) {
        this.DOUBLE = bl;
        this.canvas.setAutoscale(bl);
    }

    private void makeColors(Color[] colorArray, Color color, Color color2) {
        int n = color.getAlpha();
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = color2.getAlpha();
        int n6 = color2.getRed();
        int n7 = color2.getGreen();
        int n8 = color2.getBlue();
        int n9 = 16;
        int n10 = n9;
        for (int i = 0; i < n10; ++i) {
            Color color3 = new Color(((n9 - i) * n2 + i * n6) / n9, ((n9 - i) * n3 + i * n7) / n9, ((n9 - i) * n4 + i * n8) / n9, ((n9 - i) * n + i * n5) / n9);
            colorArray[32 - i - 1] = color3;
            colorArray[i] = color3;
        }
    }

    public void setColorSet(int n) {
        if (n >= 0 && n < VICConstants.COLOR_SETS.length) {
            this.cbmcolor = VICConstants.COLOR_SETS[n];
        }
    }

    public SIDMixer getMixer() {
        return this.mixer;
    }

    public SID6581[] getSIDs() {
        return this.sid;
    }

    public CIA[] getCIAs() {
        return this.cia;
    }

    public void setScanRate(double d) {
        this.targetScanTime = (int)(1000000.0 / d);
        float f = 0.9692308f;
        this.sidUpdate = (int)((double)(f * 1000.0f) * d / 50.0);
    }

    public int getScanRate() {
        return 1000000 / this.targetScanTime;
    }

    public int getActualScanRate() {
        return 1000000 / this.actualScanTime;
    }

    public void setIntegerScaling(boolean bl) {
        this.canvas.setIntegerScaling(bl);
    }

    public JPanel getScreen() {
        return this.canvas;
    }

    public boolean ready() {
        return this.keyboard.ready;
    }

    public void setDisplayFactor(double d) {
        this.displayWidth = (int)(384.0 * d);
        this.displayHeight = (int)(284.0 * d);
        this.crtImage = null;
    }

    public void setDisplayOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    public void dumpGfxStat() {
        this.monitor.info("Char MemoryIndex: 0x" + Integer.toString(this.charMemoryIndex, 16));
        this.monitor.info("CharSet adr: 0x" + Integer.toString(this.charSet, 16));
        this.monitor.info("VideoMode: " + this.videoMode);
        this.monitor.info("Vic Bank: 0x" + Integer.toString(this.vicBank, 16));
        this.monitor.info("Video Matrix: 0x" + Integer.toString(this.videoMatrix, 16));
        this.monitor.info("Text: extended = " + this.extended + " multicol = " + this.multiCol);
        this.monitor.info("24 Rows on? " + ((this.memory[65553] & 8) == 0 ? "yes" : "no"));
        this.monitor.info("YScroll = " + (this.memory[65553] & 7));
        this.monitor.info("d011 = " + this.memory[65553]);
        this.monitor.info("IRQ Latch: " + Integer.toString(this.memory[65561], 16));
        this.monitor.info("IRQ  Mask: " + Integer.toString(this.memory[65562], 16));
        this.monitor.info("IRQ RPos : " + (this.vicMemory[18] + ((this.vicMemory[17] & 0x80) << 1)));
        int n = 8;
        for (int i = 0; i < n; ++i) {
            this.monitor.info("Sprite " + (i + 1) + " pos = " + (this.memory[65536 + i * 2] + ((this.memory[65552] & 1 << i) != 0 ? 256 : 0)) + ", " + this.memory[65536 + i * 2 + 1]);
        }
        this.monitor.info("IRQFlags: " + this.getIRQFlags());
        this.monitor.info("NMIFlags: " + this.getNMIFlags());
    }

    public void setSoundOn(boolean bl) {
        this.mixer.setSoundOn(bl);
    }

    public void setStick(boolean bl) {
        this.keyboard.setStick(bl);
    }

    public void registerHotKey(int n, int n2, String string, Object object) {
        this.keyboard.registerHotKey(n, n2, string, object);
    }

    public void setKeyboardEmulation(boolean bl) {
        this.monitor.info("Keyboard extended: " + bl);
        this.keyboard.stickExits = !bl;
        this.keyboard.extendedKeyboardEmulation = bl;
    }

    public void init(CPU cPU) {
        super.init(cPU);
        this.memory = cPU.getMemory();
        this.c1541Chips = cPU.getDrive().chips;
        this.c1541Chips.initIEC2(this);
        this.c1541Chips = cPU.getDrive().chips;
        this.c1541Chips.setObserver(this);
        int n = this.sprites.length;
        for (int i = 0; i < n; ++i) {
            this.sprites[i] = new Sprite();
            this.sprites[i].spriteNo = i;
        }
        this.cia = new CIA[2];
        this.cia[0] = new CIA(this.memory, 68608, this);
        this.cia[1] = new CIA(this.memory, 68864, this);
        this.tfe = new TFE_CS8900(69120);
        this.keyboard = new Keyboard(this, this.cia[0], this.memory);
        this.canvas = new C64Canvas(this, this.DOUBLE, this.keyboard);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addMouseListener(this);
        try {
            this.sid = new SID6581[3];
            this.sid[0] = new SID6581(this.memory, 66560);
            this.sid[0].init();
            this.sid[1] = new SID6581(this.memory, 66567);
            this.sid[1].init();
            this.sid[2] = new SID6581(this.memory, 66574);
            this.sid[2].init();
            this.sid[0].next = this.sid[2];
            this.sid[1].next = this.sid[0];
            this.sid[2].next = this.sid[1];
            this.mixer = new SIDMixerSE(this.sid, null);
        }
        catch (Throwable throwable) {
            this.monitor.error("Error while initializing SID chip" + throwable);
            this.sid = null;
        }
        this.charMemoryIndex = 118784;
        for (int i = 0; i < 109056; ++i) {
            this.mem[i] = this.cbmcolor[6];
        }
        this.mis = new MemoryImageSource(384, 284, this.mem, 0, 384);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
        this.screen = this.canvas.createImage(this.mis);
        this.initUpdate();
    }

    public void update(Object object, Object object2) {
        if (object != this.c1541Chips) {
            this.message = (String)object2;
        } else {
            this.updateDisk(object, object2);
        }
    }

    void restoreKey(boolean bl) {
        if (bl) {
            this.setNMI(1);
        } else {
            this.clearNMI(1);
        }
    }

    public int performRead(int n, long l) {
        int n2 = n >> 8 & 0xF;
        int n3 = this.memory[(n &= IO_ADDRAND[n2]) + 12288];
        switch (n) {
            case 53278: 
            case 53279: {
                n3 = this.vicMemory[n & 0xFF];
                this.vicMemory[n & 0xFF] = 0;
                return n3;
            }
            case 53273: {
                return this.irqFlags;
            }
            case 53274: {
                return this.irqMask;
            }
            case 54299: {
                return this.sid[2].lastSample() & 0xFF;
            }
            case 54300: {
                return this.sid[2].adsrVol & 0xFF;
            }
            case 54297: {
                this.memory[66585] = this.potx;
                break;
            }
            case 54298: {
                this.memory[66586] = this.poty;
                break;
            }
            case 56320: {
                return this.keyboard.readDC00(this.cpu.lastReadOP);
            }
            case 56321: {
                return this.keyboard.readDC01(this.cpu.lastReadOP);
            }
            case 56576: {
                n3 = (this.cia2PRA | ~this.cia2DDRA) & 0x3F | this.iecLines & this.c1541Chips.iecLines;
                return n3 &= 0xFF;
            }
        }
        if (n2 == 13) {
            return this.cia[1].performRead(n + 12288, l);
        }
        if (n2 == 12) {
            return this.cia[0].performRead(n + 12288, l);
        }
        if (n2 == 14) {
            return this.tfe.performRead(n, l);
        }
        return n3;
    }

    public void updateCIA(long l) {
        int n = 0;
        if (this.nextIOUpdate < l) {
            n = this.ioTic();
            if (n != 0) {
                if ((n & 1) == 1) {
                    this.setIRQ(2);
                }
                if ((n & 2) == 2) {
                    this.setNMI(2);
                }
            } else {
                this.clearIRQ(2);
                this.clearNMI(2);
            }
            this.nextIOUpdate += 37L;
        }
        if (this.nextIOUpdate > this.cia[0].nextCIAUpdate) {
            this.nextIOUpdate = this.cia[0].nextCIAUpdate;
        }
        if (this.nextIOUpdate > this.cia[1].nextCIAUpdate) {
            this.nextIOUpdate = this.cia[1].nextCIAUpdate;
        }
    }

    public void performWrite(int n, int n2, long l) {
        int n3 = n >> 8 & 0xF;
        this.memory[(n &= C64Screen.IO_ADDRAND[n3]) + 12288] = n2;
        switch (n += 12288) {
            case 66564: {
                this.sid[0].setControl(n2, this.cpu.cycles);
                break;
            }
            case 66565: {
                this.sid[0].setAD(n2, this.cpu.cycles);
                break;
            }
            case 66566: {
                this.sid[0].setSR(n2, this.cpu.cycles);
                break;
            }
            case 66562: 
            case 66563: {
                this.sid[0].updatePulseWidth(l);
                break;
            }
            case 66571: {
                this.sid[1].setControl(n2, this.cpu.cycles);
                break;
            }
            case 66572: {
                this.sid[1].setAD(n2, this.cpu.cycles);
                break;
            }
            case 66573: {
                this.sid[1].setSR(n2, this.cpu.cycles);
                break;
            }
            case 66569: 
            case 66570: {
                this.sid[1].updatePulseWidth(l);
                break;
            }
            case 66578: {
                this.sid[2].setControl(n2, this.cpu.cycles);
                break;
            }
            case 66579: {
                this.sid[2].setAD(n2, this.cpu.cycles);
                break;
            }
            case 66580: {
                this.sid[2].setSR(n2, this.cpu.cycles);
                break;
            }
            case 66576: 
            case 66577: {
                this.sid[2].updatePulseWidth(l);
                break;
            }
            case 66581: {
                this.mixer.setFilterCutoffLO(n2 & 7);
                break;
            }
            case 66582: {
                this.mixer.setFilterCutoffHI(n2);
                break;
            }
            case 66583: {
                this.mixer.setFilterResonance(n2 >> 4);
                this.mixer.setFilterOn(n2 & 0xF);
                break;
            }
            case 66584: {
                this.mixer.setVolume(n2 & 0xF, this.cpu.cycles);
                this.mixer.setFilterCtrl(n2);
                break;
            }
            case 65536: 
            case 65538: 
            case 65540: 
            case 65542: 
            case 65544: 
            case 65546: 
            case 65548: 
            case 65550: {
                int n4 = n - 12288 - 53248 >> 1;
                this.sprites[n4].x &= 0x100;
                this.sprites[n4].x += n2;
                break;
            }
            case 65552: {
                int n5 = 0;
                int n6 = 1;
                int n7 = 8;
                while (n5 < n7) {
                    this.sprites[n5].x &= 0xFF;
                    this.sprites[n5].x = this.sprites[n5].x | ((n2 & n6) != 0 ? 256 : 0);
                    ++n5;
                    n6 <<= 1;
                }
                break;
            }
            case 65553: {
                this.vicMemory[17] = n2;
                if (this.vScroll != (n2 & 7)) {
                    this.vScroll = n2 & 7;
                    boolean bl = this.badLine;
                    this.badLine = this.displayEnabled && this.vbeam >= 48 && this.vbeam <= 247 && (this.vbeam & 7) == this.vScroll;
                }
                this.extended = (n2 & 0x40) != 0;
                this.blankRow = (n2 & 8) == 0;
                this.videoMode = (this.extended ? 2 : 0) | (this.multiCol ? 1 : 0) | ((n2 & 0x20) != 0 ? 4 : 0);
                this.memory[65553] = this.memory[65553] & 0x7F | (this.vbeam & 0x100) >> 1;
                break;
            }
            case 65554: {
                this.vicMemory[18] = n2;
                this.memory[n] = this.vbeam & 0xFF;
                break;
            }
            case 65557: {
                int n8 = 0;
                int n9 = 1;
                int n10 = 8;
                while (n8 < n10) {
                    this.sprites[n8].enabled = (n2 & n9) != 0;
                    ++n8;
                    n9 <<= 1;
                }
                break;
            }
            case 65558: {
                this.horizScroll = n2 & 7;
                this.multiCol = (n2 & 0x10) != 0;
                this.hideColumn = (n2 & 8) == 0;
                this.videoMode = (this.extended ? 2 : 0) | (this.multiCol ? 1 : 0) | ((this.memory[65553] & 0x20) != 0 ? 4 : 0);
                break;
            }
            case 65559: {
                int n11 = 0;
                int n12 = 1;
                int n13 = 8;
                while (n11 < n13) {
                    this.sprites[n11].expandY = (n2 & n12) != 0;
                    ++n11;
                    n12 <<= 1;
                }
                break;
            }
            case 65561: {
                if ((n2 & 0x80) != 0) {
                    n2 = 255;
                }
                int n14 = 0xFF ^ n2;
                this.irqFlags &= n14;
                this.vicMemory[25] = this.memory[n] = this.irqFlags;
                if ((this.irqMask & 0xF & this.irqFlags) != 0) break;
                this.clearIRQ(1);
                break;
            }
            case 65562: {
                this.irqMask = n2;
                if ((this.irqMask & 0xF & this.irqFlags) != 0) {
                    this.irqFlags |= 0x80;
                    this.setIRQ(1);
                    break;
                }
                this.clearIRQ(1);
                break;
            }
            case 65565: {
                int n15 = 0;
                int n16 = 1;
                int n17 = 8;
                while (n15 < n17) {
                    this.sprites[n15].expandX = (n2 & n16) != 0;
                    ++n15;
                    n16 <<= 1;
                }
                break;
            }
            case 65563: {
                int n18 = 0;
                int n19 = 1;
                int n20 = 8;
                while (n18 < n20) {
                    this.sprites[n18].priority = (n2 & n19) != 0;
                    ++n18;
                    n19 <<= 1;
                }
                break;
            }
            case 65564: {
                int n21 = 0;
                int n22 = 1;
                int n23 = 8;
                while (n21 < n23) {
                    this.sprites[n21].multicolor = (n2 & n22) != 0;
                    ++n21;
                    n22 <<= 1;
                }
                break;
            }
            case 65568: {
                this.borderColor = this.cbmcolor[n2 & 0xF];
                int n24 = 12288 + n;
                this.memory[n24] = this.memory[n24] | 0xF0;
                break;
            }
            case 65569: {
                this.bgColor = this.cbmcolor[n2 & 0xF];
                int n25 = 8;
                for (int i = 0; i < n25; ++i) {
                    this.sprites[i].color[0] = this.bgColor;
                }
                int n26 = 12288 + n;
                this.memory[n26] = this.memory[n26] | 0xF0;
                break;
            }
            case 65573: {
                int n27 = 8;
                for (int i = 0; i < n27; ++i) {
                    this.sprites[i].color[1] = this.cbmcolor[n2 & 0xF];
                }
                int n28 = 12288 + n;
                this.memory[n28] = this.memory[n28] | 0xF0;
                break;
            }
            case 65574: {
                int n29 = 8;
                for (int i = 0; i < n29; ++i) {
                    this.sprites[i].color[3] = this.cbmcolor[n2 & 0xF];
                }
                int n30 = 12288 + n;
                this.memory[n30] = this.memory[n30] | 0xF0;
                break;
            }
            case 65575: {
                this.sprites[0].color[2] = this.cbmcolor[n2 & 0xF];
                int n31 = 12288 + n;
                this.memory[n31] = this.memory[n31] | 0xF0;
                break;
            }
            case 65576: {
                this.sprites[1].color[2] = this.cbmcolor[n2 & 0xF];
                int n32 = 12288 + n;
                this.memory[n32] = this.memory[n32] | 0xF0;
                break;
            }
            case 65577: {
                this.sprites[2].color[2] = this.cbmcolor[n2 & 0xF];
                int n33 = 12288 + n;
                this.memory[n33] = this.memory[n33] | 0xF0;
                break;
            }
            case 65578: {
                this.sprites[3].color[2] = this.cbmcolor[n2 & 0xF];
                int n34 = 12288 + n;
                this.memory[n34] = this.memory[n34] | 0xF0;
                break;
            }
            case 65579: {
                this.sprites[4].color[2] = this.cbmcolor[n2 & 0xF];
                int n35 = 12288 + n;
                this.memory[n35] = this.memory[n35] | 0xF0;
                break;
            }
            case 65580: {
                this.sprites[5].color[2] = this.cbmcolor[n2 & 0xF];
                int n36 = 12288 + n;
                this.memory[n36] = this.memory[n36] | 0xF0;
                break;
            }
            case 65581: {
                this.sprites[6].color[2] = this.cbmcolor[n2 & 0xF];
                int n37 = 12288 + n;
                this.memory[n37] = this.memory[n37] | 0xF0;
                break;
            }
            case 65582: {
                this.sprites[7].color[2] = this.cbmcolor[n2 & 0xF];
                int n38 = 12288 + n;
                this.memory[n38] = this.memory[n38] | 0xF0;
                break;
            }
            case 68608: 
            case 68609: 
            case 68610: 
            case 68611: {
                this.cia[0].performWrite(n, n2, this.cpu.cycles);
                this.keyboard.updateKeyboard();
                break;
            }
            case 68864: {
                this.cia[1].performWrite(n, n2, this.cpu.cycles);
                this.setVideoMem();
                this.cia2PRA = n2;
                n2 = ~this.cia2PRA & this.cia2DDRA;
                int n39 = this.iecLines;
                this.iecLines = n2 << 2 & 0x80 | n2 << 2 & 0x40 | n2 << 1 & 0x10;
                if (((n39 ^ this.iecLines) & 0x10) != 0) {
                    this.c1541Chips.atnChanged((this.iecLines & 0x10) == 0);
                }
                this.c1541Chips.updateIECLines();
                break;
            }
            case 68866: {
                this.cia2DDRA = n2;
                this.cia[1].performWrite(n, n2, this.cpu.cycles);
                break;
            }
            case 65560: {
                this.memory[n] = n2;
                this.setVideoMem();
                break;
            }
            default: {
                if (n3 == 13) {
                    this.cia[1].performWrite(n, n2, l);
                    break;
                }
                if (n3 == 12) {
                    this.cia[0].performWrite(n, n2, l);
                    break;
                }
                if (n3 != 14) break;
                this.tfe.performWrite(n, n2, l);
            }
        }
    }

    private void printIECLines() {
        System.out.print("IEC/F: ");
        if ((this.iecLines & 0x10) == 0) {
            System.out.print("A1");
        } else {
            System.out.print("A0");
        }
        int n = (this.iecLines & 0x40) == 0 ? 1 : 0;
        System.out.print(" C" + n);
        n = (this.iecLines & 0x80) == 0 ? 1 : 0;
        System.out.print(" D" + n);
        n = (this.c1541Chips.iecLines & 0x40) == 0 ? 1 : 0;
        System.out.print(" c" + n);
        n = (this.c1541Chips.iecLines & 0x80) == 0 ? 1 : 0;
        System.out.print(" d" + n);
        System.out.println(" => C" + ((this.iecLines & this.c1541Chips.iecLines & 0x80) == 0 ? 1 : 0) + " D" + ((this.iecLines & this.c1541Chips.iecLines & 0x40) == 0 ? 1 : 0));
    }

    private void setVideoMem() {
        this.vicBank = (~(this.memory[68864] | ~this.memory[68866]) & 3) << 14;
        this.charSet = this.vicBank | (this.memory[65560] & 0xE) << 10;
        this.videoMatrix = this.vicBank | (this.memory[65560] & 0xF0) << 6;
        this.vicBase = this.vicBank | (this.memory[65560] & 8) << 10;
        this.spr0BlockSel = 1016 + this.videoMatrix;
        this.charMemoryIndex = (this.memory[65560] & 0xC) != 4 || (this.vicBank & 0x4000) == 16384 ? this.charSet : ((this.memory[65560] & 2) == 0 ? 0 : 2048) + 118784;
    }

    public int ioTic() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.cia[1].updateCIA(this.cpu.cycles) > 0) {
            bl2 = true;
        } else if (this.cia[0].updateCIA(this.cpu.cycles) > 0) {
            bl = true;
        }
        return bl2 ? 2 : (bl ? 1 : 0);
    }

    private void initUpdate() {
        int n;
        this.vc = 0;
        this.vcBase = 0;
        this.vmli = 0;
        this.updating = true;
        for (n = 0; n < 8; ++n) {
            this.sprites[n].nextByte = 0;
            this.sprites[n].painting = false;
            this.sprites[n].spriteReg = 0;
        }
        if (this.colors == null) {
            this.colors = new Color[16];
            for (n = 0; n < 16; ++n) {
                this.colors[n] = new Color(this.cbmcolor[n]);
            }
        }
        this.canvas.setBackground(this.colors[this.memory[65568] & 0xF]);
    }

    public final void updateChips(long l) {
        if (l > this.nextIOUpdate) {
            this.updateCIA(l);
        }
        int n = (int)(l - this.lastLine);
        if (this.badLine) {
            this.gfxVisible = true;
        }
        switch (this.vicState) {
            case 0: {
                int n2;
                this.vbeam = (this.vbeam + 1) % 312;
                if (this.vbeam == 0) {
                    ++this.frame;
                }
                this.vPos = this.vbeam - 16;
                if (this.vbeam == 15) {
                    ++this.colIndex;
                    if (this.colIndex >= 32) {
                        this.colIndex = 0;
                    }
                    this.initUpdate();
                }
                if ((this.irqMask & 2) != 0 && this.vicMemory[31] != 0 && (this.irqFlags & 2) == 0) {
                    this.irqFlags |= 0x52;
                    this.setIRQ(1);
                }
                if ((this.irqMask & 4) != 0 && this.vicMemory[30] != 0 && (this.irqFlags & 4) == 0) {
                    this.irqFlags |= 0x54;
                    this.setIRQ(1);
                }
                this.memory[65554] = this.vbeam & 0xFF;
                this.memory[65553] = this.memory[65553] & 0x7F | (this.vbeam & 0x100) >> 1;
                int n3 = ((this.vicMemory[17] & 0x80) << 1) + this.vicMemory[18];
                if (n3 > 312) {
                    n3 &= 0xFF;
                }
                if ((this.irqFlags & 1) == 0 && n3 == this.vbeam) {
                    this.irqFlags |= 1;
                    if ((this.irqMask & 1) != 0) {
                        this.irqFlags |= 0x80;
                        this.irqTriggered = true;
                        this.setIRQ(1);
                        this.lastIRQ = this.cpu.cycles;
                    }
                } else {
                    this.irqTriggered = false;
                }
                if (this.vPos < 0 || this.vPos >= 284) {
                    this.cpu.baLowUntil = 0L;
                    this.vicState = (byte)63;
                    break;
                }
                if (this.vbeam == 48) {
                    this.displayEnabled = (this.memory[65553] & 0x10) != 0;
                }
                this.badLine = this.displayEnabled && this.vbeam >= 48 && this.vbeam <= 247 && (this.vbeam & 7) == this.vScroll;
                this.lastX = 0;
                int n4 = 384;
                for (n2 = 0; n2 < n4; ++n2) {
                    this.collissionMask[n2] = 0;
                }
            }
            case 1: {
                if (n < 1) {
                    this.vicState = 1;
                    break;
                }
                if (this.sprites[3].dma) {
                    this.sprites[3].readSpriteData();
                }
                if (this.sprites[5].dma) {
                    this.cpu.baLowUntil = this.lastLine + 6L;
                }
            }
            case 3: {
                if (n < 3) {
                    this.vicState = (byte)3;
                    break;
                }
                if (this.sprites[4].dma) {
                    this.sprites[4].readSpriteData();
                }
                if (this.sprites[6].dma) {
                    this.cpu.baLowUntil = this.lastLine + 8L;
                }
            }
            case 5: {
                if (n < 5) {
                    this.vicState = (byte)5;
                    break;
                }
                if (this.sprites[5].dma) {
                    this.sprites[5].readSpriteData();
                }
                if (this.sprites[7].dma) {
                    this.cpu.baLowUntil = this.lastLine + 10L;
                }
            }
            case 7: {
                if (n < 7) {
                    this.vicState = (byte)7;
                    break;
                }
                if (this.sprites[6].dma) {
                    this.sprites[6].readSpriteData();
                }
            }
            case 9: {
                int n2;
                int n4;
                if (n < 9) {
                    this.vicState = (byte)9;
                    break;
                }
                if (this.sprites[7].dma) {
                    this.sprites[7].readSpriteData();
                }
                if (this.blankRow) {
                    if (this.vbeam == 247) {
                        this.paintBorder = true;
                    }
                } else {
                    if (this.vbeam == 251) {
                        this.paintBorder = true;
                    }
                    if (this.vbeam == 51) {
                        this.paintBorder = false;
                        n4 = 7;
                        for (n2 = 0; n2 < n4; ++n2) {
                            if (this.sprites[n2].painting) continue;
                            this.sprites[n2].lineFinished = true;
                        }
                    }
                }
                if (this.vbeam == 55) {
                    this.paintBorder = false;
                    n4 = 7;
                    for (n2 = 0; n2 < n4; ++n2) {
                        if (this.sprites[n2].painting) continue;
                        this.sprites[n2].lineFinished = true;
                    }
                }
            }
            case 12: {
                if (n < 11) {
                    this.vicState = (byte)12;
                    break;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                }
            }
            case 14: {
                if (n < 13) {
                    this.vicState = (byte)14;
                    break;
                }
                this.mpos = this.vPos * 384;
                this.paintBorder(this.mpos, 16);
                this.mpos += 16;
                this.vc = this.vcBase;
                this.vmli = 0;
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.rc = 0;
                }
            }
            case 15: {
                int n2;
                if (n < 15) {
                    this.vicState = (byte)15;
                    break;
                }
                this.paintBorder(this.mpos, 16);
                this.mpos += 16;
                int n4 = 8;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.sprites[n2].nextByte != 63) continue;
                    this.sprites[n2].dma = false;
                }
            }
            case 17: {
                int n2;
                if (n < 16) {
                    this.vicState = (byte)17;
                    break;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[0] = this.memory[this.videoMatrix + (this.vcBase & 0x3FF)];
                    this.vicColCache[0] = this.memory[67584 + (this.vcBase & 0x3FF)];
                }
                int n4 = this.horizScroll;
                for (n2 = 0; n2 < n4; ++n2) {
                    this.mem[this.mpos + n2] = this.bgColor;
                }
                this.drawGraphics(this.mpos + this.horizScroll, 1);
                if (this.hideColumn) {
                    this.paintBorder(this.mpos, 8);
                }
                this.mpos += 8;
                this.oldDelta = 16;
                this.xPos = 40;
                this.vicState = (byte)18;
                if (n == 16) break;
            }
            case 18: {
                int n4;
                int n2 = n - this.oldDelta;
                this.oldDelta = n;
                if (this.vmli + n2 > 40) {
                    n2 = 40 - this.vmli;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    for (n4 = this.vmli; n4 < this.vmli + n2; ++n4) {
                        this.vicCharCache[n4] = this.memory[this.videoMatrix + (this.vcBase + n4 & 0x3FF)];
                        this.vicColCache[n4] = this.memory[67584 + (this.vcBase + n4 & 0x3FF)];
                    }
                }
                this.drawGraphics(this.mpos + this.horizScroll, n2);
                if (!this.paintBorder) {
                    this.drawSprites(this.lastX, this.xPos);
                }
                this.lastX = this.xPos;
                this.xPos += n2 << 3;
                this.mpos += n2 << 3;
                if (this.vmli < 40) {
                    if (n < 54) break;
                    n4 = 1;
                    int n5 = 0;
                    int n6 = this.vPos + 16;
                    int n7 = 8;
                    for (int i = 0; i < n7; ++i) {
                        Sprite sprite = this.sprites[i];
                        if (sprite.enabled && (n5 = this.memory[65537 + i * 2]) == (n6 & 0xFF) && n6 < 270) {
                            sprite.nextByte = 0;
                            sprite.dma = true;
                            sprite.expFlipFlop = true;
                        }
                        n4 <<= 1;
                    }
                    if (!this.sprites[0].dma) break;
                    this.cpu.baLowUntil = this.lastLine + 59L;
                    break;
                }
                if (!this.paintBorder) {
                    this.drawSprites(this.lastX, this.xPos);
                }
            }
            case 57: {
                Sprite sprite;
                int n4;
                if (n < 56) {
                    this.vicState = (byte)57;
                    break;
                }
                if (this.hideColumn) {
                    this.paintBorder(this.mpos - 8, 8);
                }
                int n8 = 8;
                for (n4 = 0; n4 < n8; ++n4) {
                    sprite = this.sprites[n4];
                    if (sprite.dma) continue;
                    sprite.painting = false;
                }
                if (this.sprites[1].dma) {
                    this.cpu.baLowUntil = this.lastLine + 61L;
                }
            }
            case 58: {
                Sprite sprite;
                int n4;
                if (n < 57) {
                    this.vicState = (byte)58;
                    break;
                }
                int n8 = 8;
                for (n4 = 0; n4 < n8; ++n4) {
                    sprite = this.sprites[n4];
                    if (!sprite.dma) continue;
                    sprite.painting = true;
                }
                if (this.rc == 7) {
                    this.vcBase = this.vc;
                    this.gfxVisible = false;
                }
                if (this.badLine || this.gfxVisible) {
                    this.rc = this.rc + 1 & 7;
                    this.gfxVisible = true;
                }
                this.paintBorder(this.mpos, 16);
                this.mpos += 16;
                if (this.sprites[0].painting) {
                    this.sprites[0].readSpriteData();
                }
                if (this.sprites[2].dma) {
                    this.cpu.baLowUntil = this.lastLine + 63L;
                }
            }
            case 60: {
                if (n < 59) {
                    this.vicState = (byte)60;
                    break;
                }
                this.paintBorder(this.mpos, 16);
                this.mpos += 16;
                if (this.sprites[1].painting) {
                    this.sprites[1].readSpriteData();
                }
            }
            case 62: {
                if (n < 61) {
                    this.vicState = (byte)62;
                    break;
                }
                if (this.sprites[2].painting) {
                    this.sprites[2].readSpriteData();
                }
                if (this.sprites[3].dma) {
                    this.cpu.baLowUntil = this.lastLine + 65L;
                }
                this.vicState = (byte)63;
            }
            case 63: {
                if (n < 62) break;
                this.lastLine += 63L;
                if (this.updating && this.vPos == 285) {
                    this.mis.newPixels();
                    this.canvas.repaint();
                    this.actualScanTime = (this.actualScanTime * 9 + (int)(this.mixer.getMicros() - this.lastScan)) / 10;
                    this.lastScan = this.mixer.getMicros();
                    this.updating = false;
                }
                if (l > this.nextSID) {
                    this.mixer.updateSound(l);
                    this.nextSID += (long)this.sidUpdate;
                    if (this.nextSID < this.cpu.cycles) {
                        this.nextSID = this.cpu.cycles + 10L;
                    }
                }
                this.vicState = 0;
                if (n <= 62) break;
                this.updateChips(l);
            }
        }
    }

    private final void paintBorder(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.mem[n++] = this.borderColor;
        }
    }

    private final void drawGraphics(int n, int n2) {
        if (!this.gfxVisible || this.paintBorder) {
            int n3 = n + (n2 << 3);
            for (int i = n -= this.horizScroll; i < n3; ++i) {
                this.mem[i] = this.borderColor;
            }
            this.vmli += n2;
            return;
        }
        int n4 = this.vmli + n2;
        if (n4 > 40) {
            n4 = 40;
        }
        int n5 = (this.vmli << 3) + this.horizScroll + 32;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.bgColor;
        if ((this.memory[65553] & 0x20) == 0) {
            if (this.multiCol) {
                this.multiColor[0] = this.bgColor;
                this.multiColor[1] = this.cbmcolor[this.memory[65570] & 0xF];
                this.multiColor[2] = this.cbmcolor[this.memory[65571] & 0xF];
            }
            while (this.vmli < n4) {
                int n10;
                int n11 = this.vicColCache[this.vmli] & 0xF;
                n8 = this.cbmcolor[n11];
                if (this.extended) {
                    n7 = this.vicCharCache[this.vmli];
                    n6 = this.charMemoryIndex + ((n7 & 0x3F) << 3);
                    n9 = this.cbmcolor[this.memory[65569 + (n7 >> 6)] & 0xF];
                } else {
                    n6 = this.charMemoryIndex + (this.vicCharCache[this.vmli] << 3);
                }
                n7 = this.memory[n6 + this.rc];
                if (this.multiCol && n11 > 7) {
                    this.multiColor[3] = this.cbmcolor[n11 & 7];
                    for (n10 = 0; n10 < 8; n10 += 2) {
                        int n12 = n7 >> n10 & 3;
                        int n13 = this.multiColor[n12];
                        this.mem[n + 7 - n10] = n13;
                        this.mem[n + 6 - n10] = n13;
                        n12 = n12 > 1 ? 256 : 0;
                        int n14 = n12;
                        this.collissionMask[n5 + 6 - n10] = n14;
                        this.collissionMask[n5 + 7 - n10] = n14;
                    }
                } else {
                    for (n10 = 0; n10 < 8; ++n10) {
                        if ((n7 & 1 << n10) > 0) {
                            this.mem[n + 7 - n10] = n8;
                            this.collissionMask[n5 + 7 - n10] = 256;
                            continue;
                        }
                        this.mem[n + 7 - n10] = n9;
                        this.collissionMask[n5 + 7 - n10] = 0;
                    }
                }
                if (this.multiCol && this.extended) {
                    for (n10 = 0; n10 < 8; ++n10) {
                        this.mem[n + 7 - n10] = -16777216;
                    }
                }
                n += 8;
                ++this.vmli;
                ++this.vc;
                n5 += 8;
            }
        } else {
            n6 = this.vicBase + (this.vc & 0x3FF) * 8 + this.rc;
            if (this.multiCol) {
                this.multiColor[0] = this.bgColor;
            }
            while (this.vmli < n4) {
                int n15;
                n8 = this.cbmcolor[(this.vicCharCache[this.vmli] & 0xF0) >> 4];
                n9 = this.cbmcolor[this.vicCharCache[this.vmli] & 0xF];
                n7 = this.memory[n6];
                if (this.multiCol) {
                    this.multiColor[1] = this.cbmcolor[this.vicCharCache[this.vmli] >> 4 & 0xF];
                    this.multiColor[2] = this.cbmcolor[this.vicCharCache[this.vmli] & 0xF];
                    this.multiColor[3] = this.cbmcolor[this.vicColCache[this.vmli] & 0xF];
                    for (int i = 0; i < 8; i += 2) {
                        n15 = n7 >> i & 3;
                        int n16 = this.multiColor[n15];
                        this.mem[n + 7 - i] = n16;
                        this.mem[n + 6 - i] = n16;
                        n15 = n15 > 1 ? 256 : 0;
                        int n17 = n15;
                        this.collissionMask[n5 + 6 - i] = n17;
                        this.collissionMask[n5 + 7 - i] = n17;
                    }
                } else {
                    for (n15 = 0; n15 < 8; ++n15) {
                        if ((n7 & 1 << n15) > 0) {
                            this.mem[7 - n15 + n] = n8;
                            this.collissionMask[n5 + 7 - n15] = 256;
                            continue;
                        }
                        this.mem[7 - n15 + n] = n9;
                        this.collissionMask[n5 + 7 - n15] = 0;
                    }
                }
                if (this.extended) {
                    for (n15 = 0; n15 < 8; ++n15) {
                        this.mem[n + 7 - n15] = -16777216;
                    }
                }
                n6 = n6 + 8 & 0xFFFF;
                n += 8;
                n5 += 8;
                ++this.vc;
                ++this.vmli;
            }
        }
    }

    private final void drawSprites(int n, int n2) {
        int n3 = 256;
        int n4 = 32 + (this.hideColumn ? 8 : 0);
        for (int i = 7; i >= 0; --i) {
            int n5;
            Sprite sprite = this.sprites[i];
            n3 >>= 1;
            if (sprite.lineFinished || !sprite.painting) continue;
            int n6 = sprite.x + 8;
            int n7 = this.vPos * 384;
            if (n6 >= n2) continue;
            int n8 = n2;
            for (int j = n5 = n > n6 ? n : n6; j < n8; ++j) {
                int n9 = sprite.getPixel();
                if (n9 == 0 || j < n4) continue;
                int n10 = j;
                int n11 = this.collissionMask[n10] | n3;
                this.collissionMask[n10] = n11;
                int n12 = n11;
                if (!sprite.priority || (n12 & 0x100) == 0) {
                    this.mem[n7 + j] = sprite.color[n9];
                }
                if (n12 == n3) continue;
                if ((n12 & 0x100) != 0) {
                    this.vicMemory[31] = this.vicMemory[31] | n3;
                }
                if ((n12 & 0xFF) == n3) continue;
                this.vicMemory[30] = this.vicMemory[30] | n12 & 0xFF;
            }
        }
        this.memory[65566] = this.vicMemory[30];
        this.memory[65567] = this.vicMemory[31];
    }

    public void stop() {
        this.motorSound(false);
        this.mixer.stop();
    }

    public void reset() {
        this.initUpdate();
        this.mixer.reset();
        this.nextSID = this.cpu.cycles;
        this.lastLine = this.cpu.cycles;
        this.nextIOUpdate = this.cpu.cycles + 47L;
        this.vicState = 0;
        for (int i = 0; i < this.mem.length; ++i) {
            this.mem[i] = 0;
        }
        this.reset = 100;
        this.keyboard.reset();
        this.motorSound(false);
    }

    public void paint(Graphics graphics) {
        Object object;
        if (graphics == null) {
            return;
        }
        if (this.image == null) {
            this.image = this.canvas.createImage(384, 284);
            this.g2 = this.image.getGraphics();
            this.g2.setFont(new Font("Monospaced", 0, 11));
        }
        if (this.crtImage == null) {
            this.crtImage = new BufferedImage(this.displayWidth, this.displayHeight, 2);
            object = this.crtImage.getGraphics();
            ((Graphics)object).setColor(TRANSPARENT_BLACK);
            int n = this.displayHeight;
            for (int i = 0; i < n; i += 2) {
                ((Graphics)object).drawLine(0, i, this.displayWidth, i);
            }
        }
        this.g2.drawImage(this.screen, 0, 0, null);
        if (this.reset > 0) {
            this.g2.setColor(this.darks[this.colIndex]);
            int n = 44;
            if (this.reset < 44) {
                n = this.reset;
            }
            this.g2.drawString("JaC64 1.0 - Java C64 - www.jac64.com", n + 1, 9);
            this.g2.setColor(this.lites[this.colIndex]);
            this.g2.drawString("JaC64 1.0 - Java C64 - www.jac64.com", n, 8);
            --this.reset;
        } else {
            object = "JaC64 ";
            if (this.message != null && this.message != "") {
                object = (String)object + this.message;
            } else {
                this.colIndex = 0;
            }
            object = (String)object + this.tmsg;
            this.g2.setColor(this.darks[this.colIndex]);
            this.g2.drawString((String)object, 1, 9);
            this.g2.setColor(this.lites[this.colIndex]);
            this.g2.drawString((String)object, 0, 8);
            if (this.ledOn) {
                this.g2.setColor(LED_ON);
            } else {
                this.g2.setColor(LED_OFF);
            }
            this.g2.fillRect(372, 3, 7, 1);
            this.g2.setColor(LED_BORDER);
            this.g2.drawRect(371, 2, 8, 2);
        }
        graphics.fillRect(0, 0, this.offsetX, this.displayHeight + this.offsetY * 2);
        graphics.fillRect(this.offsetX + this.displayWidth, 0, this.offsetX, this.displayHeight + this.offsetY * 2);
        graphics.fillRect(0, 0, this.displayWidth + this.offsetX * 2, this.offsetY);
        graphics.fillRect(0, this.displayHeight + this.offsetY, this.displayWidth + this.offsetX * 2, this.offsetY);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage(this.image, this.offsetX, this.offsetY, this.displayWidth, this.displayHeight, null);
    }

    public void updateDisk(Object object, Object object2) {
        if (object2 == C1541Chips.HEAD_MOVED) {
            if (this.lastTrack != this.c1541Chips.currentTrack) {
                this.lastTrack = this.c1541Chips.currentTrack;
                this.trackSound();
            } else {
                this.trackSound();
            }
        }
        this.lastSector = this.c1541Chips.currentSector;
        if (this.motorOn != this.c1541Chips.motorOn) {
            this.motorSound(this.c1541Chips.motorOn);
        }
        this.tmsg = " track: " + this.lastTrack + " / " + this.lastSector;
        this.ledOn = this.c1541Chips.ledOn;
        this.motorOn = this.c1541Chips.motorOn;
    }

    private void trackSound() {
        if (this.trackSound != null) {
            this.trackSound.play();
        }
    }

    public void motorSound(boolean bl) {
        if (this.motorSound != null) {
            if (bl) {
                this.motorSound.loop();
            } else {
                this.motorSound.stop();
            }
        }
    }

    public void setSounds(AudioClip audioClip, AudioClip audioClip2) {
        this.trackSound = audioClip;
        this.motorSound = audioClip2;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.potx = mouseEvent.getX() & 0xFF;
        this.poty = 255 - (mouseEvent.getY() & 0xFF);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.potx = mouseEvent.getX() & 0xFF;
        this.poty = 255 - (mouseEvent.getY() & 0xFF);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.button1 = true;
        } else {
            this.button2 = true;
        }
        this.keyboard.setButtonval(255 - (this.button1 | this.button2 ? 16 : 0));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.button1 = false;
        } else {
            this.button2 = false;
        }
        this.keyboard.setButtonval(255 - (this.button1 | this.button2 ? 16 : 0));
    }

    private class Sprite {
        boolean painting = false;
        boolean dma = false;
        int nextByte;
        int pointer;
        int x;
        int spriteNo;
        int spriteReg;
        boolean enabled;
        boolean expFlipFlop;
        boolean multicolor = false;
        boolean expandX = false;
        boolean expandY = false;
        boolean priority = false;
        boolean lineFinished = false;
        int pixelsLeft = 0;
        int currentPixel = 0;
        int[] color = new int[4];

        private Sprite() {
        }

        int getPixel() {
            if (this.lineFinished) {
                return 0;
            }
            --this.pixelsLeft;
            if (this.pixelsLeft > 0) {
                return this.currentPixel;
            }
            if (this.pixelsLeft <= 0 && this.spriteReg == 0) {
                this.currentPixel = 0;
                this.lineFinished = true;
                return 0;
            }
            if (this.multicolor) {
                this.currentPixel = (this.spriteReg & 0xC00000) >> 22;
                this.spriteReg = this.spriteReg << 2 & 0xFFFFFF;
                this.pixelsLeft = 2;
            } else {
                this.currentPixel = (this.spriteReg & 0x800000) >> 22;
                this.spriteReg = this.spriteReg << 1 & 0xFFFFFF;
                this.pixelsLeft = 1;
            }
            if (this.expandX) {
                this.pixelsLeft <<= 1;
            }
            return this.currentPixel;
        }

        void readSpriteData() {
            C64Screen.this.lastSpriteRead = this.spriteNo;
            this.pointer = C64Screen.this.vicBank + C64Screen.this.memory[C64Screen.this.spr0BlockSel + this.spriteNo] * 64;
            this.spriteReg = (C64Screen.this.memory[this.pointer + this.nextByte++] & 0xFF) << 16 | (C64Screen.this.memory[this.pointer + this.nextByte++] & 0xFF) << 8 | C64Screen.this.memory[this.pointer + this.nextByte++];
            if (!this.expandY) {
                this.expFlipFlop = false;
            }
            if (this.expFlipFlop) {
                this.nextByte -= 3;
            }
            this.expFlipFlop = !this.expFlipFlop;
            this.pixelsLeft = 0;
            this.lineFinished = false;
        }
    }
}

