/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.DirEntry;
import com.dreamfabric.jac64.DiskListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class C64Reader {
    public static final int NONE = 0;
    public static final int TAPE = 1;
    public static final int DISK = 2;
    private CPU cpu;
    private int[] memory;
    private String label = "";
    private ArrayList dirNames = new ArrayList();
    private Hashtable dirEntries = new Hashtable();
    private DiskListener listener;
    private int type = 0;
    private int diskSize = 0;
    private byte[][] sectors = new byte[800][256];
    private boolean dirty = false;
    private int noBytes;
    private boolean lastEntry;
    private int nextSector;
    private int nextTrack;

    public void setCPU(CPU cPU) {
        this.cpu = cPU;
        this.memory = cPU.getMemory();
    }

    public void setDiskListener(DiskListener diskListener) {
        this.listener = diskListener;
    }

    public int getLoadedType() {
        return this.type;
    }

    public ArrayList getDirNames() {
        return this.dirNames;
    }

    public DirEntry getDirEntry(String string) {
        return (DirEntry)this.dirEntries.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDisk(InputStream inputStream) {
        this.dirty = false;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.dirNames.clear();
        this.type = 2;
        try {
            while ((n4 = dataInputStream.read(this.sectors[n])) > 0) {
                if (n4 < 256) {
                    dataInputStream.readFully(this.sectors[n], n4, 256 - n4);
                }
                if (n3 == 18) {
                    this.readDir(this.sectors[n], n3, n2);
                }
                ++n;
                if (!(n3 < 18 && n2 == 21 || n3 >= 18 && n3 < 25 && n2 == 19 || n3 >= 25 && n3 < 31 && n2 == 18) && (n3 < 31 || n3 >= 41 || ++n2 != 17)) continue;
                n2 = 0;
                ++n3;
            }
            System.out.println("Read " + n + " sectors");
            this.diskSize = n;
        }
        catch (Exception exception) {
            System.out.println("Error reading sectors");
            System.out.println("Track: " + n3 + " sec: " + n);
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
        }
        if (this.listener != null) {
            this.listener.diskChanged();
        }
        return true;
    }

    public byte[] getSector(int n) {
        return this.sectors[n];
    }

    public static int getSectorCount(int n) {
        if (n > 30) {
            return 17;
        }
        if (n > 24) {
            return 18;
        }
        if (n > 17) {
            return 19;
        }
        return 21;
    }

    public byte[] getSector(int n, int n2) {
        int n3 = this.getSecTrack(n);
        return this.sectors[n3 += n2];
    }

    private int getSecTrack(int n) {
        int n2 = 0;
        n2 = n < 18 ? (n - 1) * 21 : (n >= 18 && n < 25 ? (n - 1) * 19 + 34 : (n >= 25 && n < 31 ? (n - 1) * 18 + 51 + 7 : (n - 1) * 17 + 68 + 14 + 6));
        return n2;
    }

    public void writeDisk(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = this.diskSize;
        for (int i = 0; i < n; ++i) {
            bufferedOutputStream.write(this.sectors[i], 0, 256);
        }
        bufferedOutputStream.close();
    }

    public void setSector(int n, int n2, byte[] byArray) {
        int n3 = this.getSecTrack(n);
        this.dirty = true;
        n3 += n2;
        int n4 = 255;
        for (int i = 0; i < n4; ++i) {
            this.sectors[n3][i] = byArray[i];
        }
    }

    private void readDir(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            this.label = "";
            for (int i = 0; i < 16; ++i) {
                if (byArray[144 + i] == -96) continue;
                this.label = this.label + (char)byArray[144 + i];
            }
            System.out.println("Directory listing of '" + this.label + "'");
            this.lastEntry = false;
            this.nextSector = n;
            this.nextSector = 1;
        } else if (!this.lastEntry) {
            if (this.nextSector == n2 && byArray[0] == 0) {
                this.lastEntry = true;
            } else {
                this.nextSector = byArray[1];
                this.nextTrack = byArray[0];
            }
            for (int i = 0; i < 255 && byArray[i + 2] != 0; i += 32) {
                String string = "";
                int n3 = byArray[i + 2] & 0xFF;
                switch (n3) {
                    case 128: {
                        string = "DEL";
                        break;
                    }
                    case 129: {
                        string = "SEQ";
                        break;
                    }
                    case 130: {
                        string = "PRG";
                        break;
                    }
                    case 131: {
                        string = "USR";
                        break;
                    }
                    case 132: {
                        string = "REL";
                    }
                }
                String string2 = "";
                String string3 = "";
                for (int j = 0; j < 16; ++j) {
                    string2 = byArray[i + 5 + j] != -96 ? string2 + (char)byArray[i + 5 + j] : string2 + " ";
                }
                string3 = byArray[i + 3] + "/" + byArray[i + 4];
                int n4 = byArray[i + 30] & 255 + byArray[i + 31] * 256;
                DirEntry dirEntry = new DirEntry(string2, byArray[i + 3], byArray[i + 4], n4, n3);
                this.dirNames.add(dirEntry);
                this.dirEntries.put(string2, dirEntry);
            }
            if (this.lastEntry) {
                System.out.println("No more files.");
            }
        }
    }

    public String readFile(String string) {
        return this.readFile(string, -1);
    }

    public String readFile(String string, int n) {
        return this.readFile(string, n, null);
    }

    private void printDirListing(OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        int n3 = 2049;
        byArray[n2++] = (byte)(n3 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)((n3 += this.label.length() + 5) & 0xFF);
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 18;
        byArray[n2++] = 34;
        int n4 = this.label.length();
        for (n = 0; n < n4; ++n) {
            byArray[n2++] = (byte)this.label.charAt(n);
        }
        byArray[n2++] = 34;
        byArray[n2++] = 0;
        n4 = this.dirNames.size();
        for (n = 0; n < n4; ++n) {
            int n5;
            DirEntry dirEntry = (DirEntry)this.dirNames.get(n);
            n3 += 26;
            int n6 = 1;
            if (dirEntry.size < 10) {
                n6 = 3;
            } else if (dirEntry.size < 100) {
                n6 = 2;
            }
            byArray[n2++] = (byte)((n3 += n6) & 0xFF);
            byArray[n2++] = (byte)(n3 >> 8);
            byArray[n2++] = (byte)(dirEntry.size & 0xFF);
            byArray[n2++] = (byte)(dirEntry.size >> 8);
            int n7 = n6;
            for (n5 = 0; n5 < n7; ++n5) {
                byArray[n2++] = 32;
            }
            n7 = dirEntry.name.length();
            for (n5 = 0; n5 < n7; ++n5) {
                byArray[n2++] = (byte)dirEntry.name.charAt(n5);
            }
            n7 = 18 - dirEntry.name.length();
            for (n5 = 0; n5 < n7; ++n5) {
                byArray[n2++] = 32;
            }
            String string = dirEntry.getTypeString();
            int n8 = string.length();
            for (n7 = 0; n7 < n8; ++n7) {
                byArray[n2++] = (byte)string.charAt(n7);
            }
            byArray[n2++] = 0;
        }
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        try {
            outputStream.write(byArray, 0, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String readFile(String string, int n, OutputStream outputStream) {
        int n2 = 0;
        DirEntry dirEntry = null;
        System.out.println("Loading: '" + string + "' at " + n);
        n2 = string.indexOf(42);
        if (n2 >= 0) {
            String string2 = string.substring(0, n2);
            System.out.println("Matcher: " + string2);
            Enumeration enumeration = this.dirEntries.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.startsWith(string2)) continue;
                System.out.println("Found: " + string3);
                dirEntry = (DirEntry)this.dirEntries.get(string3);
            }
        } else {
            if (string.equals("$")) {
                this.printDirListing(outputStream);
                return string;
            }
            dirEntry = (DirEntry)this.dirEntries.get(string);
            if (dirEntry == null) {
                int n3 = 16;
                for (int i = string.length(); i < n3; ++i) {
                    string = string + ' ';
                }
                dirEntry = (DirEntry)this.dirEntries.get(string);
            }
        }
        if (dirEntry == null) {
            return null;
        }
        if (this.type == 1) {
            return this.readTapeFile(dirEntry);
        }
        return this.readDiskFile(dirEntry, string, n, outputStream);
    }

    public String readDiskFile(DirEntry dirEntry, String string, int n, OutputStream outputStream) {
        int n2;
        byte[] byArray = this.getSector(dirEntry.trk, dirEntry.sec);
        int n3 = (byArray[2] & 0xFF) + (byArray[3] & 0xFF) * 256;
        System.out.println("*** Reading DISK file at " + Integer.toString(n3, 16));
        if (outputStream != null) {
            try {
                outputStream.write(byArray[2] & 0xFF);
                outputStream.write(byArray[3] & 0xFF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (n != -1) {
            System.out.println("Address override: " + n3 + " -> " + n);
            n3 = n;
        }
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[0] & 0xFF;
        try {
            for (n2 = 0; n2 < 252; ++n2) {
                if (outputStream != null) {
                    outputStream.write(byArray[n2 + 4] & 0xFF);
                    continue;
                }
                this.memory[n2 + n3] = byArray[n2 + 4] & 0xFF;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not write to output stream");
            exception.printStackTrace();
        }
        n3 += 252;
        int n6 = n2 = n5 != 0 ? 1 : 0;
        while (n2 != 0) {
            byArray = this.getSector(n5, n4);
            n4 = byArray[1] & 0xFF;
            n5 = byArray[0] & 0xFF;
            n2 = n5 != 0 ? 1 : 0;
            try {
                for (int i = 0; i < 254; ++i) {
                    if (outputStream != null) {
                        outputStream.write(byArray[i + 2] & 0xFF);
                        continue;
                    }
                    this.memory[i + n3] = byArray[i + 2] & 0xFF;
                }
            }
            catch (Exception exception) {
                System.out.println("Could not write to output stream");
                exception.printStackTrace();
            }
            n3 += 254;
        }
        n3 = n3 - 255 + n4;
        if (outputStream == null) {
            this.setAddress(n3);
        }
        System.out.println("*** File loaded - end at: " + Integer.toString(n3, 16));
        return dirEntry.name;
    }

    public String saveFile() {
        int n = this.memory[43] + (this.memory[44] << 8);
        int n2 = this.memory[45] + (this.memory[46] << 8);
        System.out.println("Dumping mem from: " + n + " to " + n2);
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0xFF) < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(n & 0xFF));
        if (n >> 8 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(n >> 8));
        for (int i = n; i < n2; ++i) {
            int n3 = this.memory[i];
            if (n3 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(this.memory[i], 16));
        }
        return stringBuffer.toString();
    }

    private void setAddress(int n) {
        if (n > 40704) {
            n = 40704;
        }
        this.memory[45] = n & 0xFF;
        this.memory[46] = (n & 0xFF00) >> 8;
        this.memory[47] = n & 0xFF;
        this.memory[48] = (n & 0xFF00) >> 8;
        this.memory[49] = n & 0xFF;
        this.memory[50] = (n & 0xFF00) >> 8;
    }

    private String readTapeFile(DirEntry dirEntry) {
        int n = dirEntry.sec;
        int n2 = dirEntry.trk;
        System.out.println("Reading from " + n2);
        System.out.println("Storing at: " + n);
        System.out.println("Size: " + dirEntry.size);
        for (int i = 0; i < dirEntry.size; ++i) {
            this.memory[n++] = this.sectors[i + n2 >> 8][i + n2 & 0xFF] & 0xFF;
        }
        this.setAddress(n);
        return dirEntry.name;
    }

    private boolean readPGM(InputStream inputStream, int n) {
        byte[] byArray = new byte[2];
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = this.readSector(dataInputStream, n2)) == 256) {
                ++n2;
            }
            n4 = n2 * 256 + n3;
            System.out.println("Read " + n4 + " program data");
            if (n == -1) {
                n = byArray[0] + byArray[1] * 256;
            }
            System.out.println("Storing at: " + n);
            for (int i = 0; i < n4; ++i) {
                this.memory[n++] = this.sectors[i >> 8][i & 0xFF] & 0xFF;
            }
            this.setAddress(n);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error while reading pgm file " + exception);
            return false;
        }
    }

    private boolean readTape(InputStream inputStream) {
        byte[] byArray = new byte[32];
        this.dirNames.clear();
        this.type = 1;
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            String string = new String(byArray);
            if (string.startsWith("C64")) {
                int n;
                int n2;
                int n3;
                System.out.println("Tape Archive found:");
                dataInputStream.readFully(byArray);
                int n4 = byArray[3] * 256 + byArray[2];
                int n5 = byArray[5] * 256 + byArray[4];
                if (n5 == 0) {
                    n5 = 1;
                }
                String string2 = "";
                System.out.println("Type: " + byArray[0] * 256 + byArray[1]);
                System.out.println("Max Entries: " + n4);
                System.out.println("Used Entries: " + n5);
                for (n3 = 8; n3 < 32; ++n3) {
                    string2 = string2 + (char)byArray[n3];
                }
                System.out.println("Name: " + string2);
                for (n2 = 0; n2 < n5; ++n2) {
                    dataInputStream.readFully(byArray);
                    n3 = (byArray[2] & 0xFF) + (byArray[3] & 0xFF) * 256;
                    int n6 = (byArray[4] & 0xFF) + (byArray[5] & 0xFF) * 256;
                    int n7 = (byArray[8] & 0xFF) + (byArray[9] & 0xFF) * 256;
                    System.out.println("---------------------");
                    System.out.println("Entry: " + n2);
                    System.out.println("File Type: " + byArray[0]);
                    System.out.println("1541 Type: " + byArray[1]);
                    System.out.println("Start Adr: " + n3);
                    System.out.println("End Adr: " + n6 + " -> size = " + (n6 - n3));
                    System.out.println("Offset: " + n7);
                    string2 = "";
                    for (n = 16; n < 32; ++n) {
                        string2 = string2 + (char)byArray[n];
                    }
                    System.out.println("File Name: " + string2);
                    this.dirNames.add(string2);
                    this.dirEntries.put(string2, new DirEntry(string2, n7 - 32 * (n4 + 2), n3, n6 - n3, byArray[1]));
                }
                for (n2 = n5; n2 < n4; ++n2) {
                    dataInputStream.readFully(byArray);
                }
                n2 = 0;
                boolean bl = true;
                while ((n = this.readSector(dataInputStream, n2)) == 256) {
                    ++n2;
                }
                this.noBytes = n2 * 256 + n;
                System.out.println("Read " + this.noBytes + " program data");
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error while reading tape");
            return false;
        }
    }

    private boolean readSID(InputStream inputStream) {
        byte[] byArray = new byte[22];
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            String string = new String(byArray);
            if (string.startsWith("PSID")) {
                int n = byArray[4] * 256 + byArray[5];
                int n2 = byArray[6] * 256 + byArray[7];
                int n3 = byArray[8] * 256 + byArray[9];
                int n4 = byArray[10] * 256 + byArray[11];
                int n5 = byArray[12] * 256 + byArray[13];
                int n6 = byArray[14] * 256 + byArray[15];
                int n7 = byArray[16] * 256 + byArray[17];
                long l = (byArray[18] << 24) + (byArray[19] << 16) + (byArray[20] << 8) + byArray[21];
                System.out.println("FOUND SID TUNE!");
                System.out.println("Version: " + n);
                System.out.println("LAddr: " + n3);
                System.out.println("IAddr: " + n4);
                System.out.println("PAddr: " + n5);
                System.out.println("Songs: " + n6);
                System.out.println("StartSong: " + n7);
                System.out.println("Speed: " + l);
                byte[] byArray2 = new byte[32];
                for (int i = 0; i < n6; ++i) {
                    dataInputStream.readFully(byArray2);
                    System.out.println("Song " + (i + 1));
                    System.out.println("Name      :" + new String(byArray2));
                    dataInputStream.readFully(byArray2);
                    System.out.println("Author    :" + new String(byArray2));
                    dataInputStream.readFully(byArray2);
                    System.out.println("Copyright :" + new String(byArray2));
                }
                if (n == 2) {
                    byte[] byArray3 = new byte[6];
                    dataInputStream.readFully(byArray3);
                }
                byte[] byArray4 = new byte[2];
                dataInputStream.readFully(byArray4);
                int n8 = byArray4[1] * 256 + byArray4[0];
            }
        }
        catch (Exception exception) {
            System.out.println("Error while reading SID");
        }
        return false;
    }

    private int readSector(DataInputStream dataInputStream, int n) {
        int n2 = 0;
        try {
            int n3 = n2 = dataInputStream.read(this.sectors[n]);
            while (n2 < 256) {
                n3 = dataInputStream.read(this.sectors[n], n2, 256 - n2);
                if (n3 == -1) {
                    return n2;
                }
                n2 += n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while reading file... " + exception);
        }
        return n2;
    }

    public boolean readDiskFromFile(String string) {
        try {
            System.out.println("Loading " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            return this.readDisk(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("Error while opening file " + string + "  " + exception);
            return false;
        }
    }

    public boolean readPGM(URL uRL, int n) {
        try {
            return this.readPGM(uRL.openConnection().getInputStream(), n);
        }
        catch (Exception exception) {
            System.out.println("Error when opening url " + uRL + "  " + exception);
            return false;
        }
    }

    public boolean readPGM(String string, int n) {
        try {
            return this.readPGM(new FileInputStream(string), n);
        }
        catch (Exception exception) {
            System.out.println("Error when opening file " + string + "  " + exception);
            return false;
        }
    }

    public boolean readDiskFromURL(URL uRL) {
        try {
            System.out.println("Loading from " + uRL);
            InputStream inputStream = uRL.openConnection().getInputStream();
            return this.readDisk(inputStream);
        }
        catch (Exception exception) {
            System.out.println("Error when opening url " + uRL + "  " + exception);
            return false;
        }
    }

    public boolean readTapeFromFile(String string) {
        try {
            System.out.println("Loading " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            return this.readTape(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("Error while opening file " + string + "  " + exception);
            return false;
        }
    }

    public boolean readTapeFromURL(URL uRL) {
        try {
            System.out.println("Loading from " + uRL);
            InputStream inputStream = uRL.openConnection().getInputStream();
            return this.readTape(inputStream);
        }
        catch (Exception exception) {
            System.out.println("Error when opening url " + uRL + "  " + exception);
            return false;
        }
    }

    public boolean readSIDFromFile(String string) {
        try {
            System.out.println("Loading SID " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            return this.readSID(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("Error while opening file " + string + "  " + exception);
            return false;
        }
    }

    public static void main(String[] stringArray) {
        C64Reader c64Reader = new C64Reader();
        c64Reader.readDiskFromFile(stringArray[0]);
        if (stringArray.length > 1) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                c64Reader.readFile(stringArray[1], 0, fileOutputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            c64Reader.printDirListing(System.out);
        }
    }
}

