/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.Observer;

public abstract class C64Chips {
    public static final boolean DEBUG_INTERRUPS = false;
    public static final int VIC_IRQ = 1;
    public static final int CIA_TIMER_IRQ = 2;
    public static final int KEYBOARD_NMI = 1;
    public static final int CIA_TIMER_NMI = 2;
    private int nmiFlags = 0;
    private int oldNmiFlags = 0;
    private int irqFlags = 0;
    private int oldIrqFlags = 0;
    private Observer observer;
    MOS6510Core cpu;

    public void init(MOS6510Core mOS6510Core) {
        this.cpu = mOS6510Core;
    }

    public int getNMIFlags() {
        return this.nmiFlags;
    }

    public int getIRQFlags() {
        return this.irqFlags;
    }

    public boolean setIRQ(int n) {
        boolean bl = (this.irqFlags & n) == 0;
        this.irqFlags |= n;
        if (this.irqFlags != this.oldIrqFlags) {
            this.cpu.setIRQLow(this.irqFlags != 0);
            this.oldIrqFlags = this.irqFlags;
        }
        return bl;
    }

    public void clearIRQ(int n) {
        this.irqFlags &= ~n;
        if (this.irqFlags != this.oldIrqFlags) {
            this.cpu.setIRQLow(this.irqFlags != 0);
            this.oldIrqFlags = this.irqFlags;
        }
    }

    public boolean setNMI(int n) {
        boolean bl = (this.nmiFlags & n) == 0;
        this.nmiFlags |= n;
        if (this.nmiFlags != this.oldNmiFlags) {
            this.cpu.setNMILow(this.nmiFlags != 0);
            this.oldNmiFlags = this.nmiFlags;
        }
        return bl;
    }

    public void clearNMI(int n) {
        this.nmiFlags &= ~n;
        if (this.nmiFlags != this.oldNmiFlags) {
            this.cpu.setNMILow(this.nmiFlags != 0);
            this.oldNmiFlags = this.nmiFlags;
        }
    }

    public abstract void reset();

    public abstract void stop();

    public abstract int performRead(int var1, long var2);

    public abstract void performWrite(int var1, int var2, long var3);

    public abstract void updateChips(long var1);

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public void update(Object object, Object object2) {
        if (this.observer != null) {
            this.observer.update(object, object2);
        }
    }
}

