/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.Keyboard;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;

public class C64Canvas
extends JPanel
implements KeyListener,
FocusListener {
    private static final long serialVersionUID = 5124260828376559537L;
    boolean integerScale = true;
    C64Screen scr;
    Keyboard keyboard;
    boolean autoScale;
    int w;
    int h;

    public C64Canvas(C64Screen c64Screen, boolean bl, Keyboard keyboard) {
        this.autoScale = bl;
        this.scr = c64Screen;
        this.keyboard = keyboard;
        this.setFont(new Font("Monospaced", 0, 11));
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public void setAutoscale(boolean bl) {
        this.autoScale = bl;
    }

    public void setIntegerScaling(boolean bl) {
        this.integerScale = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.autoScale && (this.w != this.getWidth() || this.h != this.getHeight())) {
            this.w = this.getWidth();
            this.h = this.getHeight();
            double d = 1.0 * (double)this.w / 384.0;
            if (d > 1.0 * (double)this.h / 284.0) {
                d = 1.0 * (double)this.h / 284.0;
            }
            if (this.integerScale && d > 1.0) {
                d = (int)d;
            }
            this.scr.setDisplayFactor(d);
            this.scr.setDisplayOffset((int)((double)this.w - d * 384.0) / 2, (int)((double)this.h - d * 284.0) / 2);
        }
        this.scr.paint(graphics);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyboard.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyboard.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == 'w' && (keyEvent.getModifiers() & 8) != 0) {
            this.scr.getMixer().setFullSpeed(!this.scr.getMixer().fullSpeed());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.keyboard.reset();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.keyboard.reset();
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

