/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C1541Chips;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.PatchListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class C1541Emu
extends MOS6510Core {
    public static final boolean DEBUG = false;
    public static final boolean IODEBUG = false;
    public static final int C1541ROM = 49152;
    public static final int RESET_VECTOR = 65532;
    public C1541Chips chips;
    boolean byteReady = false;

    public C1541Emu(IMonitor iMonitor, String string) {
        super(iMonitor, string);
        this.memory = new int[65536];
        this.chips = new C1541Chips(this);
        this.init(this.chips);
        this.loadDebug("c1541dbg.txt");
    }

    public void setReader(C64Reader c64Reader) {
        this.chips.setReader(c64Reader);
    }

    protected final int fetchByte(int n) {
        if (n < 2048 || n >= 49152) {
            return this.memory[n];
        }
        int n2 = n & 0xFF00;
        if (n2 == 6144 || n2 == 7168) {
            int n3 = this.chips.performRead(n, this.cycles);
            return n3;
        }
        return 0;
    }

    protected final void writeByte(int n, int n2) {
        int n3;
        if (n < 2048) {
            this.memory[n] = n2;
        }
        if ((n3 = n & 0xFF00) == 6144 || n3 == 7168) {
            this.chips.performWrite(n, n2, this.cycles);
        }
    }

    public void reset() {
        super.reset();
        this.pc = this.memory[65532] | this.memory[65533] << 8;
        System.out.println("C1541: Reset to " + Integer.toHexString(this.pc));
    }

    void triggerByteReady() {
        this.byteReady = true;
    }

    public void tick(long l) {
        while (this.cycles < l) {
            if (this.byteReady && this.chips.byteReadyOverflow) {
                this.overflow = true;
                this.byteReady = false;
            }
            this.emulateOp();
            if (this.chips.nextCheck >= this.cycles) continue;
            this.chips.updateChips(this.cycles);
        }
    }

    public void patchROM(PatchListener patchListener) {
    }

    public void loadDebug(String string) {
        try {
            URL uRL = this.getClass().getResource(string);
            this.monitor.info("Loading debug from URL: " + uRL);
            if (uRL == null) {
                uRL = new URL(this.codebase + string);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\t");
                int n = -1;
                try {
                    n = Integer.parseInt(stringArray[0].trim(), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == -1) continue;
                this.setDebug(n, stringArray[1].trim());
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to load debug text: " + string);
        }
    }

    protected void readROM(String string, int n, int n2) {
        try {
            URL uRL = this.getClass().getResource(string);
            this.monitor.info("URL: " + uRL);
            this.monitor.info("Read ROM " + string);
            if (uRL == null) {
                uRL = new URL(this.codebase + string);
            }
            this.loadROM(new DataInputStream(uRL.openConnection().getInputStream()), n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void installROMS() {
        this.readROM("/roms/c1541.rom", 49152, 16384);
    }
}

