/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C1541Emu;
import com.dreamfabric.jac64.C64Chips;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.DiskListener;

public class C1541Chips
extends C64Chips
implements DiskListener {
    public static final int GCR_SECTOR_SIZE = 354;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_IRQ = false;
    public static final boolean DEBUG_WRITE = false;
    public static final boolean DEBUG_GCR = false;
    public static final boolean DEBUG_IEC = false;
    public static final Object LED_MOTOR = new Object();
    public static final Object HEAD_MOVED = new Object();
    public static final Object SECTOR_UPDATE = new Object();
    public static final int[] GCR = new int[]{10, 11, 18, 19, 14, 15, 22, 23, 9, 25, 26, 27, 13, 29, 30, 21};
    public static final int[] GCR_REV = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 0, 1, 255, 12, 4, 5, 255, 255, 2, 3, 255, 15, 6, 7, 255, 9, 10, 11, 255, 13, 14, 255};
    private C1541Emu cpu;
    private int diskID1 = 0;
    private int diskID2 = 0;
    private int track = 1;
    private int hTrack = 2;
    private int sector = 0;
    private int sectorPos = 0;
    private int currentTrackSize = 21;
    private int[] gcrSector = new int[354];
    private int[] gcrWriteSector = new int[354];
    private int[][][] gcrCacheSector = new int[40][21][];
    private int via1PB;
    private int via1PA;
    private int via1CB;
    private int via1CA;
    private int via1T1Ctr;
    private int via1T1Latch;
    private int via1T2Ctr;
    private int via1T2Latch;
    private int via1SerialRegister;
    private int via1AuxControl;
    private int via1PerControl;
    private int via1IFlag;
    private int via1IEnable;
    private int via2PB;
    private int via2PA;
    private int via2CB;
    private int via2CA;
    private int via2T1Ctr;
    private int via2T1Latch;
    private int via2T2Ctr;
    private int via2T2Latch;
    private int via2SerialRegister;
    private int via2AuxControl;
    int via2PerControl;
    private int via2IFlag;
    private int via2IEnable;
    private boolean diskChanged = true;
    private boolean writeProtected = true;
    public boolean ledOn;
    public boolean motorOn;
    public int currentTrack;
    public int currentSector;
    public int headOutBeyond = 0;
    private int bytesWritten = 0;
    private int currentByte = 0;
    private int currentReadByte = 0;
    private C64Reader reader;
    boolean byteReadyOverflow = false;
    boolean diskModeWrite = false;
    C64Screen cia2;
    int iecLines;
    private int lastRead;
    long nextAutoforward;
    long lastCycles = 0L;
    long nextCheck = 0L;
    boolean lastSync = false;

    public C1541Chips(C1541Emu c1541Emu) {
        this.cpu = c1541Emu;
        this.init(this.cpu);
    }

    public void initIEC2(C64Screen c64Screen) {
        this.cia2 = c64Screen;
    }

    public void setReader(C64Reader c64Reader) {
        this.log("Setting reader...");
        this.reader = c64Reader;
        c64Reader.setDiskListener(this);
    }

    public final int performRead(int n, long l) {
        switch (n) {
            case 6144: {
                return (this.via1PB & 0x1A | (this.iecLines & this.cia2.iecLines) >> 7 & 1 | (this.iecLines & this.cia2.iecLines) >> 4 & 4 | this.cia2.iecLines << 3 & 0x80) ^ 0x85;
            }
            case 6145: 
            case 6159: {
                this.via1IFlag &= 0xFFFFFFFD;
                this.checkInterrupt(1, "read from pa");
                return 255;
            }
            case 6146: {
                return this.via1CB;
            }
            case 6147: {
                return this.via1CA;
            }
            case 6148: {
                this.via1IFlag &= 0xBF;
                this.checkInterrupt(1, "read T1 low");
                return this.via1T1Ctr & 0xFF;
            }
            case 6149: {
                return this.via1T1Ctr >> 8;
            }
            case 6150: {
                return this.via1T1Latch & 0xFF;
            }
            case 6151: {
                return this.via1T1Latch >> 8;
            }
            case 6152: {
                this.via1IFlag &= 0xDF;
                this.checkInterrupt(1, "read T2 low");
                return this.via1T2Ctr & 0xFF;
            }
            case 6153: {
                return this.via1T2Ctr >> 8;
            }
            case 6154: {
                return this.via1SerialRegister;
            }
            case 6155: {
                return this.via1AuxControl;
            }
            case 6156: {
                return this.via1PerControl;
            }
            case 6157: {
                return this.via1IFlag;
            }
            case 6158: {
                return this.via1IEnable;
            }
            case 7168: {
                return this.via2PB & 0x6F | this.sync() | this.writeProtect();
            }
            case 7169: 
            case 7183: {
                return this.readByte();
            }
            case 7170: {
                return this.via2CB;
            }
            case 7171: {
                return this.via2CA;
            }
            case 7172: {
                this.via2IFlag &= 0xBF;
                this.checkInterrupt(1, "read T1 low");
                return this.via2T1Ctr & 0xFF;
            }
            case 7173: {
                return this.via2T1Ctr >> 8;
            }
            case 7174: {
                return this.via2T1Latch & 0xFF;
            }
            case 7175: {
                return this.via2T1Latch >> 8;
            }
            case 7176: {
                this.via2IFlag &= 0xDF;
                this.checkInterrupt(2, "read T2 low");
                return this.via2T2Ctr & 0xFF;
            }
            case 7177: {
                return this.via2T2Ctr >> 8;
            }
            case 7178: {
                return this.via2SerialRegister;
            }
            case 7179: {
                return this.via2AuxControl;
            }
            case 7180: {
                return this.via2PerControl;
            }
            case 7181: {
                return this.via2IFlag;
            }
            case 7182: {
                return this.via2IEnable;
            }
        }
        return 0;
    }

    public final void performWrite(int n, int n2, long l) {
        switch (n) {
            case 6144: {
                this.via1PB = n2;
                this.updateIECLines();
                break;
            }
            case 6145: {
                this.via1IFlag &= 0xFFFFFFFD;
                this.checkInterrupt(1, "wrote pa");
                this.via1PA = n2;
                break;
            }
            case 6146: {
                this.via1CB = n2;
                this.updateIECLines();
                break;
            }
            case 6147: {
                this.via1CA = n2;
                break;
            }
            case 6148: {
                this.via1T1Latch = this.via1T1Latch & 0xFF00 | n2;
                break;
            }
            case 6149: {
                this.via1T1Latch = this.via1T1Latch & 0xFF | n2 << 8;
                this.via1IFlag &= 0xBF;
                this.via1T1Ctr = this.via1T1Latch;
                this.checkInterrupt(1, "write T1 high");
                break;
            }
            case 6150: {
                this.via1T1Latch = this.via1T1Latch & 0xFF00 | n2;
                break;
            }
            case 6151: {
                this.via1T1Latch = this.via1T1Latch & 0xFF | n2 << 8;
                break;
            }
            case 6152: {
                this.via1T2Latch = this.via1T2Latch & 0xFF00 | n2;
                break;
            }
            case 6153: {
                this.via1T2Latch = this.via1T2Latch & 0xFF | n2 << 8;
                this.via1IFlag &= 0xDF;
                this.via1T2Ctr = this.via1T1Latch;
                this.checkInterrupt(1, "write T2 high");
                break;
            }
            case 6154: {
                this.via1SerialRegister = n2;
                break;
            }
            case 6155: {
                this.via1AuxControl = n2;
                break;
            }
            case 6156: {
                this.via1PerControl = n2;
                break;
            }
            case 6157: {
                this.via1IFlag &= ~n2;
                this.checkInterrupt(1, "write IFlag");
                break;
            }
            case 6158: {
                this.via1IEnable = (n2 & 0x80) == 128 ? (this.via1IEnable |= n2 & 0x7F) : (this.via1IEnable &= ~n2);
                this.checkInterrupt(1, "write IE");
                break;
            }
            case 7168: {
                boolean bl = this.ledOn;
                boolean bl2 = this.motorOn;
                this.ledOn = (n2 & 8) != 0;
                this.motorOn = (n2 & 4) != 0;
                if (bl != this.ledOn | bl2 != this.motorOn) {
                    this.update(this, LED_MOTOR);
                }
                if (((this.via2PB ^ n2) & 3) != 0) {
                    if ((this.via2PB & 3) == (n2 + 1 & 3)) {
                        this.headOut();
                    } else if ((this.via2PB & 3) == (n2 - 1 & 3)) {
                        this.headIn();
                    }
                }
                this.via2PB = n2;
                break;
            }
            case 7169: {
                this.via2PA = n2;
                this.writeByte(n2);
                break;
            }
            case 7170: {
                this.via2CB = n2;
                break;
            }
            case 7171: {
                this.via2CA = n2;
                break;
            }
            case 7172: {
                this.via2T1Latch = this.via2T1Latch & 0xFF00 | n2;
                break;
            }
            case 7173: {
                this.via2T1Latch = this.via2T1Latch & 0xFF | n2 << 8;
                this.via2IFlag &= 0xBF;
                this.via2T1Ctr = this.via2T1Latch;
                this.checkInterrupt(2, "write T1 high: " + n2 + " latch: " + this.via2T1Latch);
                break;
            }
            case 7174: {
                this.via2T1Latch = this.via2T1Latch & 0xFF00 | n2;
                break;
            }
            case 7175: {
                this.via2T1Latch = this.via2T1Latch & 0xFF | n2 << 8;
                break;
            }
            case 7176: {
                this.via2T2Latch = this.via2T2Latch & 0xFF00 | n2;
                break;
            }
            case 7177: {
                this.via2T2Latch = this.via2T2Latch & 0xFF | n2 << 8;
                this.via2IFlag &= 0xDF;
                this.via2T2Ctr = this.via2T2Latch;
                this.checkInterrupt(2, "write T2 high");
                break;
            }
            case 7178: {
                this.via2SerialRegister = n2;
                break;
            }
            case 7179: {
                this.via2AuxControl = n2;
                break;
            }
            case 7180: {
                this.byteReadyOverflow = (n2 & 2) == 2;
                this.diskModeWrite = (n2 & 0x20) != 32;
                this.via2PerControl = n2;
                if (this.diskModeWrite) break;
                this.currentByte = -1;
                break;
            }
            case 7181: {
                this.via2IFlag &= ~n2;
                this.checkInterrupt(2, "write IFlag");
                break;
            }
            case 7182: {
                this.via2IEnable = (n2 & 0x80) == 128 ? (this.via2IEnable |= n2 & 0x7F) : (this.via2IEnable &= ~n2);
                this.checkInterrupt(2, "write IE");
            }
        }
    }

    private void writeByte(int n) {
        this.currentByte = n;
        this.log("CPU Writes byte: " + Integer.toString(n, 16) + " at " + Integer.toString(this.cpu.pc, 16));
    }

    private void finishWrite() {
        if (this.bytesWritten > 0) {
            this.convertGCRSector();
        }
        this.bytesWritten = 0;
    }

    private void checkInterrupt(int n, String string) {
        if (n == 1) {
            if ((this.via1IFlag & this.via1IEnable) == 0) {
                this.via1IFlag &= 0x7F;
                this.clearIRQ(1);
            } else {
                this.via1IFlag |= 0x80;
                this.setIRQ(1);
            }
        } else if ((this.via2IFlag & this.via2IEnable) == 0) {
            this.via2IFlag &= 0x7F;
            this.clearIRQ(2);
        } else {
            this.via2IFlag |= 0x80;
            this.setIRQ(2);
        }
    }

    public void updateIECLines() {
        int n = ~this.via1PB & this.via1CB;
        this.iecLines = n << 6 & (~n ^ this.cia2.iecLines) << 3 & 0x80 | n << 3 & 0x40;
    }

    void autoForward(long l) {
        if (this.motorOn) {
            if (this.nextAutoforward < l) {
                if (this.nextAutoforward == 0L) {
                    this.nextAutoforward = l + 32L;
                } else {
                    this.nextAutoforward += 30L;
                    this.forward();
                }
            }
        } else {
            this.nextAutoforward = l + 10000L;
        }
    }

    public final void updateChips(long l) {
        if (this.nextCheck > l) {
            return;
        }
        this.autoForward(l);
        int n = (int)(l - this.lastCycles);
        this.lastCycles = l;
        this.nextCheck = l + 13L;
        this.via1T1Ctr -= n;
        if (this.via1T1Ctr <= 0) {
            this.via1T1Ctr = (this.via1AuxControl & 0x40) == 64 ? (this.via1T1Ctr += this.via1T1Latch) : (this.via1T1Ctr &= 0xFFFF);
            this.via1IFlag |= 0x40;
            this.checkInterrupt(1, "clock wrap, T1");
        }
        if ((this.via1AuxControl & 0x20) == 0) {
            this.via1T2Ctr -= n;
            if (this.via1T2Ctr <= 0) {
                this.via1IFlag |= 0x20;
                this.via1T2Ctr &= 0xFFFF;
                this.checkInterrupt(1, "clock wrap, T2");
            }
        }
        this.via2T1Ctr -= n;
        if (this.via2T1Ctr <= 0) {
            this.via2T1Ctr = (this.via2AuxControl & 0x40) == 64 ? (this.via2T1Ctr += this.via2T1Latch) : (this.via2T1Ctr &= 0xFFFF);
            this.via2IFlag |= 0x40;
            this.checkInterrupt(2, "clock wrap, T1:  latch:" + this.via2T1Latch);
        }
        if ((this.via2AuxControl & 0x20) == 0) {
            this.via2T2Ctr -= n;
            if (this.via2T2Ctr <= 0) {
                this.via2IFlag |= 0x20;
                this.via2T2Ctr &= 0xFFFF;
                this.checkInterrupt(2, "clock wrap, T2");
            }
        }
    }

    public void diskChanged() {
        this.diskChanged = true;
        int n = 40;
        for (int i = 0; i < n; ++i) {
            int n2 = 21;
            for (int j = 0; j < n2; ++j) {
                this.gcrCacheSector[i][j] = null;
            }
        }
        byte[] byArray = this.reader.getSector(18, 0);
        this.diskID1 = byArray[162] & 0xFF;
        this.diskID2 = byArray[163] & 0xFF;
        System.out.println("Disk changed => Disk ID:" + this.diskID1 + "," + this.diskID2);
    }

    public void atnChanged(boolean bl) {
        if (bl) {
            this.via1IFlag |= 2;
            this.checkInterrupt(1, "atn went high");
        }
        this.updateIECLines();
    }

    public void reset() {
        this.track = 1;
        this.hTrack = 2;
        this.sector = 0;
        this.sectorPos = -1;
        this.diskChanged = false;
        this.writeProtected = false;
        this.currentTrackSize = C64Reader.getSectorCount(this.track);
        this.readGCRSector(this.track, this.sector);
    }

    private int writeProtect() {
        if (this.diskChanged) {
            System.out.println("C1541: //// Disk change detected???!!! ////");
            this.diskChanged = false;
            return this.writeProtected ? 16 : 0;
        }
        return this.writeProtected ? 0 : 16;
    }

    private int sync() {
        if (this.sectorPos == -1) {
            return 128;
        }
        if (this.gcrSector[this.sectorPos] == 255) {
            return 0;
        }
        return 128;
    }

    private int readByte() {
        if (this.sectorPos == -1) {
            return 0;
        }
        int n = this.gcrSector[this.sectorPos];
        return n;
    }

    private void forward() {
        if (this.diskModeWrite && this.via2CA == 255 && this.currentByte != -1 && this.sectorPos >= 0) {
            ++this.bytesWritten;
            this.gcrWriteSector[this.sectorPos] = this.currentByte;
        }
        ++this.sectorPos;
        if (this.sectorPos == 354) {
            this.finishWrite();
            this.sectorPos = -1;
            this.nextAutoforward += 1000L;
            this.sector = (this.sector + 1) % this.currentTrackSize;
            this.readGCRSector(this.track, this.sector);
        }
        this.update(this, SECTOR_UPDATE);
        if (this.diskModeWrite || this.sync() != 0 || !this.lastSync) {
            this.cpu.triggerByteReady();
        }
        this.lastSync = this.sync() == 0;
    }

    private void headOut() {
        if (this.hTrack > 2) {
            --this.hTrack;
        } else {
            ++this.headOutBeyond;
        }
        System.out.println("1541: Move head In to: " + this.hTrack);
        this.updateHTrack();
        this.update(this, HEAD_MOVED);
    }

    private void headIn() {
        if (this.hTrack < 70) {
            ++this.hTrack;
        }
        System.out.println("1541: Move head Out to: " + this.hTrack);
        this.updateHTrack();
        this.update(this, HEAD_MOVED);
    }

    private void updateHTrack() {
        if (this.track != this.hTrack >> 1) {
            this.nextAutoforward = this.cpu.cycles + 100000L;
            this.finishWrite();
            this.track = this.hTrack >> 1;
            this.sector = 0;
            this.sectorPos = -1;
            this.currentTrackSize = C64Reader.getSectorCount(this.track);
            System.out.println("1541: New Track " + this.track + " reading: " + this.track + ", " + this.sector + " s/t: " + this.currentTrackSize);
            this.readGCRSector(this.track, this.sector);
        }
    }

    private static long getGCR(int n) {
        return GCR[n >> 4] << 5 | GCR[n & 0xF];
    }

    private static char i2c(int n) {
        if (n < 32) {
            return '.';
        }
        return (char)n;
    }

    public static int makeGCR(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 ^ n3 ^ n4 ^ n5;
        long l = C1541Chips.getGCR(n2) << 30 | C1541Chips.getGCR(n3) << 20 | C1541Chips.getGCR(n4) << 10 | C1541Chips.getGCR(n5);
        long l2 = 32L;
        int n7 = 5;
        for (int i = 0; i < n7; ++i) {
            nArray[n++] = (int)(l >> (int)l2 & 0xFFL);
            l2 -= 8L;
        }
        return n6;
    }

    private void readGCRSector(int n, int n2) {
        int n3;
        this.currentTrack = n;
        this.currentSector = n2;
        if (this.gcrCacheSector[n][n2] != null) {
            this.gcrSector = this.gcrCacheSector[n][n2];
            this.gcrWriteSector = this.gcrSector;
            return;
        }
        byte[] byArray = this.reader.getSector(n, n2);
        int n4 = 0;
        int n5 = 0;
        this.gcrSector = new int[354];
        this.gcrSector[n4++] = 255;
        C1541Chips.makeGCR(this.gcrSector, n4, 8, n2 ^ n ^ this.diskID1 ^ this.diskID2, n2, n);
        C1541Chips.makeGCR(this.gcrSector, n4 += 5, this.diskID2, this.diskID1, 15, 15);
        n4 += 5;
        for (n3 = 0; n3 < 9; ++n3) {
            this.gcrSector[n4++] = 85;
        }
        this.gcrSector[n4++] = 255;
        n5 = 7;
        n5 ^= C1541Chips.makeGCR(this.gcrSector, n4, 7, byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF);
        n4 += 5;
        int n6 = 255;
        for (n3 = 3; n3 < n6; n3 += 4) {
            n5 ^= C1541Chips.makeGCR(this.gcrSector, n4, byArray[n3] & 0xFF, byArray[n3 + 1] & 0xFF, byArray[n3 + 2] & 0xFF, byArray[n3 + 3] & 0xFF);
            n4 += 5;
        }
        C1541Chips.makeGCR(this.gcrSector, n4, byArray[255] & 0xFF, (n5 ^= byArray[255] & 0xFF) & 0xFF, 0, 0);
        n4 += 5;
        n6 = 8;
        for (n3 = 0; n3 < n6; ++n3) {
            this.gcrSector[n4++] = 85;
        }
        this.gcrWriteSector = this.gcrSector;
        this.gcrCacheSector[n][n2] = this.gcrSector;
    }

    private void convertGCRSector() {
        int n;
        int[] nArray = new int[266];
        int n2 = 0;
        int n3 = 0;
        int n4 = 30;
        for (n = 5; n < n4; ++n) {
            if (this.gcrSector[n] != 255) continue;
            n3 = n + 1;
        }
        n4 = 325;
        for (n = 0; n < n4; n += 5) {
            this.convertFromGCR(nArray, n2, n + n3);
            n2 += 4;
        }
        System.out.println("Converted " + n2 + " bytes");
        byte[] byArray = new byte[256];
        int n5 = 255;
        for (n4 = 0; n4 < n5; ++n4) {
            byArray[n4] = (byte)(nArray[n4 + 1] & 0xFF);
        }
        this.reader.setSector(this.track, this.sector, byArray);
    }

    private void convertFromGCR(int[] nArray, int n, int n2) {
        long l = C1541Chips.convertFromGCR(this.gcrWriteSector[n2], this.gcrWriteSector[n2 + 1], this.gcrWriteSector[n2 + 2], this.gcrWriteSector[n2 + 3], this.gcrWriteSector[n2 + 4]);
        System.out.println("Converting (" + n2 + "): " + Long.toString(l, 16));
        nArray[n++] = (int)(l >> 24) & 0xFF;
        nArray[n++] = (int)(l >> 16) & 0xFF;
        nArray[n++] = (int)(l >> 8) & 0xFF;
        nArray[n++] = (int)l & 0xFF;
        int n3 = 4;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[n - 4 + i];
            System.out.println("Converted: " + n4 + " => " + (char)n4);
        }
    }

    public static long convertFromGCR(long l, long l2, long l3, long l4, long l5) {
        long l6 = (l << 32) + (l2 << 24) + (l3 << 16) + (l4 << 8) + l5;
        System.out.println("Converting from: " + Long.toString(l6, 16));
        long l7 = GCR_REV[(int)(l6 >> 35) & 0x1F] << 4 | GCR_REV[(int)(l6 >> 30) & 0x1F];
        long l8 = GCR_REV[(int)(l6 >> 25) & 0x1F] << 4 | GCR_REV[(int)(l6 >> 20) & 0x1F];
        long l9 = GCR_REV[(int)(l6 >> 15) & 0x1F] << 4 | GCR_REV[(int)(l6 >> 10) & 0x1F];
        long l10 = GCR_REV[(int)(l6 >> 5) & 0x1F] << 4 | GCR_REV[(int)l6 & 0x1F];
        return (l7 << 24) + (l8 << 16) + (l9 << 8) + l10;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        String string = stringArray[0];
        int[] nArray = new int[string.length() * 2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        for (n2 = 0; n2 < n6; ++n2) {
            n = string.charAt(n2) & 0xFF;
            n4 |= (GCR[n >> 4] << 5 | GCR[n & 0xF]) << n5;
            n5 += 10;
            while (n5 >= 8) {
                nArray[n3++] = n4 & 0xFF;
                n5 -= 8;
                n4 >>= 8;
            }
        }
        System.out.println("GCR Data:");
        n6 = n3;
        for (n2 = 0; n2 < n6; ++n2) {
            if (n2 % 16 == 0) {
                System.out.println("");
            }
            System.out.print(Integer.toHexString(nArray[n2]) + " ");
        }
        n4 = 0;
        n5 = 0;
        System.out.println("Decoded: ");
        n6 = n3;
        for (n2 = 0; n2 < n6; ++n2) {
            n4 |= nArray[n2] << n5;
            if ((n5 += 8) < 10) continue;
            n = n4 & 0x3FF;
            int n7 = GCR_REV[n >> 5] << 4 | GCR_REV[n & 0x1F];
            n4 >>= 10;
            n5 -= 10;
            System.out.print((char)n7);
        }
        System.out.println("");
    }

    public void stop() {
    }

    public void log(String string) {
        System.out.println("C1541: " + string);
    }
}

