/*
 * Decompiled with CFR 0.152.
 */
import com.dreamfabric.c64utils.AutoStore;
import com.dreamfabric.jac64.C64Canvas;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.DefaultIMon;
import com.dreamfabric.jac64.DirEntry;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.PatchListener;
import com.dreamfabric.jac64.SELoader;
import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jac64.VICConstants;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JWindow;

public class C64Applet
extends Applet
implements Runnable,
PatchListener {
    private CPU cpu;
    private int[] memory;
    private boolean started = false;
    private boolean stopping = false;
    private C64Reader reader;
    private String currentDisk;
    private String loadFile;
    private boolean stick = true;
    private C64Screen screen;
    private C64Canvas canvas;
    private Vector files;
    private boolean require1541 = false;
    private IMonitor imon = new DefaultIMon();
    private static Color lblue = new Color(VICConstants.COLOR_SETS[0][14]);
    private Thread thread;
    private String autostartDisk;
    private String autostartProgram;
    private String autoText;
    private int autostartID = -1;
    private int defaultStick = 0;
    private int soundOn = 0;
    private int doubleScreen = 0;
    private boolean fullscreen = false;
    private JFrame fullFrame = null;
    private JWindow fullWin = null;

    public void init() {
        this.started = false;
        this.stopping = false;
        this.currentDisk = null;
        if (this.cpu == null) {
            SIDMixer.DL_BUFFER_SIZE = 16384;
            System.out.println("starting CPU");
            this.cpu = new CPU(this.imon, this.getCodeBase().toString(), new SELoader());
            System.out.println("Status: initializing");
            this.doubleScreen = this.getParameterAsInt("doubleScreen", 0);
            int n = this.getParameterAsInt("freescale", 0);
            this.screen = new C64Screen(this.imon, this.doubleScreen > 0);
            this.cpu.init(this.screen);
            this.screen.init(this.cpu);
            if (n != 0) {
                this.screen.setIntegerScaling(false);
            }
            this.memory = this.cpu.getMemory();
            this.setLayout(new BorderLayout());
            this.setBackground(Color.black);
            this.setForeground(lblue);
            this.reader = new C64Reader();
            this.reader.setCPU(this.cpu);
            this.canvas = (C64Canvas)this.screen.getScreen();
            this.fullscreen(this.fullscreen);
            this.screen.registerHotKey(8, 640, "reset()", this.cpu);
            this.screen.registerHotKey(123, 128, "toggleFullscreen()", this);
            this.repaint();
            this.validate();
            this.addKeyListener(this.canvas);
            this.canvas.requestFocus();
            this.cpu.getDrive().setReader(this.reader);
            AudioClip audioClip = null;
            AudioClip audioClip2 = null;
            URL uRL = this.getClass().getResource("sounds/track.wav");
            System.out.println("Audio URL:" + uRL);
            if (uRL != null) {
                audioClip = Applet.newAudioClip(uRL);
            }
            if ((uRL = this.getClass().getResource("sounds/motor.wav")) != null) {
                audioClip2 = Applet.newAudioClip(uRL);
            }
            this.screen.setSounds(audioClip, audioClip2);
            this.setColorSet(this.getParameterAsInt("colorset", 0));
            int n2 = this.getParameterAsInt("require1541", 0);
            this.require1541 = n2 == 1;
            int n3 = 12;
            for (int i = 0; i < n3; ++i) {
                String string = this.getParameter("hotkey-f" + (i + 1));
                if (string == null || string.length() <= 0) continue;
                this.screen.registerHotKey(112 + i, 512, string, this);
            }
        }
    }

    public void toggleFullscreen() {
        this.fullscreen(!this.fullscreen);
    }

    public void fullscreen(boolean bl) {
        this.fullscreen = bl;
        if (bl) {
            this.remove(this.canvas);
            if (this.fullFrame == null) {
                this.fullFrame = new JFrame("-");
                this.fullWin = new JWindow(this.fullFrame);
                this.fullWin.addKeyListener(this.canvas);
            }
            this.screen.setAutoscale(true);
            this.fullWin.add(this.canvas);
            this.fullWin.setSize(100, 100);
            this.fullWin.setVisible(true);
            this.fullFrame.setVisible(true);
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullWin);
            this.fullWin.setFocusable(true);
        } else {
            if (this.fullFrame != null) {
                this.fullFrame.setVisible(false);
                this.fullWin.setVisible(false);
            }
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
            this.add((Component)this.canvas, "Center");
            this.validate();
        }
    }

    private void autoload() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                C64Applet.this.autoText = C64Applet.this.getParameter("autostartCode");
                C64Applet.this.autostartDisk = C64Applet.this.getParameter("autostartDisk");
                if (C64Applet.this.autostartDisk != null) {
                    C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartPGM");
                    if (C64Applet.this.autostartProgram == null) {
                        C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartProgram");
                    }
                } else {
                    C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartPGM");
                    C64Applet.this.autostartID = C64Applet.this.getParameterAsInt("autostartProgram", -1);
                }
                C64Applet.this.defaultStick = C64Applet.this.getParameterAsInt("joystick", 0);
                C64Applet.this.soundOn = C64Applet.this.getParameterAsInt("soundOn", 1);
                if (C64Applet.this.getParameterAsInt("extendedKeyboard", 0) != 0) {
                    C64Applet.this.screen.setKeyboardEmulation(true);
                    System.out.println("Extended keyboard emulation on!");
                }
                C64Applet.this.loadGamesList();
                C64Applet.this.screen.setSoundOn(C64Applet.this.soundOn == 1);
                C64Applet.this.screen.setStick(C64Applet.this.defaultStick == 0);
                if (C64Applet.this.autostartDisk != null) {
                    if (C64Applet.this.autostartProgram != null) {
                        C64Applet.this.loadGame(C64Applet.this.autostartDisk, C64Applet.this.autostartProgram);
                    } else {
                        C64Applet.this.insertDisk(C64Applet.this.autostartDisk);
                        C64Applet.this.resetAndWait();
                        C64Applet.this.enterText(C64Applet.this.autoText);
                    }
                } else if (C64Applet.this.autostartProgram != null) {
                    if (C64Applet.this.autostartProgram.equals("random")) {
                        int n = (int)(Math.random() * (double)(C64Applet.this.files.size() / 2));
                        C64Applet.this.loadGame(n);
                    } else {
                        C64Applet.this.loadPGM(C64Applet.this.autostartProgram);
                    }
                }
                if (C64Applet.this.autostartID != -1) {
                    System.out.println("AutostartID: " + C64Applet.this.autostartID);
                    C64Applet.this.loadGame(C64Applet.this.autostartID);
                }
                C64Applet.this.started = true;
            }
        });
        thread.start();
    }

    public void start() {
        System.out.println("Starting applet...");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            this.autoload();
        } else {
            this.unpause();
            this.started = true;
        }
    }

    public void stop() {
        System.out.println("Status: stopping");
        this.pause();
        this.screen.motorSound(false);
    }

    public void destroy() {
        System.out.println("APPLET DESTROY CALLED");
        this.cpu.stop();
        this.screen.motorSound(false);
        this.screen.getMixer().shutdown();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void run() {
        if (this.started && !this.stopping) {
            System.out.println("Status: running");
            this.cpu.start();
        } else {
            this.cpu.start();
        }
        this.stopping = false;
        this.thread = null;
    }

    private int getParameterAsInt(String string, int n) {
        String string2 = this.getParameter(string);
        System.out.println(string + " = " + string2);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println("Can not parse value: " + string2);
            }
        }
        return n;
    }

    private void loadGamesList() {
        System.out.println("Trying to load games list");
        try {
            String string;
            URL uRL = this.getResource("games.txt");
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.files = new Vector();
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).toLowerCase().endsWith(".prg") || string.toLowerCase().endsWith(".p00")) {
                    this.files.addElement(string);
                    this.files.addElement(string);
                    continue;
                }
                String string2 = lineNumberReader.readLine();
                if (string2 == null) continue;
                string2 = string2.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = stringTokenizer.nextToken();
                    this.files.addElement(string);
                    this.files.addElement(string3);
                    System.out.println("Adding: " + string3);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Can not load games..." + exception);
            exception.printStackTrace();
            System.out.println("No games to load...");
        }
    }

    public void setColorSet(int n) {
        this.screen.setColorSet(n %= VICConstants.COLOR_SETS.length);
    }

    public void poke(int n, int n2) {
        if (n < 53248 || n >= 57344) {
            int[] nArray = this.cpu.getMemory();
            nArray[n & 0xFFFF] = n2 & 0xFF;
        } else {
            this.cpu.poke(n & 0xFFFF, n2 & 0xFF);
        }
    }

    public int peek(int n) {
        int[] nArray = this.cpu.getMemory();
        return nArray[n & 0xFFFF];
    }

    public void pause() {
        this.cpu.setPause(true);
    }

    public void unpause() {
        this.cpu.setPause(false);
    }

    private void loadProgram(int n) {
        String string = (String)this.files.elementAt(n * 2);
        String string2 = (String)this.files.elementAt(n * 2 + 1);
        System.out.println("Index:" + n + " -> " + string + " " + string2);
        this.loadProgram(string, string2);
    }

    private boolean loadProgram(String string, String string2) {
        boolean bl = this.require1541;
        if (string.startsWith("@")) {
            string = string.substring(1);
            bl = true;
        }
        if (string != this.currentDisk) {
            URL uRL = this.getResource(string);
            this.currentDisk = string;
            if ((string = string.toLowerCase()).endsWith(".d64")) {
                if (!this.reader.readDiskFromURL(uRL)) {
                    System.out.println("Status: problem while loading disk");
                }
            } else if (string.endsWith(".t64")) {
                if (!this.reader.readTapeFromURL(uRL)) {
                    System.out.println("Status: problem while loading tape");
                }
            } else if (string.endsWith(".prg") || string.endsWith(".p00")) {
                if (!this.reader.readPGM(uRL, -1)) {
                    System.out.println("Status: problem while loading pgm");
                } else {
                    System.out.println("Status: loaded " + string);
                }
                return false;
            }
        }
        if (bl) {
            System.out.println("Loading with C1541 emulation...");
            this.enterText("load \"" + string2 + "\",8~");
            this.enterText("run~");
            return true;
        }
        for (int i = string2.length(); i < 16; ++i) {
            string2 = string2 + " ";
        }
        if (this.reader.readFile(string2) != null) {
            System.out.println("Status: loaded " + string2);
        } else {
            System.out.println("Status: error while loading " + string2);
        }
        return false;
    }

    public void loadPGM(String string) {
        this.resetAndWait();
        URL uRL = this.getResource(string);
        if (!this.reader.readPGM(uRL, -1)) {
            System.out.println("Status: problem while loading pgm");
        }
        this.cpu.runBasic();
        this.canvas.requestFocus();
    }

    public void insertDisk(String string) {
        URL uRL;
        if (string.startsWith("@")) {
            string = string.substring(1);
        }
        if (!this.reader.readDiskFromURL(uRL = this.getResource(string))) {
            System.out.println("Status: problem while inserting disk: " + uRL);
        }
    }

    public void enterText(String string) {
        this.cpu.enterText(string);
    }

    public void loadPGM(String string, String string2) {
        this.loadGame(string, string2);
    }

    public void loadGame(String string, String string2) {
        this.resetAndWait();
        System.out.println("Loading " + string2 + " from " + string);
        if (!this.loadProgram(string, string2)) {
            this.cpu.runBasic();
        }
        this.canvas.requestFocus();
    }

    private void resetAndWait() {
        this.cpu.reset();
        while (!this.screen.ready()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println("Exception while sleeping... C64Applet");
            }
        }
    }

    public void loadGame(int n) {
        this.resetAndWait();
        this.loadProgram(n);
        this.cpu.runBasic();
        this.canvas.requestFocus();
    }

    public void setStick(int n) {
        System.out.println("Setting stick: one ? " + (n == 0));
        this.screen.setStick(n == 0);
        this.canvas.requestFocus();
    }

    public void setSoundOn(boolean bl) {
        this.screen.setSoundOn(bl);
    }

    public void setScanRate(int n) {
        this.screen.setScanRate(n);
    }

    public void reset() {
        System.out.println("Reset - no kill");
        this.cpu.reset();
        this.canvas.requestFocus();
    }

    private URL getResource(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            try {
                uRL = new URL(this.getCodeBase().toString() + string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRL;
    }

    public void setEffect(int n) {
        this.screen.getMixer().setEFX(n);
    }

    public void saveFile(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "name=" + URLEncoder.encode(string) + "&description=" + URLEncoder.encode(string3) + "&author=" + URLEncoder.encode(string2) + "&file=" + this.reader.saveFile();
        System.out.println("Saving file: " + string4);
        try {
            int n;
            URL uRL = this.getResource("prgup.php");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string4);
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            System.out.println("Read back:");
            while ((n = inputStream.read()) != -1) {
                System.out.print((char)n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean readFile(String string, int n) {
        string = string.trim();
        System.out.println("Should load: \"" + string + "\"");
        if ("$".equals(string)) {
            System.out.println("Entering basic data");
            ArrayList arrayList = this.reader.getDirNames();
            int n2 = 2048;
            this.memory[n2++] = 0;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                DirEntry dirEntry = this.reader.getDirEntry((String)arrayList.get(i));
                String string2 = dirEntry.name;
                int n4 = n2 + 5 + string2.length();
                System.out.println("Name:  " + string2 + " " + string2.length());
                System.out.println("Next:  " + n4);
                System.out.println("Pos:  " + n2);
                this.memory[n2++] = n4 & 0xFF;
                this.memory[n2++] = n4 >> 8;
                this.memory[n2++] = dirEntry.size & 0xFF;
                this.memory[n2++] = dirEntry.size >> 8;
                for (int j = 0; j < string2.length(); ++j) {
                    this.memory[n2++] = string2.charAt(j);
                }
                this.memory[n2++] = 0;
            }
            return true;
        }
        for (int i = string.length(); i < 16; ++i) {
            string = string + " ";
        }
        return this.reader.readFile(string, n) != null;
    }

    public void enableAutoStore(int n) {
        this.cpu.setCheatEnabled(n);
    }

    public void setAutoStore(int n, String string) {
        AutoStore autoStore = new AutoStore(string);
        this.cpu.setAutoStore(n, autoStore);
    }

    public void protect(int n, int n2) {
        this.cpu.protect(n, n2);
    }

    public void monitorRead(int n) {
        this.cpu.monitorRead(n);
    }

    public void monitorWrite(int n) {
        this.cpu.monitorWrite(n);
    }

    public void addAutoStoreRule(int n, String string) {
        this.cpu.getAutoStore(n).addRule(string);
    }

    public void addAutoStoreStore(int n, int n2, int n3, String string) {
        this.cpu.getAutoStore(n).addStore(n2, n3, string);
    }
}

