/*
 *  APPENV - APPend to ENVironment  --2.0--  Copyright (c) Mark Lord, 1989
 *
 *  Feel free to copy, use and/or modify this for any non-commercial
 *  purpose(s).  Please keep this copyright header in place.
 *
 *  Rewritten for PharLap (HighC) and djgpp (GNU C),  G. Vanem 1997
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <tcp.h>

#if defined (__DJGPP__)
  #include <go32.h>
  #define _psp _go32_info_block.linear_address_of_original_psp;

  char AppendEnv (char *symbol, char *val)
  {
    return (0);
  }

#elif defined (__HIGHC__)
  #include <pharlap.h>

  char AppendEnv (char *symbol, char *val)
  {
    return (0);
  }
#else   /* real-mode, small/large model */

  char AppendEnv (char *symbol, char *val)
  {
    int      size;
    unsigned psp;
    unsigned far *tmp;
    char far *env;
    char far *e;
    char far *p;
    char varbuf[1024];
    char *v;

    /*
     * _psp is our PSP.  Follow the "parent" links back
     * until we find a PSP for COMMAND.COM, which has
     * a parent link that points at itself.
     */

    psp = _psp;
    while (psp != *(tmp = MK_FP(psp,22)))
           psp = *tmp;

    /*
     * Now get the address of COMMAND.COM's environment
     * block from its PSP.
     */

    env = MK_FP (*(unsigned short far *)MK_FP(psp,44),0);

    /* Get the block size from the MCB which immediately preceeds the
     * environment block.  This is a paragraph count, which must be
     * multiplied by 16 to get a byte count.
     */

    size = 16 * (*(int far*) MK_FP(FP_SEG(env)-1,3));

    strcpy (varbuf, strupr(symbol));
    strcat (varbuf, "=");

    /*
     * The outer loop below searches for an existing environment
     * variable of the same name as we have in varbuf[].
     */

    while (*env)
    {
      /* Compare current env variable with varbuf[]. */

      e = env;
      v = (char *) &varbuf;
      while (*e++ == *v++ && *v) ;

      /*
       * If they matched, copy old value into varbuf[], and then delete
       * it from the environment.  Otherwise, move env to point at the
       * next environment variable for the next iteration of our main loop.
       */

      if (!*v)
      {
        while ((*v++ = *e++) != 0) ;
        if (*e)
           while (--size && ((*env++ = *e++) != 0 || *e))
                 ;
        *env = '\0';
      }
      else
        while (--size && *env++)
              ;
    }

    /*
     * If no data was entered after the equal sign, then we are supposed
     * to delete the variable, which we've already done. Otherwise, some
     * work remains.  We have to re-add the variable at the end of the
     * environment with its old value, and then append the new value after it.
     */

    p = val;

    if (*p)
    {
      /* Copy name, equal sign, and old value into env. */

      v = strchr (varbuf, '=');
      *++v = 0;

      v = &varbuf[0];
      while ((*env = *v++) != 0)
            ++env, --size;

      /* Now append new data to the end of the old value. */

      while (--size && (*env++ = *p++) != 0)
            ;

      /*
       * Ensure the environment is properly terminated with
       * two consecutive zeros.
       */

      *env   = '\0';
      *--env = '\0';

      if (size <= 0)
         return (-1);
    }
    return (0);
  }

#endif   /* real-mode, small/large model */


#if defined (TEST)

int main (int argc, char **argv)
{
  static char *spawn_arg = "spawn_test";
  char   cmd[80];
  char  *prog;
  int    bcc    = (strstr(argv[0],".EXE") != NULL);
  int    djgpp  = (strstr(argv[0],".exe") != NULL);

  if (argc > 1 && !strcmp(argv[1],spawn_arg))
  {
    printf ("child (%s):  !watt_proxy = %s\n",
            djgpp ? "djgpp" : bcc ? "bcc" : "phar",
            getenv("!watt_proxy"));
    return (-1);
  }
   
  if (djgpp)      /* djgpp .exe file */
  {
    prog = "run386 appenv.exp";
    puts ("I'm a djgpp program spawning Pharlap");
  }
  else if (bcc)   /* Borland .exe */
  {
    prog = "run386 appenv.exp";
    puts ("I'm a Borland program spawning Pharlap");
  }
  else
  {
    prog = "appenv.exe";
    puts ("I'm a Pharlap program spawning djgpp/Borland");
  }

  putenv ("!watt_proxy=100,200,300");
  printf ("parent: !watt_proxy = %s\n", getenv("!watt_proxy"));

  sprintf (cmd,"%s %s", prog, spawn_arg);
  printf ("system() = %d\n", system(cmd));

  printf ("parent: !watt_proxy = %s\n", getenv("!watt_proxy"));
  return (10);
}

#endif   /* TEST */
